/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ISimpleSplitHandler;
import com.bigdata.btree.IndexSegment;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.AbstractResult;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.IncrementalBuildTask;
import com.bigdata.resources.MoveTask;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.SplitIndexPartitionTask;
import com.bigdata.resources.SplitResult;
import com.bigdata.resources.SplitUtility;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.Split;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ScatterSplitTask
extends AbstractPrepareTask<AbstractResult> {
    protected final ViewMetadata vmd;
    protected final int nsplits;
    protected final UUID[] moveTargets;
    protected final long adjustedNominalShardSize;

    protected ScatterSplitTask(ViewMetadata vmd, int nsplits, UUID[] moveTargets) {
        super(vmd.resourceManager, TimestampUtility.asHistoricalRead(vmd.commitTime), vmd.name);
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        this.vmd = vmd;
        if (vmd.pmd == null) {
            throw new IllegalStateException("Not an index partition.");
        }
        if (!vmd.compactView) {
            throw new IllegalStateException("Not a compact view.");
        }
        if (vmd.pmd.getSourcePartitionId() != -1) {
            throw new IllegalStateException("Split not allowed during move: sourcePartitionId=" + vmd.pmd.getSourcePartitionId());
        }
        if (nsplits <= 1) {
            throw new IllegalArgumentException();
        }
        if (moveTargets != null) {
            if (moveTargets.length == 0) {
                throw new IllegalArgumentException();
            }
            for (UUID t : moveTargets) {
                if (t != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.nsplits = nsplits;
        this.moveTargets = moveTargets;
        this.adjustedNominalShardSize = vmd.sumSegBytes / (long)(nsplits / 2);
    }

    @Override
    protected void clearRefs() {
        this.vmd.clearRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected AbstractResult doTask() throws Exception {
        SplitResult splitResult;
        Event e;
        block22: {
            Object[] splits;
            ILocalBTreeView src;
            String name;
            SplitResult splitResult2;
            block19: {
                AbstractResult abstractResult;
                block20: {
                    e = new Event(this.resourceManager.getFederation(), new EventResource(this.vmd.indexMetadata), (Object)OverflowActionEnum.ScatterSplit, this.vmd.getParams()).addDetail("summary", (Object)((Object)OverflowActionEnum.ScatterSplit) + "+" + (Object)((Object)OverflowActionEnum.Move) + "(" + this.vmd.name + ", nsplits=" + this.nsplits + ")").addDetail("moveTargets", Arrays.toString(this.moveTargets)).start();
                    splitResult2 = null;
                    if (this.resourceManager.isOverflowAllowed()) {
                        throw new IllegalStateException();
                    }
                    name = this.vmd.name;
                    src = this.vmd.getView();
                    ISimpleSplitHandler splitHandler = this.vmd.indexMetadata.getSplitHandler();
                    splits = SplitUtility.getSplits(this.resourceManager, this.vmd.pmd, (IndexSegment)src.getSources()[1], this.adjustedNominalShardSize, splitHandler);
                    if (splits != null) break block19;
                    double overextension = (double)this.vmd.sumSegBytes / (double)this.resourceManager.nominalShardSize;
                    this.resourceManager.getClass();
                    if (overextension > 2.0 && !this.resourceManager.isDisabledWrites(this.vmd.name)) {
                        log.error("Shard will not split - writes are disabled: name=" + this.vmd.name + ", size=" + this.vmd.sumSegBytes + ", overextended=" + (int)overextension + "x" + ", splitHandler=" + (splitHandler == null ? "N/A" : splitHandler.getClass().getName()));
                        this.resourceManager.disableWrites(this.vmd.name);
                    }
                    log.warn("No splits identified: will build: " + this.vmd);
                    abstractResult = this.concurrencyManager.submit(new IncrementalBuildTask(this.vmd)).get();
                    this.clearRefs();
                    if (splitResult2 == null) break block20;
                    for (BuildResult buildResult : splitResult2.buildResults) {
                        if (buildResult == null) continue;
                        this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
                    }
                }
                e.end();
                return abstractResult;
            }
            try {
                block21: {
                    int nsplits = splits.length;
                    if (INFO) {
                        log.info("Will build index segments for " + nsplits + " splits for " + name + " : " + Arrays.toString(splits));
                    }
                    SplitUtility.validateSplits(src, (Split[])splits);
                    splitResult2 = SplitUtility.buildSplits(this.vmd, (Split[])splits, e);
                    break block21;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        this.clearRefs();
                    }
                }
                SplitIndexPartitionTask.doSplitAtomicUpdate(this.resourceManager, this.vmd, splitResult2, OverflowActionEnum.ScatterSplit, this.resourceManager.overflowCounters.indexPartitionSplitCounter, e);
                int nsplits = splitResult2.buildResults.length;
                ArrayList<MoveTask.AtomicUpdate> moveTasks = new ArrayList<MoveTask.AtomicUpdate>(nsplits);
                for (int i = 0; i < nsplits; ++i) {
                    UUID moveTarget = this.moveTargets[i % this.moveTargets.length];
                    if (this.resourceManager.getDataServiceUUID().equals(moveTarget)) {
                        if (!INFO) continue;
                        log.info("Ignoring move to self.");
                        continue;
                    }
                    int newPartitionId = this.resourceManager.nextPartitionId(this.vmd.indexMetadata.getName());
                    String nameOfPartitionToMove = DataService.getIndexPartitionName(this.vmd.indexMetadata.getName(), splitResult2.splits[i].pmd.getPartitionId());
                    moveTasks.add(new MoveTask.AtomicUpdate(this.resourceManager, nameOfPartitionToMove, splitResult2.buildResults[i], moveTarget, newPartitionId, e));
                }
                List futures = this.resourceManager.getConcurrencyManager().invokeAll(moveTasks);
                for (Future f : futures) {
                    if (f.isCancelled()) continue;
                    try {
                        f.get();
                    }
                    catch (ExecutionException ex) {
                        log.error(ex, ex);
                    }
                }
                splitResult = splitResult2;
                if (splitResult2 == null) break block22;
            }
            catch (Throwable throwable) {
                if (splitResult2 != null) {
                    for (BuildResult buildResult : splitResult2.buildResults) {
                        if (buildResult == null) continue;
                        this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
                    }
                }
                e.end();
                throw throwable;
            }
            for (BuildResult buildResult : splitResult2.buildResults) {
                if (buildResult == null) continue;
                this.resourceManager.retentionSetRemove(buildResult.segmentMetadata.getUUID());
            }
        }
        e.end();
        return splitResult;
    }
}

