/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore.sector;

import com.bigdata.rwstore.IWriteCacheManager;
import com.bigdata.rwstore.sector.ISectorManager;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SectorAllocator
implements Comparable<SectorAllocator> {
    private static final Logger log = Logger.getLogger(SectorAllocator.class);
    static final int SECTOR_INDEX_BITS = 16;
    static final int SECTOR_OFFSET_BITS = 16;
    static final int SECTOR_OFFSET_MASK = SectorAllocator.getBitMask(16);
    static final int META_SIZE = 8192;
    static final int SECTOR_SIZE = 0x4000000;
    static final int NUM_ENTRIES = 1636;
    final int[] BIT_MASKS = new int[]{1, 3, 7, 15, 255, 65535, -1};
    public static final int BLOB_SIZE = 4096;
    static final int BLOB_CHAIN_OFFSET = 4092;
    public static final int[] ALLOC_SIZES = new int[]{64, 128, 256, 512, 1024, 2048, 4096};
    static final int[] ALLOC_BITS = new int[]{32, 32, 32, 32, 32, 32, 32};
    int m_index;
    long m_sectorAddress;
    int m_maxSectorSize;
    byte[] m_tags = new byte[1636];
    int[] m_bits = new int[1636];
    int[] m_transientbits = new int[1636];
    int[] m_commitbits = new int[1636];
    int[] m_addresses = new int[1636];
    int[] m_free = new int[ALLOC_SIZES.length];
    int[] m_total = new int[ALLOC_SIZES.length];
    int[] m_allocations = new int[ALLOC_SIZES.length];
    int[] m_recycles = new int[ALLOC_SIZES.length];
    final ISectorManager m_store;
    boolean m_onFreeList = false;
    private final IWriteCacheManager m_writes;
    private boolean m_preserveSession;

    static final int getBitMask(int bits) {
        int ret = 0;
        for (int i = 0; i < bits; ++i) {
            ret += 1 << i;
        }
        return ret;
    }

    public SectorAllocator(ISectorManager store, IWriteCacheManager writes) {
        this.m_store = store;
        this.m_writes = writes;
    }

    static byte getTag(int size) {
        byte tag = 0;
        while (size > ALLOC_SIZES[tag]) {
            tag = (byte)(tag + 1);
        }
        return tag;
    }

    public int alloc(int size) {
        if (size > 4096) {
            throw new IllegalArgumentException("Cannot directly allocate a BLOB, use PSOutputStream");
        }
        byte tag = SectorAllocator.getTag(size);
        assert (this.m_free[tag] > 0);
        int sbit = 0;
        int lbits = 0;
        for (int i = 0; i < 1636; ++i) {
            int bits;
            int bit;
            byte ttag = this.m_tags[i];
            if (ttag == -1) {
                throw new IllegalStateException("Allocator should not be on the FreeList for tag: " + ALLOC_SIZES[tag]);
            }
            lbits = ALLOC_BITS[ttag];
            if (ttag == tag && (bit = this.fndBit(bits = this.m_transientbits[i])) != -1) {
                sbit += bit;
                if (log.isTraceEnabled()) {
                    log.trace("Setting bit: " + sbit);
                }
                SectorAllocator.setBit(this.m_bits, sbit);
                SectorAllocator.setBit(this.m_transientbits, sbit);
                if (!SectorAllocator.tstBit(this.m_bits, sbit)) {
                    throw new IllegalStateException("WTF with bit:" + sbit);
                }
                byte by = tag;
                this.m_free[by] = this.m_free[by] - 1;
                byte by2 = tag;
                this.m_allocations[by2] = this.m_allocations[by2] + 1;
                if (this.m_free[tag] == 0 && this.m_onFreeList && !this.addNewTag(tag)) {
                    if (log.isInfoEnabled()) {
                        log.info("Removing Sector #" + this.m_index + ": " + this.toString());
                    }
                    this.m_store.removeFromFreeList(this);
                    this.m_onFreeList = false;
                }
                int raddr = SectorAllocator.makeAddr(this.m_index, sbit);
                if (log.isTraceEnabled()) {
                    log.trace("Allocating " + this.m_index + ":" + sbit + " as " + raddr + " for " + size);
                }
                if (SectorAllocator.getSectorIndex(raddr) != this.m_index) {
                    throw new IllegalStateException("Address: " + raddr + " does not yield index: " + this.m_index);
                }
                return raddr;
            }
            sbit += lbits;
        }
        return 0;
    }

    public static int makeAddr(int index, int bit) {
        return -((index + 1 << 16) + bit);
    }

    private boolean addNewTag(byte tag) {
        int allocated = 0;
        for (int i = 0; i < this.m_tags.length; ++i) {
            if (this.m_tags[i] == -1) {
                int block = ALLOC_SIZES[tag] * 32;
                if (allocated + block <= this.m_maxSectorSize) {
                    this.m_tags[i] = tag;
                    byte by = tag;
                    this.m_free[by] = this.m_free[by] + 32;
                    byte by2 = tag;
                    this.m_total[by2] = this.m_total[by2] + 1;
                    if (i < this.m_tags.length - 1) {
                        this.m_addresses[i + 1] = this.m_addresses[i] + 32 * ALLOC_SIZES[tag];
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("addNewTag block for: " + ALLOC_SIZES[tag]);
                    }
                    if (i + 1 == this.m_tags.length) {
                        int trim = this.m_maxSectorSize - (allocated + block);
                        this.m_store.trimSector(trim, this);
                    }
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("addNewTag FALSE due to Sector SIZE");
                }
                return false;
            }
            allocated += ALLOC_SIZES[this.m_tags[i]] * 32;
        }
        if (log.isDebugEnabled()) {
            log.debug("addNewTag FALSE due to Sector BITS");
        }
        return false;
    }

    public boolean free(int bit) {
        if (!SectorAllocator.tstBit(this.m_bits, bit)) {
            throw new IllegalStateException("Request to free bit not set: " + bit);
        }
        SectorAllocator.clrBit(this.m_bits, bit);
        if (!SectorAllocator.tstBit(this.m_commitbits, bit)) {
            if (!SectorAllocator.tstBit(this.m_transientbits, bit)) {
                throw new IllegalStateException("Request to free transient bit not set" + bit);
            }
            if (!this.m_preserveSession) {
                int tag;
                SectorAllocator.clrBit(this.m_transientbits, bit);
                int n = tag = this.bit2tag(bit);
                this.m_free[n] = this.m_free[n] + 1;
                int n2 = tag;
                this.m_recycles[n2] = this.m_recycles[n2] + 1;
            }
            if (!this.m_onFreeList && this.hasFree(2)) {
                this.m_onFreeList = true;
                if (log.isInfoEnabled()) {
                    log.info("Returning Sector #" + this.m_index + ": " + this.toString());
                }
                this.m_store.addToFreeList(this);
            }
            if (this.m_writes != null && this.m_writes.removeWriteToAddr(this.getPhysicalAddress(bit), 0) && log.isTraceEnabled()) {
                log.trace("Removed potential DUPLICATE");
            }
        }
        return false;
    }

    int bit2Size(int bit) {
        for (int t = 0; t < 1636; ++t) {
            byte tag = this.m_tags[t];
            if (tag == -1) {
                throw new IllegalStateException("bit offset too large");
            }
            int bits = ALLOC_BITS[tag];
            if (bit < bits) {
                return ALLOC_SIZES[tag];
            }
            bit -= bits;
        }
        return 0;
    }

    int bit2Offset(int bit) {
        int entry = bit / 32;
        int entryBit = bit % 32;
        assert (entry < this.m_addresses.length);
        int offset = this.m_addresses[entry];
        return offset += entryBit * ALLOC_SIZES[this.m_tags[entry]];
    }

    public int bit2tag(int bit) {
        return this.m_tags[bit / 32];
    }

    public long getPhysicalAddress(int offset) {
        if (!SectorAllocator.tstBit(this.m_transientbits, offset)) {
            return 0L;
        }
        return this.m_sectorAddress + (long)this.bit2Offset(offset);
    }

    public int getPhysicalSize(int offset) {
        return this.bit2Size(offset);
    }

    public long getStartAddr() {
        return this.m_sectorAddress;
    }

    public String getStats() {
        return null;
    }

    public boolean hasFree(int threshold) {
        for (int i = 0; i < this.m_free.length; ++i) {
            if (this.m_free[i] >= threshold * this.m_total[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasFree() {
        return this.hasFree(1);
    }

    public void preserveSessionData() {
        this.m_preserveSession = true;
    }

    public int addressSize(int offset) {
        return this.bit2Size(offset);
    }

    public void setIndex(int index) {
        assert (this.m_index == 0);
        this.m_index = index;
    }

    public void addAddresses(ArrayList<Long> addrs) {
        addrs.add(this.m_sectorAddress);
    }

    static void clrBit(int[] bits, int bitnum) {
        int index = bitnum / 32;
        int bit = bitnum % 32;
        int val = bits[index];
        bits[index] = val &= ~(1 << bit);
    }

    static void setBit(int[] bits, int bitnum) {
        int index = bitnum / 32;
        int bit = bitnum % 32;
        int n = index;
        bits[n] = bits[n] | 1 << bit;
    }

    static boolean tstBit(int[] bits, int bitnum) {
        int index = bitnum / 32;
        int bit = bitnum % 32;
        return (bits[index] & 1 << bit) != 0;
    }

    int fndBit(int bits) {
        for (int n = 0; n < 8; ++n) {
            if ((bits & 0xF) != 15) {
                for (int b = 0; b < 4; ++b) {
                    if ((bits & 1 << b) != 0) continue;
                    return b + n * 4;
                }
            }
            bits >>>= 4;
        }
        return -1;
    }

    public void setSectorAddress(long sectorAddress, int maxsize) {
        int i;
        if (log.isInfoEnabled()) {
            log.info("setting sector #" + this.m_index + " address: " + sectorAddress);
        }
        this.m_sectorAddress = sectorAddress;
        this.m_maxSectorSize = maxsize;
        this.m_addresses[0] = 0;
        for (i = 0; i < ALLOC_SIZES.length; ++i) {
            this.m_tags[i] = (byte)i;
            this.m_free[i] = 32;
            this.m_total[i] = 1;
            this.m_addresses[i + 1] = this.m_addresses[i] + 32 * ALLOC_SIZES[i];
        }
        for (i = ALLOC_SIZES.length; i < 1636; ++i) {
            this.m_tags[i] = -1;
        }
        this.m_onFreeList = true;
        this.m_store.addToFreeList(this);
    }

    public static int getSectorIndex(int rwaddr) {
        return (-rwaddr >>> 16) - 1;
    }

    public static int getSectorOffset(int rwaddr) {
        return -rwaddr & SECTOR_OFFSET_MASK;
    }

    public static int getBlobBlockCount(int size) {
        int nblocks = (size + 4096 - 1) / 4096;
        return nblocks;
    }

    public static int getBlockForSize(int size) {
        for (int i = 0; i < ALLOC_SIZES.length; ++i) {
            if (size > ALLOC_SIZES[i]) continue;
            return ALLOC_SIZES[i];
        }
        throw new IllegalArgumentException("Size does not fit in a slot");
    }

    @Override
    public int compareTo(SectorAllocator other) {
        int oindex = other.m_index;
        return this.m_index < oindex ? -1 : (this.m_index > oindex ? 1 : 0);
    }

    public int getIndex() {
        return this.m_index;
    }

    public void releaseSession(IWriteCacheManager cache) {
        for (int i = 0; i < this.m_bits.length; ++i) {
            this.m_transientbits[i] = this.m_commitbits[i] | this.m_bits[i];
        }
        this.m_preserveSession = false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int t = 0; t < this.m_free.length; ++t) {
            str.append("(" + this.m_free[t] / this.m_total[t] + ")[T" + this.m_total[t] * 32 + ",A" + this.m_allocations[t] + ",F" + this.m_free[t] + ",R" + this.m_recycles[t] + "]");
        }
        return str.toString();
    }

    public void commit() {
        this.m_commitbits = (int[])this.m_bits.clone();
        if (!this.m_preserveSession) {
            this.m_transientbits = (int[])this.m_bits.clone();
        }
    }

    public boolean isCommitted(int offset) {
        return SectorAllocator.tstBit(this.m_commitbits, offset);
    }

    public boolean isGettable(int offset) {
        return SectorAllocator.tstBit(this.m_transientbits, offset);
    }
}

