/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.AbstractIndexTask;
import com.bigdata.search.FullTextIndex;
import com.bigdata.util.BytesUtil;
import org.apache.log4j.Logger;

public class CountIndexTask<V extends Comparable<V>>
extends AbstractIndexTask<V> {
    private static final Logger log = Logger.getLogger(CountIndexTask.class);
    private final long rangeCount;

    public CountIndexTask(String termText, int termNdx, int numTerms, boolean prefixMatch, double queryTermWeight, FullTextIndex<V> searchEngine) {
        super(termText, termNdx, numTerms, prefixMatch, queryTermWeight, searchEngine);
        if (log.isDebugEnabled()) {
            log.debug("termText=[" + termText + "], prefixMatch=" + prefixMatch + ", queryTermWeight=" + queryTermWeight + "\nfromKey=" + BytesUtil.toString(this.fromKey) + "\n  toKey=" + BytesUtil.toString(this.toKey));
        }
        this.rangeCount = searchEngine.getIndex().rangeCount(this.fromKey, this.toKey);
    }

    public long getRangeCount() {
        return this.rangeCount;
    }
}

