/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.btree.raba.codec.EmptyRabaValueCoder;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.relation.AbstractRelation;
import com.bigdata.search.CountIndexTask;
import com.bigdata.search.DefaultAnalyzerFactory;
import com.bigdata.search.FullTextIndexTupleSerializer;
import com.bigdata.search.Hit;
import com.bigdata.search.Hiterator;
import com.bigdata.search.IAnalyzerFactory;
import com.bigdata.search.IHit;
import com.bigdata.search.IHitCollector;
import com.bigdata.search.ITermMetadata;
import com.bigdata.search.MultiTokenHitCollector;
import com.bigdata.search.ReadIndexTask;
import com.bigdata.search.SingleTokenHitCollector;
import com.bigdata.search.TermFrequencyData;
import com.bigdata.search.TokenBuffer;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.concurrent.ExecutionHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class FullTextIndex<V extends Comparable<V>>
extends AbstractRelation {
    private static final transient Logger log = Logger.getLogger(FullTextIndex.class);
    private volatile IIndex ndx;
    private final boolean overwrite;
    private final long timeout;
    private final IAnalyzerFactory analyzerFactory;
    private final int hitCacheSize;
    private final long hitCacheTimeoutMillis;
    private final ConcurrentWeakValueCacheWithTimeout<ITextIndexer.FullTextQuery, Hit<V>[]> cache;
    public static final transient String NAME_SEARCH = "search";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex getIndex() {
        if (this.ndx == null) {
            FullTextIndex fullTextIndex = this;
            synchronized (fullTextIndex) {
                this.ndx = this.getIndex(this.getNamespace() + "." + NAME_SEARCH);
                if (this.ndx == null) {
                    throw new IllegalStateException();
                }
            }
        }
        return this.ndx;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public final boolean isReadOnly() {
        return TimestampUtility.isReadOnly(this.getTimestamp());
    }

    public FullTextIndex(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
        Class<?> cls;
        this.overwrite = Boolean.parseBoolean(properties.getProperty(Options.OVERWRITE, "true"));
        if (log.isInfoEnabled()) {
            log.info(Options.OVERWRITE + "=" + this.overwrite);
        }
        this.timeout = Long.parseLong(properties.getProperty(Options.INDEXER_TIMEOUT, "0"));
        if (log.isInfoEnabled()) {
            log.info(Options.INDEXER_TIMEOUT + "=" + this.timeout);
        }
        this.hitCacheSize = Integer.parseInt(properties.getProperty(Options.HIT_CACHE_SIZE, "10"));
        if (log.isInfoEnabled()) {
            log.info(Options.HIT_CACHE_SIZE + "=" + this.hitCacheSize);
        }
        this.hitCacheTimeoutMillis = Long.parseLong(properties.getProperty(Options.HIT_CACHE_TIMEOUT_MILLIS, Options.DEFAULT_HIT_CACHE_TIMEOUT_MILLIS));
        if (log.isInfoEnabled()) {
            log.info(Options.HIT_CACHE_TIMEOUT_MILLIS + "=" + this.hitCacheTimeoutMillis);
        }
        this.cache = new ConcurrentWeakValueCacheWithTimeout(this.hitCacheSize, this.hitCacheTimeoutMillis);
        String className = this.getProperty(Options.ANALYZER_FACTORY_CLASS, Options.DEFAULT_ANALYZER_FACTORY_CLASS);
        if (log.isInfoEnabled()) {
            log.info(Options.ANALYZER_FACTORY_CLASS + "=" + className);
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + Options.ANALYZER_FACTORY_CLASS, e);
        }
        if (!IAnalyzerFactory.class.isAssignableFrom(cls)) {
            throw new RuntimeException(Options.ANALYZER_FACTORY_CLASS + ": Must extend: " + IAnalyzerFactory.class.getName());
        }
        try {
            Constructor<?> ctor = cls.getConstructor(FullTextIndex.class);
            this.analyzerFactory = (IAnalyzerFactory)ctor.newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void create() {
        this.assertWritable();
        String name = this.getNamespace() + "." + NAME_SEARCH;
        IIndexManager indexManager = this.getIndexManager();
        Properties p = this.getProperties();
        IndexMetadata indexMetadata = new IndexMetadata(indexManager, p, name, UUID.randomUUID(), IndexTypeEnum.BTree);
        Properties tmp = new Properties(p);
        tmp.setProperty(KeyBuilder.Options.STRENGTH, p.getProperty(Options.INDEXER_COLLATOR_STRENGTH, Options.DEFAULT_INDEXER_COLLATOR_STRENGTH));
        DefaultKeyBuilderFactory keyBuilderFactory = new DefaultKeyBuilderFactory(tmp);
        boolean fieldsEnabled = Boolean.parseBoolean(p.getProperty(Options.FIELDS_ENABLED, "false"));
        if (log.isInfoEnabled()) {
            log.info(Options.FIELDS_ENABLED + "=" + fieldsEnabled);
        }
        indexMetadata.setTupleSerializer(new FullTextIndexTupleSerializer(keyBuilderFactory, DefaultTupleSerializer.getDefaultLeafKeysCoder(), EmptyRabaValueCoder.INSTANCE, fieldsEnabled));
        indexManager.registerIndex(indexMetadata);
        if (log.isInfoEnabled()) {
            log.info("Registered new text index: name=" + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        this.assertWritable();
        IIndexManager indexManager = this.getIndexManager();
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            indexManager.dropIndex(this.getNamespace() + "." + NAME_SEARCH);
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    protected Analyzer getAnalyzer(String languageCode, boolean filterStopwords) {
        return this.analyzerFactory.getAnalyzer(languageCode, filterStopwords);
    }

    protected final IKeyBuilder getKeyBuilder() {
        return this.getIndex().getIndexMetadata().getKeyBuilder();
    }

    public void index(TokenBuffer<V> buffer, V docId, int fieldId, String languageCode, Reader r) {
        this.index(buffer, docId, fieldId, languageCode, r, true);
    }

    public void index(TokenBuffer<V> buffer, V docId, int fieldId, String languageCode, Reader r, boolean filterStopwords) {
        int n = 0;
        TokenStream tokenStream = this.getTokenStream(languageCode, r, filterStopwords);
        try {
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                CharTermAttribute term = tokenStream.getAttribute(CharTermAttribute.class);
                buffer.add(docId, fieldId, term.toString());
                ++n;
            }
            tokenStream.end();
            tokenStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (log.isInfoEnabled()) {
            log.info("Indexed " + n + " tokens: docId=" + docId + ", fieldId=" + fieldId);
        }
    }

    protected TokenStream getTokenStream(String languageCode, Reader r, boolean filterStopwords) {
        Analyzer a = this.getAnalyzer(languageCode, filterStopwords);
        TokenStream tokenStream = a.tokenStream(null, r);
        tokenStream = new LowerCaseFilter(tokenStream);
        return tokenStream;
    }

    public Hiterator<Hit<V>> search(ITextIndexer.FullTextQuery query) {
        IHit[] a = this._search(query);
        return new Hiterator(a);
    }

    public int count(ITextIndexer.FullTextQuery query) {
        TermFrequencyData<V> qdata;
        if (this.cache.containsKey(query)) {
            if (log.isInfoEnabled()) {
                log.info("found hits in cache");
            }
            return ((Hit[])this.cache.get(query)).length;
        }
        if (log.isInfoEnabled()) {
            log.info("did not find hits in cache");
        }
        if ((qdata = this.tokenize(query)) == null) {
            this.cache.put(query, new Hit[0]);
            return 0;
        }
        if (qdata.distinctTermCount() == 1 && !query.isMatchExact() && query.getMatchRegex() == null) {
            boolean prefixMatch = query.isPrefixMatch();
            Map.Entry<String, ITermMetadata> e = qdata.getSingletonEntry();
            String termText = e.getKey();
            ITermMetadata md = e.getValue();
            CountIndexTask task1 = new CountIndexTask(termText, 0, 1, prefixMatch, md.getLocalTermWeight(), this);
            return (int)task1.getRangeCount();
        }
        Hit<V>[] a = this._search(query);
        return a.length;
    }

    protected TermFrequencyData<V> tokenize(ITextIndexer.FullTextQuery query) {
        String q = query.getQuery();
        String languageCode = query.getLanguageCode();
        boolean prefixMatch = query.isPrefixMatch();
        TokenBuffer buffer = new TokenBuffer(1, this);
        boolean filterStopwords = !prefixMatch;
        this.index(buffer, null, Integer.MIN_VALUE, languageCode, new StringReader(q), filterStopwords);
        if (buffer.size() == 0) {
            log.warn("No terms after stopword extraction: query=" + query);
            return null;
        }
        TermFrequencyData qdata = buffer.get(0);
        qdata.normalize();
        return qdata;
    }

    public Hit<V>[] _search(ITextIndexer.FullTextQuery query) {
        Object[] a;
        ITextIndexer.FullTextQuery cacheKey;
        String queryStr = query.getQuery();
        String languageCode = query.getLanguageCode();
        boolean prefixMatch = query.isPrefixMatch();
        double minCosine = query.getMinCosine();
        double maxCosine = query.getMaxCosine();
        int minRank = query.getMinRank();
        int maxRank = query.getMaxRank();
        boolean matchAllTerms = query.isMatchAllTerms();
        boolean matchExact = query.isMatchExact();
        String regex = query.getMatchRegex();
        long timeout = query.getTimeout();
        TimeUnit unit = query.getTimeUnit();
        long begin = System.currentTimeMillis();
        if (queryStr == null) {
            throw new IllegalArgumentException();
        }
        if (minCosine < 0.0 || minCosine > 1.0) {
            throw new IllegalArgumentException();
        }
        if (minRank <= 0 || maxRank <= 0) {
            throw new IllegalArgumentException();
        }
        if (minRank > maxRank) {
            throw new IllegalArgumentException();
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("languageCode=[" + languageCode + "], text=[" + queryStr + "], minCosine=" + minCosine + ", maxCosine=" + maxCosine + ", minRank=" + minRank + ", maxRank=" + maxRank + ", matchAllTerms=" + matchAllTerms + ", prefixMatch=" + prefixMatch + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit));
        }
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        if (this.cache.containsKey(cacheKey = query)) {
            if (log.isInfoEnabled()) {
                log.info("found hits in cache");
            }
            a = (Hit[])this.cache.get(cacheKey);
        } else {
            int i;
            TermFrequencyData<V> qdata;
            if (log.isInfoEnabled()) {
                log.info("did not find hits in cache");
            }
            if ((qdata = this.tokenize(query)) == null) {
                Hit[] a2 = new Hit[]{};
                this.cache.put(cacheKey, a2);
                return a2;
            }
            a = this.executeQuery(qdata, prefixMatch, timeout, unit);
            if (a.length == 0) {
                log.info("No hits: languageCode=[" + languageCode + "], query=[" + queryStr + "]");
                this.cache.put(cacheKey, (Hit<V>[])a);
                return a;
            }
            if ((matchAllTerms || matchExact) && qdata.distinctTermCount() > 1) {
                int nterms = qdata.terms.size();
                if (log.isInfoEnabled()) {
                    log.info("matchAll=true, nterms=" + nterms);
                    log.info("size before: " + a.length);
                }
                Hit[] tmp = new Hit[a.length];
                i = 0;
                for (Object hit : a) {
                    if (((Hit)hit).getTermCount() != nterms) continue;
                    tmp[i++] = hit;
                }
                if (log.isDebugEnabled()) {
                    log.debug(i);
                }
                if (i < a.length) {
                    a = new Hit[i];
                    System.arraycopy(tmp, 0, a, 0, i);
                }
            }
            if (matchExact) {
                a = this.matchExact((Hit<V>[])a, queryStr);
            }
            if (a.length == 0) {
                log.warn("No hits after matchAllTerms pruning: languageCode=[" + languageCode + "], query=[" + queryStr + "]");
                this.cache.put(cacheKey, (Hit<V>[])a);
                return a;
            }
            if (regex != null) {
                Pattern pattern = Pattern.compile(regex);
                if (log.isDebugEnabled()) {
                    log.debug("hits before regex: " + a.length);
                }
                a = this.applyRegex((Hit<V>[])a, pattern);
                if (log.isDebugEnabled()) {
                    log.debug("hits after regex: " + a.length);
                }
            }
            if (a.length == 0) {
                log.warn("No hits after regex pruning: languageCode=[" + languageCode + "], query=[" + queryStr + "], regex=[" + regex + "]");
                this.cache.put(cacheKey, (Hit<V>[])a);
                return a;
            }
            if (log.isInfoEnabled()) {
                log.info("Rank ordering " + a.length + " hits by relevance");
            }
            long start = System.currentTimeMillis();
            Arrays.sort(a);
            if (log.isInfoEnabled()) {
                long sortTime = System.currentTimeMillis() - start;
                log.info("sort time: " + sortTime);
            }
            for (i = 0; i < a.length; ++i) {
                ((Hit)a[i]).setRank(i + 1);
            }
            this.cache.put(cacheKey, (Hit<V>[])a);
        }
        a = this.slice(query, (Hit<V>[])a);
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info("Done: " + a.length + " hits in " + elapsed + "ms");
        }
        return a;
    }

    protected Hit<V>[] slice(ITextIndexer.FullTextQuery query, Hit<V>[] a) {
        Hit[] tmp;
        int i;
        double minCosine = query.getMinCosine();
        double maxCosine = query.getMaxCosine();
        int minRank = query.getMinRank();
        int maxRank = query.getMaxRank();
        if (maxCosine < 1.0) {
            i = 0;
            for (Hit<V> h : a) {
                if (h.getCosine() <= maxCosine) break;
                ++i;
            }
            if (i == a.length) {
                return new Hit[0];
            }
            tmp = new Hit[a.length - i];
            System.arraycopy(a, i, tmp, 0, tmp.length);
            a = tmp;
        }
        if (minCosine > 0.0) {
            i = 0;
            for (Hit<V> h : a) {
                if (h.getCosine() < minCosine) break;
                ++i;
            }
            if (i == 0) {
                return new Hit[0];
            }
            if (i < a.length) {
                tmp = new Hit[i];
                System.arraycopy(a, 0, tmp, 0, tmp.length);
                a = tmp;
            }
        }
        if (minRank > 0 && minRank == maxRank) {
            if (minRank > a.length) {
                return new Hit[0];
            }
            return new Hit[]{a[minRank - 1]};
        }
        if (minRank > 1) {
            if (minRank > a.length) {
                return new Hit[0];
            }
            Hit[] tmp2 = new Hit[a.length - (minRank - 1)];
            System.arraycopy(a, minRank - 1, tmp2, 0, tmp2.length);
            a = tmp2;
        }
        int newMax = maxRank - minRank + 1;
        if (log.isDebugEnabled()) {
            log.debug("new max rank: " + newMax);
        }
        if (newMax < a.length) {
            tmp = new Hit[newMax];
            System.arraycopy(a, 0, tmp, 0, tmp.length);
            a = tmp;
        }
        return a;
    }

    protected Hit<V>[] executeQuery(TermFrequencyData<V> qdata, boolean prefixMatch, long timeout, TimeUnit unit) {
        ITermMetadata md;
        String termText;
        ArrayList<CountIndexTask<Object>> tasks;
        IHitCollector hits;
        if (qdata.distinctTermCount() == 1) {
            Map.Entry<String, ITermMetadata> e = qdata.getSingletonEntry();
            String termText2 = e.getKey();
            ITermMetadata md2 = e.getValue();
            CountIndexTask task1 = new CountIndexTask(termText2, 0, 1, prefixMatch, md2.getLocalTermWeight(), this);
            hits = new SingleTokenHitCollector(task1);
        } else {
            tasks = new ArrayList(qdata.distinctTermCount());
            int i = 0;
            for (Map.Entry<String, ITermMetadata> e : qdata.terms.entrySet()) {
                termText = e.getKey();
                md = e.getValue();
                tasks.add(new CountIndexTask(termText, i++, qdata.terms.size(), prefixMatch, md.getLocalTermWeight(), this));
            }
            hits = new MultiTokenHitCollector(tasks);
        }
        tasks = new ArrayList(qdata.distinctTermCount());
        int i = 0;
        for (Map.Entry<String, ITermMetadata> e : qdata.terms.entrySet()) {
            termText = e.getKey();
            md = e.getValue();
            tasks.add((CountIndexTask<Object>)((Object)new ReadIndexTask(termText, i++, qdata.terms.size(), prefixMatch, md.getLocalTermWeight(), this, hits)));
        }
        ExecutionHelper<Object> executionHelper = new ExecutionHelper<Object>(this.getExecutorService(), timeout, unit);
        try {
            long start = System.currentTimeMillis();
            executionHelper.submitTasks(tasks);
            if (log.isInfoEnabled()) {
                long readTime = System.currentTimeMillis() - start;
                log.info("read time: " + readTime);
            }
        }
        catch (InterruptedException ex) {
            if (log.isInfoEnabled()) {
                log.info("Interrupted - only partial results will be returned.");
            }
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        return hits.getHits();
    }

    protected Hit<V>[] matchExact(Hit<V>[] hits, String query) {
        throw new UnsupportedOperationException();
    }

    protected Hit<V>[] applyRegex(Hit<V>[] hits, Pattern regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long delete(IChunkedOrderedIterator itr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long insert(IChunkedOrderedIterator itr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getIndexNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getKeyOrders() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newElement(List a, IBindingSet bindingSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> getElementClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IKeyOrder getPrimaryKeyOrder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IKeyOrder getKeyOrder(IPredicate p) {
        throw new UnsupportedOperationException();
    }

    public static interface Options {
        public static final String OVERWRITE = FullTextIndex.class.getName() + ".overwrite";
        public static final String DEFAULT_OVERWRITE = "true";
        public static final String INDEXER_COLLATOR_STRENGTH = FullTextIndex.class.getName() + ".collator.strength";
        public static final String DEFAULT_INDEXER_COLLATOR_STRENGTH = StrengthEnum.Primary.toString();
        public static final String INDEXER_TIMEOUT = FullTextIndex.class.getName() + ".timeout";
        public static final String DEFAULT_INDEXER_TIMEOUT = "0";
        public static final String FIELDS_ENABLED = FullTextIndex.class.getName() + ".fieldsEnabled";
        public static final String DEFAULT_FIELDS_ENABLED = "false";
        public static final String ANALYZER_FACTORY_CLASS = FullTextIndex.class.getName() + ".analyzerFactoryClass";
        public static final String DEFAULT_ANALYZER_FACTORY_CLASS = DefaultAnalyzerFactory.class.getName();
        public static final String HIT_CACHE_SIZE = FullTextIndex.class.getName() + ".hitCacheSize";
        public static final String DEFAULT_HIT_CACHE_SIZE = "10";
        public static final String HIT_CACHE_TIMEOUT_MILLIS = FullTextIndex.class.getName() + ".hitCacheTimeoutMillis";
        public static final String DEFAULT_HIT_CACHE_TIMEOUT_MILLIS = String.valueOf(TimeUnit.MINUTES.toMillis(1L));
    }
}

