/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.CountIndexTask;
import com.bigdata.search.Hit;
import com.bigdata.search.IHitCollector;
import org.apache.log4j.Logger;

public class SingleTokenHitCollector<V extends Comparable<V>>
implements IHitCollector<V> {
    protected static final transient Logger log = Logger.getLogger(SingleTokenHitCollector.class);
    final Hit<V>[] hits;
    int i = 0;

    public SingleTokenHitCollector(CountIndexTask<V> task) {
        long rangeCount = task.getRangeCount();
        if (rangeCount > Integer.MAX_VALUE) {
            throw new RuntimeException("too many hits");
        }
        int i = (int)rangeCount;
        if (log.isInfoEnabled()) {
            log.info("array size: " + i);
        }
        this.hits = new Hit[i];
    }

    @Override
    public Hit<V> putIfAbsent(V v, Hit<V> hit) {
        this.hits[this.i++] = hit;
        return null;
    }

    @Override
    public Hit<V>[] getHits() {
        if (this.i == this.hits.length) {
            return this.hits;
        }
        Hit[] tmp = new Hit[this.i];
        System.arraycopy(this.hits, 0, tmp, 0, this.i);
        return tmp;
    }
}

