/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractScaleOutClient;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IDataService;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.IndexCache;
import com.bigdata.service.MetadataIndexCache;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class AbstractScaleOutFederation<T>
extends AbstractFederation<T> {
    protected final AbstractScaleOutClient.MetadataIndexCachePolicy metadataIndexCachePolicy;
    private final IndexCache indexCache;
    private final MetadataIndexCache metadataIndexCache;

    public AbstractScaleOutFederation(IBigdataClient<T> client) {
        super(client);
        this.indexCache = new IndexCache(this, client.getIndexCacheCapacity(), client.getIndexCacheTimeout());
        this.metadataIndexCache = new MetadataIndexCache(this, client.getIndexCacheCapacity(), client.getIndexCacheTimeout());
        Properties properties = client.getProperties();
        this.metadataIndexCachePolicy = AbstractScaleOutClient.MetadataIndexCachePolicy.valueOf(properties.getProperty(AbstractScaleOutClient.Options.METADATA_INDEX_CACHE_POLICY, AbstractScaleOutClient.Options.DEFAULT_METADATA_INDEX_CACHE_POLICY));
        if (log.isInfoEnabled()) {
            log.info(AbstractScaleOutClient.Options.METADATA_INDEX_CACHE_POLICY + "=" + (Object)((Object)this.metadataIndexCachePolicy));
        }
    }

    @Override
    public ClientIndexView getIndex(String name, long timestamp) {
        return (ClientIndexView)super.getIndex(name, timestamp);
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.indexCache.shutdown();
        this.metadataIndexCache.shutdown();
    }

    @Override
    public synchronized void shutdownNow() {
        super.shutdownNow();
        this.indexCache.shutdown();
        this.metadataIndexCache.shutdown();
    }

    @Override
    public IMetadataIndex getMetadataIndex(String name, long timestamp) {
        if (log.isInfoEnabled()) {
            log.info("name=" + name + " @ " + timestamp);
        }
        this.assertOpen();
        return (IMetadataIndex)this.getMetadataIndexCache().getIndex(name, timestamp);
    }

    public Iterator<PartitionLocator> locatorScan(String name, long timestamp, byte[] fromKey, byte[] toKey, boolean reverseScan) {
        ITupleIterator itr;
        IMetadataIndex mdi;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("Querying metadata index: name=" + name + ", timestamp=" + timestamp + ", reverseScan=" + reverseScan + ", fromKey=" + BytesUtil.toString(fromKey) + ", toKey=" + BytesUtil.toString(toKey));
        }
        if ((mdi = this.getMetadataIndex(name, timestamp)) == null) {
            throw new NoSuchIndexException("name=" + name + "@" + TimestampUtility.toString(timestamp));
        }
        int flags = 2;
        if (reverseScan) {
            itr = mdi.rangeIterator(fromKey, toKey, 0, 66, null);
        } else {
            byte[] _fromKey = fromKey == null ? null : mdi.find(fromKey).getLeftSeparatorKey();
            itr = mdi.rangeIterator(_fromKey, toKey, 0, 2, null);
        }
        return new Striterator(itr).addFilter(new Resolver(){
            private static final long serialVersionUID = 7874887729130530971L;

            @Override
            protected Object resolve(Object obj) {
                ITuple tuple = (ITuple)obj;
                return tuple.getObject();
            }
        });
    }

    @Override
    public final boolean isScaleOut() {
        return true;
    }

    protected IndexCache getIndexCache() {
        return this.indexCache;
    }

    protected MetadataIndexCache getMetadataIndexCache() {
        return this.metadataIndexCache;
    }

    public UUID[] awaitServices(int minDataServices, long timeout) throws InterruptedException, TimeoutException {
        this.assertOpen();
        if (minDataServices <= 0) {
            throw new IllegalArgumentException();
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException();
        }
        long begin = System.currentTimeMillis();
        long interval = Math.min(100L, timeout / 10L);
        int ntries = 0;
        IMetadataService metadataService = null;
        Object[] dataServiceUUIDs = null;
        while (true) {
            metadataService = this.getMetadataService();
            dataServiceUUIDs = this.getDataServiceUUIDs(0);
            if (System.currentTimeMillis() - begin >= timeout || metadataService != null && dataServiceUUIDs.length >= minDataServices) break;
            ++ntries;
            if (log.isInfoEnabled()) {
                log.info("Waiting : ntries=" + ntries + ", metadataService=" + (metadataService == null ? "not " : "") + " found; #dataServices=" + dataServiceUUIDs.length + " out of " + minDataServices + " required : " + Arrays.toString(dataServiceUUIDs));
            }
            Thread.sleep(interval);
        }
        if (log.isInfoEnabled()) {
            log.info("MDS=" + (metadataService != null) + ", #dataServices=" + dataServiceUUIDs.length);
        }
        if (metadataService != null && dataServiceUUIDs.length >= minDataServices) {
            return dataServiceUUIDs;
        }
        throw new TimeoutException("elapsed=" + (System.currentTimeMillis() - begin) + "ms: metadataService=" + (metadataService != null) + ", dataServices=" + dataServiceUUIDs.length + " but require " + minDataServices);
    }

    public void forceOverflow(boolean compactingMerge, boolean truncateJournal) {
        List futures;
        UUID[] dataServiceUUIDs = this.getDataServiceUUIDs(0);
        int ndataServices = dataServiceUUIDs.length;
        log.warn("Forcing overflow: #dataServices=" + ndataServices + ", now=" + new Date());
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>(ndataServices);
        for (UUID serviceUUID : dataServiceUUIDs) {
            tasks.add(new ForceOverflowTask(this.getDataService(serviceUUID), compactingMerge, truncateJournal));
        }
        if (truncateJournal) {
            tasks.add(new PurgeResourcesTask(this.getMetadataService(), truncateJournal));
        }
        try {
            futures = this.getExecutorService().invokeAll(tasks);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        int nok = 0;
        for (Future f : futures) {
            try {
                f.get();
                ++nok;
            }
            catch (InterruptedException ex) {
                log.warn(ex.getLocalizedMessage());
            }
            catch (ExecutionException ex) {
                log.error(ex.getLocalizedMessage(), ex);
            }
        }
        log.warn("Did overflow: #ok=" + nok + ", #dataServices=" + ndataServices + ", now=" + new Date());
        if (nok != tasks.size()) {
            throw new RuntimeException("Errors during overflow processing: #ok=" + nok + ", #tasks=" + tasks.size());
        }
    }

    public static class ForceOverflowTask
    implements Callable<Void> {
        protected static final Logger log = Logger.getLogger(ForceOverflowTask.class);
        private final IDataService dataService;
        private final boolean compactingMerge;
        private final boolean truncateJournal;

        public ForceOverflowTask(IDataService dataService, boolean compactingMerge, boolean truncateJournal) {
            if (dataService == null) {
                throw new IllegalArgumentException();
            }
            this.dataService = dataService;
            this.compactingMerge = compactingMerge;
            this.truncateJournal = truncateJournal;
        }

        @Override
        public Void call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info("dataService: " + this.dataService.getServiceName());
            }
            this.dataService.forceOverflow(true, this.compactingMerge);
            if (log.isInfoEnabled()) {
                log.info("Synchronous overflow is done: " + this.dataService.getServiceName());
            }
            while (this.dataService.isOverflowActive()) {
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info("Asynchronous overflow is done: " + this.dataService.getServiceName());
            }
            if (this.truncateJournal && !this.dataService.purgeOldResources(5000L, true)) {
                log.warn("Could not pause write service - resources will not be purged.");
            }
            return null;
        }
    }

    public static class PurgeResourcesTask
    implements Callable<Void> {
        protected static final Logger log = Logger.getLogger(PurgeResourcesTask.class);
        private final IDataService dataService;
        private final boolean truncateJournal;

        public PurgeResourcesTask(IDataService dataService, boolean truncateJournal) {
            if (dataService == null) {
                throw new IllegalArgumentException();
            }
            this.dataService = dataService;
            this.truncateJournal = truncateJournal;
        }

        @Override
        public Void call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info("dataService: " + this.dataService.getServiceName());
            }
            if (!this.dataService.purgeOldResources(5000L, this.truncateJournal)) {
                log.warn("Could not pause write service - resources will not be purged.");
            }
            return null;
        }
    }
}

