/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.Banner;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.IService;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public abstract class AbstractService
implements IService {
    private static final Logger log = Logger.getLogger(AbstractService.class);
    private String serviceName;
    private UUID serviceUUID;

    protected AbstractService() {
        Banner.banner();
        this.serviceName = this.getServiceIface().getName() + "@" + this.getHostname() + "#" + this.hashCode();
    }

    public synchronized void setServiceUUID(UUID serviceUUID) throws IllegalStateException {
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (this.serviceUUID != null && !this.serviceUUID.equals(serviceUUID)) {
            throw new IllegalStateException();
        }
        if (log.isInfoEnabled()) {
            log.info("uuid=" + serviceUUID);
        }
        this.serviceUUID = serviceUUID;
    }

    @Override
    public final UUID getServiceUUID() {
        return this.serviceUUID;
    }

    @Override
    public abstract Class getServiceIface();

    public abstract AbstractService start();

    public abstract AbstractFederation getFederation();

    @Override
    public final String getHostname() {
        return AbstractStatisticsCollector.fullyQualifiedHostName;
    }

    public synchronized void shutdown() {
    }

    public synchronized void shutdownNow() {
    }

    @Override
    public void destroy() {
        this.shutdownNow();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    protected void setupLoggingContext() {
        try {
            UUID serviceUUID = this.getServiceUUID();
            if (serviceUUID != null) {
                MDC.put("serviceUUID", serviceUUID);
            }
            MDC.put("serviceName", this.getServiceName());
            MDC.put("hostname", this.getHostname());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void clearLoggingContext() {
        MDC.remove("serviceName");
        MDC.remove("serviceUUID");
        MDC.remove("hostname");
    }
}

