/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.service.AbstractServiceLoadHelper;
import com.bigdata.service.ServiceScore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class AbstractServiceLoadHelperWithScores
extends AbstractServiceLoadHelper {
    protected static final Logger log = Logger.getLogger(AbstractServiceLoadHelperWithScores.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected final UUID knownGood;
    protected final ServiceScore[] scores;

    protected AbstractServiceLoadHelperWithScores(long joinTimeout, UUID knownGood, ServiceScore[] scores) {
        super(joinTimeout);
        if (knownGood == null) {
            throw new IllegalArgumentException();
        }
        if (scores == null) {
            throw new IllegalArgumentException();
        }
        if (scores.length == 0) {
            throw new IllegalArgumentException();
        }
        this.knownGood = knownGood;
        this.scores = scores;
    }

    @Override
    public UUID[] getUnderUtilizedDataServices(int minCount, int maxCount, UUID exclude) throws TimeoutException, InterruptedException {
        if (exclude != null && this.knownGood.equals(exclude)) {
            throw new IllegalArgumentException();
        }
        ArrayList<UUID> underUtilized = new ArrayList<UUID>(Math.max(this.scores.length, Math.max(minCount, maxCount)));
        int nok = 0;
        for (int i = 0; i < this.scores.length; ++i) {
            ServiceScore score = this.scores[i];
            if (score.serviceUUID.equals(exclude) || !this.isActiveDataService(score.serviceUUID)) continue;
            if (this.isUnderUtilizedDataService(score, this.scores)) {
                underUtilized.add(score.serviceUUID);
                ++nok;
            }
            if (maxCount > 0 && nok >= maxCount) {
                if (!INFO) break;
                log.info("Satisifed maxCount=" + maxCount);
                break;
            }
            if (minCount <= 0 || maxCount != 0 || nok < minCount) continue;
            if (!INFO) break;
            log.info("Satisifed minCount=" + minCount);
            break;
        }
        if (INFO) {
            log.info("Found " + underUtilized.size() + " under-utilized and non-excluded services");
        }
        if (minCount > 0 && underUtilized.isEmpty()) {
            assert (this.knownGood != null);
            log.warn("Will report fallback service: " + this.knownGood);
            underUtilized.add(this.knownGood);
        }
        Object[] uuids = new UUID[Math.max(minCount, nok)];
        int n = 0;
        int i = 0;
        while (n < uuids.length) {
            UUID tmp;
            if ((tmp = (UUID)underUtilized.get(i++ % nok)) == null) {
                throw new AssertionError();
            }
            if (exclude != null && tmp.equals(exclude)) {
                throw new AssertionError();
            }
            uuids[n++] = tmp;
        }
        if (INFO) {
            log.info("Reporting " + uuids.length + " under-utilized and non-excluded services: " + Arrays.toString(uuids));
        }
        return uuids;
    }
}

