/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.service.AbstractServiceLoadHelper;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class AbstractServiceLoadHelperWithoutScores
extends AbstractServiceLoadHelper {
    protected static final Logger log = Logger.getLogger(AbstractServiceLoadHelperWithoutScores.class);
    protected static final boolean INFO = log.isInfoEnabled();

    protected AbstractServiceLoadHelperWithoutScores(long joinTimeout) {
        super(joinTimeout);
    }

    @Override
    public UUID[] getUnderUtilizedDataServices(int minCount, int maxCount, UUID exclude) throws TimeoutException, InterruptedException {
        int nok;
        UUID[] knownServiceUUIDs;
        long begin = System.currentTimeMillis();
        while (true) {
            long elapsed;
            if ((elapsed = System.currentTimeMillis() - begin) > this.joinTimeout) {
                log.warn("Timeout waiting for service to join.");
                throw new TimeoutException();
            }
            knownServiceUUIDs = this.getActiveServices();
            if (knownServiceUUIDs.length == 0) {
                this.awaitJoin(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            nok = 0;
            for (int i = 0; i < knownServiceUUIDs.length; ++i) {
                if (exclude != null && exclude.equals(knownServiceUUIDs[i])) {
                    knownServiceUUIDs[i] = null;
                    continue;
                }
                if (!this.isActiveDataService(knownServiceUUIDs[i])) {
                    knownServiceUUIDs[i] = null;
                    continue;
                }
                ++nok;
            }
            if (nok > 0) break;
            this.awaitJoin(100L, TimeUnit.MILLISECONDS);
        }
        UUID[] uuids = new UUID[Math.max(minCount, nok)];
        int n = 0;
        int i = 0;
        while (n < uuids.length) {
            UUID tmp;
            if ((tmp = knownServiceUUIDs[i++ % nok]) == null) continue;
            if (exclude != null && tmp.equals(exclude)) {
                throw new RuntimeException();
            }
            uuids[n++] = tmp;
        }
        return uuids;
    }
}

