/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.MetadataService;
import com.bigdata.service.ndx.RawDataServiceTupleIterator;
import cutthecrap.utils.striterators.IFilter;
import org.apache.log4j.Logger;

public class CacheOnceMetadataIndex
implements IMetadataIndex {
    protected static final Logger log = Logger.getLogger(CacheOnceMetadataIndex.class);
    protected final AbstractScaleOutFederation<?> fed;
    protected final String name;
    protected final long timestamp;
    protected final MetadataIndex.MetadataIndexMetadata mdmd;
    private final MetadataIndex mdi;

    public String toString() {
        return super.toString() + "{name=" + this.name + ",timestamp=" + TimestampUtility.toString(this.timestamp) + "}";
    }

    public CacheOnceMetadataIndex(AbstractScaleOutFederation<?> fed, String name, long timestamp, MetadataIndex.MetadataIndexMetadata mdmd) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (mdmd == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.name = name;
        this.timestamp = timestamp;
        this.mdi = MetadataIndex.create(fed.getTempStore(), mdmd.getIndexUUID(), mdmd.getManagedIndexMetadata());
        this.mdmd = mdmd;
        this.cacheLocators(null, null);
    }

    protected void cacheLocators(byte[] fromKey, byte[] toKey) {
        long n = 0L;
        this.mdi.rangeIterator(fromKey, toKey, 0, 16, (IFilter)null);
        RawDataServiceTupleIterator itr = new RawDataServiceTupleIterator(this.fed.getMetadataService(), MetadataService.getMetadataIndexName(this.name), this.timestamp, true, fromKey, toKey, 0, 11, null);
        while (itr.hasNext()) {
            ITuple tuple = itr.next();
            byte[] key = tuple.getKey();
            byte[] val = tuple.getValue();
            this.mdi.insert(key, val);
            ++n;
        }
        if (log.isInfoEnabled()) {
            log.info("Copied " + n + " locator records: name=" + this.name);
        }
    }

    @Override
    public void staleLocator(PartitionLocator locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final MetadataIndex.MetadataIndexMetadata getIndexMetadata() {
        return this.mdmd;
    }

    @Override
    public final IndexMetadata getScaleOutIndexMetadata() {
        return this.getIndexMetadata().getManagedIndexMetadata();
    }

    @Override
    public PartitionLocator get(byte[] key) {
        return this.mdi.get(key);
    }

    @Override
    public PartitionLocator find(byte[] key) {
        return this.mdi.find(key);
    }

    @Override
    public long rangeCount() {
        return this.mdi.rangeCount();
    }

    @Override
    public long rangeCount(byte[] fromKey, byte[] toKey) {
        return this.mdi.rangeCount(fromKey, toKey);
    }

    @Override
    public long rangeCountExact(byte[] fromKey, byte[] toKey) {
        return this.mdi.rangeCountExact(fromKey, toKey);
    }

    @Override
    public long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        return this.mdi.rangeCountExactWithDeleted(fromKey, toKey);
    }

    @Override
    public ITupleIterator rangeIterator() {
        return this.mdi.rangeIterator();
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        return this.mdi.rangeIterator(fromKey, toKey, capacity, flags, filter);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.mdi.rangeIterator(fromKey, toKey);
    }
}

