/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.EventResource;
import com.bigdata.service.IBigdataFederation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Event
implements Serializable {
    protected static final transient Logger log = Logger.getLogger(Event.class);
    private static final long serialVersionUID = 2651293369056916231L;
    protected transient IBigdataFederation fed;
    public final UUID eventUUID;
    public final String hostname;
    public final Class serviceIface;
    public final String serviceName;
    public final UUID serviceUUID;
    public final EventResource resource;
    public final Object majorEventType;
    public final Object minorEventType;
    protected Map<String, Object> details;
    protected long startTime;
    protected long endTime;
    protected transient long receiptTime;
    protected boolean complete = false;
    static final String BLANK = "";

    public Map<String, Object> getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event addDetails(Map<String, Object> details) {
        if (details == null) {
            throw new IllegalArgumentException();
        }
        Event event = this;
        synchronized (event) {
            if (this.details == null) {
                this.details = Event.newDetails();
            }
            this.details.putAll(details);
        }
        return this;
    }

    protected static Map<String, Object> newDetails() {
        return Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event addDetail(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Event event = this;
        synchronized (event) {
            if (this.details == null) {
                this.details = Event.newDetails();
            }
            this.details.put(name, value);
        }
        return this;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getElapsed() {
        if (this.endTime == 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    public Event(IBigdataFederation fed, EventResource resource, Object majorEventType) {
        this(fed, resource, majorEventType, null);
    }

    public Event(IBigdataFederation fed, EventResource resource, Object majorEventType, Map<String, Object> details) {
        this(fed, resource, majorEventType, BLANK, details);
    }

    protected Event(IBigdataFederation fed, EventResource resource, Object majorEventType, Object minorEventType, Map<String, Object> details) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (majorEventType == null) {
            throw new IllegalArgumentException();
        }
        if (minorEventType == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.eventUUID = UUID.randomUUID();
        this.hostname = AbstractStatisticsCollector.fullyQualifiedHostName;
        this.serviceIface = this.fed.getServiceIface();
        this.serviceName = this.fed.getServiceName();
        this.serviceUUID = this.fed.getServiceUUID();
        this.resource = resource;
        this.majorEventType = majorEventType;
        this.minorEventType = minorEventType;
        if (details != null) {
            this.addDetails(details);
        }
    }

    public Event newSubEvent(Object minorEventType) {
        return new Event(this.fed, this.resource, this.majorEventType, minorEventType, this.details);
    }

    public Event newSubEvent(Object minorEventType, Map<String, Object> details) {
        Event e = this.newSubEvent(minorEventType);
        if (details != null) {
            e.addDetails(details);
        }
        return e;
    }

    public synchronized Event start() {
        if (this.startTime != 0L) {
            throw new IllegalStateException();
        }
        this.startTime = System.currentTimeMillis();
        try {
            this.sendEvent();
        }
        catch (Throwable t) {
            log.warn(t);
        }
        return this;
    }

    public synchronized Event end() {
        if (this.complete) {
            throw new IllegalStateException();
        }
        this.complete = true;
        this.endTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.endTime;
        }
        try {
            this.sendEvent();
        }
        catch (Throwable t) {
            log.warn(t);
        }
        return this;
    }

    protected void sendEvent() throws IOException {
        if (this.fed instanceof AbstractFederation) {
            ((AbstractFederation)this.fed).sendEvent(this);
        } else if (log.isInfoEnabled()) {
            log.info(this);
        }
    }

    public static String getHeader() {
        return "eventUUID\tindexName\tpartitionId\tfile\tmajorEventType\tmajorEventValue\tminorEventType\tminorEventValue\tstartTime\tendTime\telapsed\tcomplete\thostname\tserviceIface\tserviceName\tserviceUUID\tdetails\n";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.eventUUID);
        sb.append('\t');
        sb.append(this.resource.indexName);
        sb.append('\t');
        sb.append(this.resource.partitionId);
        sb.append('\t');
        sb.append(this.resource.file);
        sb.append('\t');
        sb.append(this.majorEventType.getClass().getName());
        sb.append('\t');
        sb.append(this.majorEventType);
        sb.append('\t');
        sb.append(this.minorEventType.getClass().getName());
        sb.append('\t');
        sb.append(this.minorEventType);
        sb.append('\t');
        sb.append(this.startTime);
        sb.append('\t');
        sb.append(this.endTime);
        sb.append('\t');
        if (this.complete) {
            sb.append(this.endTime - this.startTime);
            sb.append('\t');
        } else {
            sb.append('\t');
        }
        sb.append(this.complete);
        sb.append('\t');
        sb.append(this.hostname);
        sb.append('\t');
        sb.append(this.serviceIface.getName());
        sb.append('\t');
        sb.append(this.serviceName);
        sb.append('\t');
        sb.append(this.serviceUUID);
        if (this.details != null) {
            Object[] keys = this.details.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object s : keys) {
                sb.append('\t');
                sb.append((String)s);
                sb.append("=");
                sb.append(BLANK + this.details.get(s));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Event(String s) throws ClassNotFoundException {
        MyStringTokenizer st = new MyStringTokenizer(s, "\t");
        try {
            String minorEventClass;
            this.eventUUID = UUID.fromString(st.nextToken());
            String resourceIndexName = st.nextToken();
            String resourcePartitionId = st.nextToken();
            String resourceFile = st.nextToken();
            this.resource = new EventResource(resourceIndexName, resourcePartitionId, resourceFile);
            String majorEventClass = st.nextToken();
            if (majorEventClass != null) {
                Class<?> majorEventType = Class.forName(majorEventClass);
                String majorEventValue = st.nextToken();
                if (majorEventValue == null) {
                    majorEventValue = BLANK;
                }
                if (majorEventType.equals(String.class)) {
                    this.majorEventType = majorEventValue;
                } else {
                    if (!majorEventType.isEnum()) throw new UnsupportedOperationException();
                    this.majorEventType = Enum.valueOf(majorEventType, majorEventValue);
                }
            } else {
                this.majorEventType = BLANK;
            }
            if ((minorEventClass = st.nextToken()) != null) {
                Class<?> minorEventType = Class.forName(minorEventClass);
                String minorEventValue = st.nextToken();
                if (minorEventValue == null) {
                    minorEventValue = BLANK;
                }
                if (minorEventType.equals(String.class)) {
                    this.minorEventType = minorEventValue;
                } else {
                    if (!minorEventType.isEnum()) throw new UnsupportedOperationException();
                    this.minorEventType = Enum.valueOf(minorEventType, minorEventValue);
                }
            } else {
                this.minorEventType = BLANK;
            }
            String startTime = st.nextToken();
            this.startTime = Long.valueOf(startTime);
            String endTime = st.nextToken();
            this.endTime = Long.valueOf(endTime);
            String elapsed = st.nextToken();
            this.complete = Boolean.valueOf(st.nextToken());
            this.hostname = st.nextToken();
            String serviceIfaceName = st.nextToken();
            this.serviceIface = Class.forName(serviceIfaceName);
            this.serviceName = st.nextToken();
            this.serviceUUID = UUID.fromString(st.nextToken());
            this.details = Event.newDetails();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                int pos = t.indexOf(61);
                String name = t.substring(0, pos);
                String value = t.substring(pos + 1, t.length());
                this.details.put(name, value);
            }
            return;
        }
        catch (Throwable t) {
            throw new RuntimeException("At field: " + st.getCurrentFieldIndex() + " of " + st.getFieldCount() + " : " + t, t);
        }
    }

    public static Event fromString(String s) throws ClassNotFoundException {
        return new Event(s);
    }

    private static class MyStringTokenizer {
        private final List<String> tokens = new ArrayList<String>(20);
        private final String delim;
        private int i;

        public MyStringTokenizer(String s, String delim) {
            StringTokenizer st = new StringTokenizer(s, delim, true);
            while (st.hasMoreTokens()) {
                this.tokens.add(st.nextToken());
            }
            this.delim = delim;
            this.i = 0;
        }

        public int getFieldCount() {
            return this.tokens.size();
        }

        public int getCurrentFieldIndex() {
            return this.i;
        }

        public boolean hasMoreTokens() {
            return this.i < this.tokens.size() && (this.i != this.tokens.size() - 1 || !this.delim.contains(this.tokens.get(this.tokens.size() - 1)));
        }

        public String nextToken() {
            String token;
            if (this.delim.contains(token = this.tokens.get(this.i++))) {
                token = this.tokens.get(this.i);
                if (this.delim.contains(token)) {
                    token = Event.BLANK;
                } else {
                    ++this.i;
                }
            }
            if (token != null && (token = token.trim()).length() == 0) {
                token = Event.BLANK;
            }
            return token;
        }
    }
}

