/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.UnisolatedReadWriteIndex;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.relation.accesspath.TupleObjectResolver;
import com.bigdata.service.Event;
import com.bigdata.service.IEventReceivingService;
import com.bigdata.service.IEventReportingService;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class EventReceiver
implements IEventReceivingService,
IEventReportingService {
    protected static final transient Logger log = Logger.getLogger(EventReceiver.class);
    protected final long eventHistoryMillis;
    protected final LinkedHashMap<UUID, Event> eventCache;
    protected final UnisolatedReadWriteIndex ndx;
    private final ITupleSerializer<Long, Event> tupleSer;

    public EventReceiver(long eventHistoryMillis, EventBTree eventBTree) {
        if (eventHistoryMillis <= 0L) {
            throw new IllegalArgumentException();
        }
        if (eventBTree == null) {
            throw new IllegalArgumentException();
        }
        this.eventHistoryMillis = eventHistoryMillis;
        this.eventCache = new LinkedHashMap(1000);
        this.ndx = new UnisolatedReadWriteIndex(eventBTree);
        this.tupleSer = eventBTree.getIndexMetadata().getTupleSerializer();
        if (log.isInfoEnabled()) {
            log.info(Event.getHeader());
        }
    }

    public Lock getWriteLock() {
        return this.ndx.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEvent(Event e) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        long now = System.currentTimeMillis();
        LinkedHashMap<UUID, Event> linkedHashMap = this.eventCache;
        synchronized (linkedHashMap) {
            this.pruneHistory(now);
            Event t = this.eventCache.get(e.eventUUID);
            if (t == null) {
                this.eventCache.put(e.eventUUID, e);
                e.receiptTime = now;
                if (e.isComplete()) {
                    this.logEvent(e);
                }
            } else if (!t.isComplete()) {
                t.details = e.details;
                t.endTime = e.endTime;
                t.complete = true;
                this.logEvent(t);
            }
        }
    }

    protected void pruneHistory(long now) {
        long cutoff = now - this.eventHistoryMillis;
        Iterator<Event> itr = this.eventCache.values().iterator();
        int npruned = 0;
        while (itr.hasNext()) {
            Event t = itr.next();
            if (t.receiptTime > cutoff) break;
            itr.remove();
            if (!t.isComplete()) {
                log.error("No end? " + t);
            }
            ++npruned;
        }
        if (log.isDebugEnabled()) {
            log.debug("There are " + this.eventCache.size() + " events : cutoff=" + cutoff + ", #pruned " + npruned);
        }
    }

    protected void logEvent(Event e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (!e.isComplete()) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info(e.toString());
        }
        this.ndx.insert(e.startTime, e);
    }

    @Override
    public long rangeCount(long fromTime, long toTime) {
        return this.ndx.rangeCount(this.tupleSer.serializeKey(fromTime), this.tupleSer.serializeKey(toTime));
    }

    @Override
    public Iterator<Event> rangeIterator(long fromTime, long toTime) {
        ITupleIterator tupleItr = this.ndx.rangeIterator(this.tupleSer.serializeKey(fromTime), this.tupleSer.serializeKey(toTime));
        IStriterator itr = new Striterator(tupleItr).addFilter(new TupleObjectResolver());
        return itr;
    }

    public static class EventBTree
    extends BTree {
        public EventBTree(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
            super(store, checkpoint, metadata, readOnly);
        }

        public static EventBTree create(IRawStore store) {
            IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
            metadata.setBTreeClassName(EventBTree.class.getName());
            metadata.setTupleSerializer(new EventBTreeTupleSerializer(new ASCIIKeyBuilderFactory(8)));
            return (EventBTree)BTree.create(store, metadata);
        }

        public static EventBTree createTransient() {
            IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
            metadata.setBTreeClassName(EventBTree.class.getName());
            metadata.setTupleSerializer(new EventBTreeTupleSerializer(new ASCIIKeyBuilderFactory(8)));
            return (EventBTree)BTree.createTransient(metadata);
        }

        protected static class EventBTreeTupleSerializer
        extends DefaultTupleSerializer<Long, CommitRecordIndex.Entry> {
            private static final long serialVersionUID = -8429751113713375293L;

            public EventBTreeTupleSerializer() {
            }

            public EventBTreeTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
                super(keyBuilderFactory);
            }

            @Override
            public Long deserializeKey(ITuple tuple) {
                byte[] key = tuple.getKeyBuffer().array();
                long id = KeyBuilder.decodeLong(key, 0);
                return id;
            }

            @Override
            public byte[] serializeKey(Object obj) {
                return this.getKeyBuilder().reset().append((Long)obj).getKey();
            }
        }
    }
}

