/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.service.AbstractIndexCache;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.service.ndx.IScaleOutClientIndex;

public class IndexCache
extends AbstractIndexCache<IScaleOutClientIndex> {
    private final AbstractScaleOutFederation<?> fed;

    public IndexCache(AbstractScaleOutFederation<?> fed, int capacity, long timeout) {
        super(capacity, timeout);
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
    }

    @Override
    protected ClientIndexView newView(String name, long timestamp) {
        IMetadataIndex mdi = this.fed.getMetadataIndex(name, timestamp);
        if (mdi == null) {
            if (log.isInfoEnabled()) {
                log.info("name=" + name + " @ " + timestamp + " : is not registered");
            }
            return null;
        }
        return new ClientIndexView(this.fed, name, timestamp, mdi);
    }

    @Override
    protected void dropIndexFromCache(String name) {
        super.dropIndexFromCache(name);
        this.fed.getMetadataIndexCache().dropIndexFromCache(name);
    }
}

