/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.fts;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ASTFulltextSearchOptimizer;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.MockIVReturningServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.fts.FTS;
import com.bigdata.service.fts.FulltextSearchException;
import com.bigdata.service.fts.FulltextSearchHiterator;
import com.bigdata.service.fts.IFulltextSearch;
import com.bigdata.service.fts.IFulltextSearchHit;
import com.bigdata.service.fts.impl.SolrFulltextSearchImpl;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class FulltextSearchServiceFactory
extends AbstractServiceFactoryBase {
    private static final Logger log = Logger.getLogger(FulltextSearchServiceFactory.class);
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public FulltextSearchServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public MockIVReturningServiceCall create(ServiceCallCreateParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = params.getTripleStore();
        Properties props = FulltextSearchServiceFactory.getStoreProps(params);
        FulltextSearchDefaults deflts = new FulltextSearchDefaults(props);
        ServiceNode serviceNode = params.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        Map<IVariable<?>, Map<URI, StatementPatternNode>> map = this.verifyGraphPattern(store, serviceNode.getGraphPattern());
        if (map == null) {
            throw new FulltextSearchException("Not a search request.");
        }
        if (map.size() != 1) {
            throw new FulltextSearchException("Multiple search requests may not be combined.");
        }
        Map.Entry<IVariable<?>, Map<URI, StatementPatternNode>> e = map.entrySet().iterator().next();
        IVariable<?> searchVar = e.getKey();
        Map<URI, StatementPatternNode> statementPatterns = e.getValue();
        this.validateSearch(searchVar, statementPatterns);
        return new FulltextSearchServiceCall(store, searchVar, statementPatterns, this.getServiceOptions(), deflts, params);
    }

    public static Properties getStoreProps(ServiceCallCreateParams params) {
        AbstractTripleStore store = params.getTripleStore();
        return store.getIndexManager() != null && store.getIndexManager() instanceof AbstractJournal ? ((AbstractJournal)store.getIndexManager()).getProperties() : null;
    }

    private Map<IVariable<?>, Map<URI, StatementPatternNode>> verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group) {
        LinkedHashMap<IVariableOrConstant, LinkedHashMap<URI, StatementPatternNode>> tmp = null;
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            LinkedHashMap<URI, StatementPatternNode> statementPatterns;
            BOp child = group.get(i);
            if (child instanceof GroupNodeBase) {
                throw new FulltextSearchException("Nested groups are not allowed.");
            }
            if (!(child instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)child;
            TermNode p = sp.p();
            if (!p.isConstant()) {
                throw new FulltextSearchException("Expecting search predicate: " + sp);
            }
            URI uri = (URI)((Object)((ConstantNode)p).getValue());
            if (!uri.stringValue().startsWith("http://www.bigdata.com/rdf/fts#")) {
                throw new FulltextSearchException("Expecting search predicate: " + sp);
            }
            if (!ASTFulltextSearchOptimizer.searchUris.contains(uri)) {
                throw new FulltextSearchException("Unknown search predicate: " + uri);
            }
            TermNode s = sp.s();
            if (!s.isVariable()) {
                throw new FulltextSearchException("Subject of search predicate is constant: " + sp);
            }
            IVariableOrConstant searchVar = ((VarNode)s).getValueExpression();
            if (tmp == null) {
                tmp = new LinkedHashMap<IVariableOrConstant, LinkedHashMap<URI, StatementPatternNode>>();
            }
            if ((statementPatterns = (LinkedHashMap<URI, StatementPatternNode>)tmp.get(searchVar)) == null) {
                statementPatterns = new LinkedHashMap<URI, StatementPatternNode>();
                tmp.put(searchVar, statementPatterns);
            }
            statementPatterns.put(uri, sp);
        }
        return tmp;
    }

    private void validateSearch(IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (StatementPatternNode sp : statementPatterns.values()) {
            URI uri = (URI)((Object)sp.p().getValue());
            if (!uris.add(uri)) {
                throw new FulltextSearchException("Search predicate appears multiple times for same searchvariable: predicate=" + uri + ", searchVar=" + searchVar);
            }
            if (uri.equals(FTS.SEARCH) || uri.equals(FTS.ENDPOINT) || uri.equals(FTS.ENDPOINT_TYPE) || uri.equals(FTS.PARAMS) || uri.equals(FTS.SEARCH_RESULT_TYPE) || uri.equals(FTS.SEARCH_FIELD) || uri.equals(FTS.SCORE_FIELD) || uri.equals(FTS.SNIPPET_FIELD) || uri.equals(FTS.TIMEOUT)) {
                this.assertObjectIsLiteralOrVariable(sp);
                continue;
            }
            if (uri.equals(FTS.SCORE) || uri.equals(FTS.SNIPPET)) {
                this.assertObjectIsVariable(sp);
                continue;
            }
            throw new AssertionError((Object)("Unverified search predicate: " + sp));
        }
        if (!uris.contains(FTS.SEARCH)) {
            throw new FulltextSearchException("Search string not specified or empty");
        }
    }

    private void assertObjectIsLiteralOrVariable(StatementPatternNode sp) {
        boolean isNotVariable;
        TermNode o = sp.o();
        boolean isNotLiterale = !o.isConstant() || !(((ConstantNode)o).getValue() instanceof Literal);
        boolean bl = isNotVariable = !o.isVariable();
        if (isNotLiterale && isNotVariable) {
            throw new IllegalArgumentException("Object is not literal or variable: " + sp);
        }
    }

    private void assertObjectIsVariable(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isVariable()) {
            throw new IllegalArgumentException("Object must be variable: " + sp);
        }
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        HashSet requiredBound = new HashSet();
        for (StatementPatternNode sp : this.getStatementPatterns(serviceNode)) {
            URI predicate = (URI)((Object)sp.p().getValue());
            IValueExpression object = sp.o().getValueExpression();
            if (!(object instanceof IVariable) || !predicate.equals(FTS.SEARCH) && !predicate.equals(FTS.ENDPOINT) && !predicate.equals(FTS.ENDPOINT_TYPE) && !predicate.equals(FTS.PARAMS) && !predicate.equals(FTS.SEARCH_RESULT_TYPE) && !predicate.equals(FTS.SEARCH_FIELD) && !predicate.equals(FTS.SCORE_FIELD) && !predicate.equals(FTS.SNIPPET_FIELD) && !predicate.equals(FTS.TIMEOUT)) continue;
            requiredBound.add((IVariable)object);
        }
        return requiredBound;
    }

    Collection<StatementPatternNode> getStatementPatterns(ServiceNode serviceNode) {
        ArrayList<StatementPatternNode> statementPatterns = new ArrayList<StatementPatternNode>();
        for (IGroupMemberNode child : serviceNode.getGraphPattern()) {
            if (child instanceof StatementPatternNode) {
                statementPatterns.add((StatementPatternNode)child);
                continue;
            }
            throw new FulltextSearchException("Nested groups are not allowed.");
        }
        return statementPatterns;
    }

    public static class FulltextSearchDefaults {
        final String defaultEndpoint;
        final String defaultEndpointType;
        final String defaultSearchResultType;
        final String defaultTimeout;
        final String defaultParams;
        final String defaultSearchField;
        final String defaultScoreField;
        final String defaultSnippetField;

        public FulltextSearchDefaults(Properties p) {
            this.defaultEndpoint = p.getProperty(FTS.Options.FTS_ENDPOINT);
            this.defaultEndpointType = p.getProperty(FTS.Options.FTS_ENDPOINT_TYPE);
            this.defaultSearchResultType = p.getProperty(FTS.Options.FTS_SEARCH_RESULT_TYPE);
            this.defaultTimeout = p.getProperty(FTS.Options.FTS_TIMEOUT);
            this.defaultParams = p.getProperty(FTS.Options.FTS_PARAMS);
            this.defaultSearchField = p.getProperty(FTS.Options.FTS_SEARCH_FIELD);
            this.defaultScoreField = p.getProperty(FTS.Options.FTS_SCORE_FIELD);
            this.defaultSnippetField = p.getProperty(FTS.Options.FTS_SNIPPET_FIELD);
        }

        public String getDefaultEndpoint() {
            return this.defaultEndpoint;
        }

        public String getDefaultEndpointType() {
            return this.defaultEndpointType;
        }

        public String getDefaultSearchResultType() {
            return this.defaultSearchResultType;
        }

        public String getDefaultTimeout() {
            return this.defaultTimeout;
        }

        public String getDefaultParams() {
            return this.defaultParams;
        }

        public String getDefaultSearchField() {
            return this.defaultSearchField;
        }

        public String getDefaultScoreField() {
            return this.defaultScoreField;
        }

        public String getDefaultSnippetField() {
            return this.defaultSnippetField;
        }
    }

    public static class FulltextSearchMultiHiterator<A extends IFulltextSearchHit> {
        final IBindingSet[] bindingSet;
        final TermNode query;
        final TermNode endpoint;
        final TermNode endpointType;
        final TermNode params;
        final TermNode searchResultType;
        final TermNode searchTimeout;
        final TermNode searchField;
        final TermNode scoreField;
        final TermNode snippetField;
        final ServiceCallCreateParams serviceCallParams;
        final FulltextSearchDefaults defaults;
        int nextBindingSetItr = 0;
        FulltextSearchHiterator<IFulltextSearchHit> curDelegate;

        public FulltextSearchMultiHiterator(IBindingSet[] bindingSet, TermNode query, TermNode endpoint, TermNode endpointType, TermNode params, TermNode searchField, TermNode scoreField, TermNode snippetField, TermNode searchResultType, TermNode searchTimeout, FulltextSearchDefaults defaults, ServiceCallCreateParams serviceCallParams) {
            this.query = query;
            this.bindingSet = bindingSet;
            this.endpoint = endpoint;
            this.endpointType = endpointType;
            this.params = params;
            this.searchResultType = searchResultType;
            this.searchTimeout = searchTimeout;
            this.searchField = searchField;
            this.scoreField = scoreField;
            this.snippetField = snippetField;
            this.defaults = defaults;
            this.serviceCallParams = serviceCallParams;
            this.init();
        }

        public boolean hasNext() {
            if (this.curDelegate == null) {
                return false;
            }
            if (this.curDelegate.hasNext()) {
                return true;
            }
            if (this.nextDelegate()) {
                return this.hasNext();
            }
            return false;
        }

        public A next() {
            if (this.curDelegate == null) {
                return null;
            }
            if (this.curDelegate.hasNext()) {
                return (A)this.curDelegate.next();
            }
            if (this.nextDelegate()) {
                return this.next();
            }
            return null;
        }

        private boolean nextDelegate() {
            if (this.bindingSet == null || this.nextBindingSetItr >= this.bindingSet.length) {
                this.curDelegate = null;
                return false;
            }
            IBindingSet bs = this.bindingSet[this.nextBindingSetItr++];
            String query = this.resolveQuery(bs);
            String endpoint = this.resolveEndpoint(bs);
            String endpointType = this.resolveEndpointType(bs);
            String params = this.resolveParams(bs);
            FTS.SearchResultType searchResultType = this.resolveSearchResultType(bs);
            Integer searchTimeout = this.resolveSearchTimeout(bs);
            String searchField = this.resolveSearchField(bs);
            String scoreField = this.resolveScoreField(bs);
            String snippetField = this.resolveSnippetField(bs);
            IFulltextSearch ftSearch = this.getSearchClass(endpointType);
            IFulltextSearch.FulltextSearchQuery sq = new IFulltextSearch.FulltextSearchQuery(query, params, endpoint, searchTimeout, searchField, scoreField, snippetField, bs, searchResultType);
            this.curDelegate = ftSearch.search(sq, this.serviceCallParams.getClientConnectionManager());
            return true;
        }

        private IFulltextSearch getDefaultSearchImpl() {
            return new SolrFulltextSearchImpl();
        }

        private IFulltextSearch getSearchClass(String className) {
            if (className == null) {
                return this.getDefaultSearchImpl();
            }
            try {
                Class<?> endpointClass = Class.forName(className);
                if (!endpointClass.isInstance(IFulltextSearch.class)) {
                    if (log.isDebugEnabled()) {
                        log.warn("Endpoint class: " + this.endpointType + " does not implement IFulltextSearch ->" + " will be ignored, using default.");
                    }
                    return this.getDefaultSearchImpl();
                }
                return (IFulltextSearch)endpointClass.newInstance();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Illegal endpoint class: " + this.endpointType + " -> will be ignored, using default.");
                }
                return this.getDefaultSearchImpl();
            }
        }

        private void init() {
            this.nextDelegate();
        }

        private String resolveQuery(IBindingSet bs) {
            String queryStr = this.resolveAsString(this.query, bs);
            if (queryStr == null || queryStr.isEmpty()) {
                throw new FulltextSearchException("Search string not specified or empty");
            }
            return queryStr;
        }

        private FTS.SearchResultType resolveSearchResultType(IBindingSet bs) {
            block4: {
                String searchResultTypeStr = this.resolveAsString(this.searchResultType, bs);
                if (searchResultTypeStr == null || searchResultTypeStr.isEmpty()) {
                    searchResultTypeStr = this.defaults.getDefaultSearchResultType();
                }
                if (searchResultTypeStr != null && !searchResultTypeStr.isEmpty()) {
                    try {
                        return FTS.SearchResultType.valueOf(searchResultTypeStr);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block4;
                        log.warn("Illegal target type: " + searchResultTypeStr);
                    }
                }
            }
            return FTS.Options.DEFAULT_SEARCH_RESULT_TYPE;
        }

        private Integer resolveSearchTimeout(IBindingSet bs) {
            block4: {
                String searchTimeoutStr = this.resolveAsString(this.searchTimeout, bs);
                if (searchTimeoutStr == null) {
                    searchTimeoutStr = this.defaults.getDefaultTimeout();
                }
                if (searchTimeoutStr != null && !searchTimeoutStr.isEmpty()) {
                    try {
                        return Integer.valueOf(searchTimeoutStr);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isInfoEnabled()) break block4;
                        log.info("Illegal timeout string: " + searchTimeoutStr + " -> will be ignored, using default.");
                    }
                }
            }
            return Integer.MAX_VALUE;
        }

        private String resolveParams(IBindingSet bs) {
            String paramStr = this.resolveAsString(this.params, bs);
            if (paramStr == null) {
                paramStr = this.defaults.getDefaultParams();
            }
            return paramStr == null || paramStr.isEmpty() ? "" : paramStr;
        }

        private String resolveEndpointType(IBindingSet bs) {
            block8: {
                String endpointTypeStr = this.resolveAsString(this.endpointType, bs);
                if (endpointTypeStr == null) {
                    endpointTypeStr = this.defaults.getDefaultEndpointType();
                }
                if (endpointTypeStr != null && !endpointTypeStr.isEmpty()) {
                    String endpointName = FTS.FTS_CUSTOM_TYPE + endpointTypeStr;
                    Properties props = FulltextSearchServiceFactory.getStoreProps(this.serviceCallParams);
                    try {
                        if (props.contains(endpointName)) {
                            return props.getProperty(endpointName);
                        }
                        switch (FTS.EndpointType.valueOf(endpointTypeStr)) {
                            case SOLR: {
                                return SolrFulltextSearchImpl.class.getName();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.warn("Illegal endpoint type: " + endpointTypeStr + " -> will be ignored, using default.");
                    }
                }
            }
            return null;
        }

        private String resolveEndpoint(IBindingSet bs) {
            String endpointStr = this.resolveAsString(this.endpoint, bs);
            if (endpointStr == null || endpointStr.isEmpty()) {
                endpointStr = this.defaults.getDefaultEndpoint();
            }
            if (endpointStr != null && !endpointStr.isEmpty()) {
                return endpointStr;
            }
            throw new FulltextSearchException("Endpoint not specified or empty");
        }

        private String resolveSearchField(IBindingSet bs) {
            String searchFieldStr = this.resolveAsString(this.searchField, bs);
            if (searchFieldStr == null || searchFieldStr.isEmpty()) {
                searchFieldStr = this.defaults.getDefaultSearchField();
            }
            return searchFieldStr == null || searchFieldStr.isEmpty() ? "id" : searchFieldStr;
        }

        private String resolveScoreField(IBindingSet bs) {
            String scoreFieldStr = this.resolveAsString(this.scoreField, bs);
            if (scoreFieldStr == null || scoreFieldStr.isEmpty()) {
                scoreFieldStr = this.defaults.getDefaultScoreField();
            }
            return scoreFieldStr == null || scoreFieldStr.isEmpty() ? FTS.Options.DEFAULT_SCORE_FIELD : scoreFieldStr;
        }

        private String resolveSnippetField(IBindingSet bs) {
            String snippetFieldStr = this.resolveAsString(this.snippetField, bs);
            if (snippetFieldStr == null || snippetFieldStr.isEmpty()) {
                snippetFieldStr = this.defaults.getDefaultSnippetField();
            }
            return snippetFieldStr == null || snippetFieldStr.isEmpty() ? FTS.Options.DEFAULT_SNIPPET_FIELD : snippetFieldStr;
        }

        private String resolveAsString(TermNode termNode, IBindingSet bs) {
            if (termNode == null) {
                return null;
            }
            if (termNode.isConstant()) {
                Literal lit = (Literal)((Object)termNode.getValue());
                return lit == null ? null : lit.stringValue();
            }
            if (bs == null) {
                return null;
            }
            IVariable var = (IVariable)termNode.getValueExpression();
            if (bs.isBound(var)) {
                IConstant c = bs.get(var);
                if (c == null || c.get() == null || !(c.get() instanceof TermId)) {
                    return null;
                }
                TermId cAsTerm = (TermId)c.get();
                return cAsTerm.stringValue();
            }
            throw new FulltextSearchException("Service magic variable unbound at runtime:" + var);
        }
    }

    private static class FulltextSearchServiceCall
    implements MockIVReturningServiceCall {
        private final AbstractTripleStore store;
        private final IServiceOptions serviceOptions;
        private final TermNode query;
        private final TermNode endpoint;
        private final TermNode endpointType;
        private final TermNode params;
        private final TermNode searchResultType;
        private final TermNode searchTimeout;
        private final TermNode searchField;
        private final TermNode scoreField;
        private final TermNode snippetField;
        private final FulltextSearchDefaults defaults;
        private final ServiceCallCreateParams serviceCallParams;
        private final IVariable<IV>[] vars;

        public FulltextSearchServiceCall(AbstractTripleStore store, IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns, IServiceOptions serviceOptions, FulltextSearchDefaults defaults, ServiceCallCreateParams serviceCallParams) {
            if (store == null) {
                throw new IllegalArgumentException();
            }
            if (searchVar == null) {
                throw new IllegalArgumentException();
            }
            if (statementPatterns == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            this.store = store;
            this.serviceOptions = serviceOptions;
            this.defaults = defaults;
            this.serviceCallParams = serviceCallParams;
            StatementPatternNode sp = statementPatterns.get(FTS.SEARCH);
            this.query = sp.o();
            IVariable score = null;
            IVariable snippet = null;
            TermNode endpoint = null;
            TermNode endpointType = null;
            TermNode params = null;
            TermNode searchResultType = null;
            TermNode searchTimeout = null;
            TermNode searchField = null;
            TermNode scoreField = null;
            TermNode snippetField = null;
            for (StatementPatternNode meta : statementPatterns.values()) {
                IVariable oVar;
                URI p = (URI)((Object)meta.p().getValue());
                IVariable iVariable = oVar = meta.o().isVariable() ? (IVariable)meta.o().getValueExpression() : null;
                if (FTS.ENDPOINT.equals(p)) {
                    endpoint = meta.o();
                    continue;
                }
                if (FTS.ENDPOINT_TYPE.equals(p)) {
                    endpointType = meta.o();
                    continue;
                }
                if (FTS.PARAMS.equals(p)) {
                    params = meta.o();
                    continue;
                }
                if (FTS.SEARCH_RESULT_TYPE.equals(p)) {
                    searchResultType = meta.o();
                    continue;
                }
                if (FTS.TIMEOUT.equals(p)) {
                    searchTimeout = meta.o();
                    continue;
                }
                if (FTS.SEARCH_FIELD.equals(p)) {
                    searchField = meta.o();
                    continue;
                }
                if (FTS.SNIPPET_FIELD.equals(p)) {
                    snippetField = meta.o();
                    continue;
                }
                if (FTS.SCORE_FIELD.equals(p)) {
                    scoreField = meta.o();
                    continue;
                }
                if (FTS.SCORE.equals(p)) {
                    score = oVar;
                    continue;
                }
                if (!FTS.SNIPPET.equals(p)) continue;
                snippet = oVar;
            }
            Var<?> dummyScoreVar = Var.var();
            Var<?> dummySnippetVar = Var.var();
            dummyScoreVar.setAnonymous(true);
            dummySnippetVar.setAnonymous(true);
            this.vars = new IVariable[]{searchVar, score == null ? dummyScoreVar : score, snippet == null ? dummySnippetVar : snippet};
            this.endpoint = endpoint;
            this.endpointType = endpointType;
            this.params = params;
            this.searchResultType = searchResultType;
            this.searchTimeout = searchTimeout;
            this.searchField = searchField;
            this.scoreField = scoreField;
            this.snippetField = snippetField;
        }

        private FulltextSearchMultiHiterator<IFulltextSearchHit<?>> getSolrSearchResultIterator(IBindingSet[] bsList) {
            return new FulltextSearchMultiHiterator(bsList, this.query, this.endpoint, this.endpointType, this.params, this.searchField, this.scoreField, this.snippetField, this.searchResultType, this.searchTimeout, this.defaults, this.serviceCallParams);
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] incomingBs) {
            FulltextSearchMultiHiterator<IFulltextSearchHit<?>> hiterator = this.getSolrSearchResultIterator(incomingBs);
            return new FulltextSearchHitConverter(hiterator);
        }

        @Override
        public List<IVariable<IV>> getMockVariables() {
            LinkedList<IVariable<IV>> externalVars = new LinkedList<IVariable<IV>>();
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i].isAnonymous()) continue;
                externalVars.add(this.vars[i]);
            }
            return externalVars;
        }

        private class FulltextSearchHitConverter
        implements ICloseableIterator<IBindingSet> {
            private final FulltextSearchMultiHiterator<IFulltextSearchHit<?>> src;
            private IFulltextSearchHit<?> current = null;
            private boolean open = true;

            public FulltextSearchHitConverter(FulltextSearchMultiHiterator<IFulltextSearchHit<?>> src) {
                this.src = src;
            }

            @Override
            public void close() {
                if (this.open) {
                    this.open = false;
                }
            }

            @Override
            public boolean hasNext() {
                if (!this.open) {
                    return false;
                }
                if (this.current != null) {
                    return true;
                }
                if (this.src.hasNext()) {
                    this.current = this.src.next();
                    return true;
                }
                return this.current != null;
            }

            @Override
            public IBindingSet next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IFulltextSearchHit<?> tmp = this.current;
                this.current = null;
                return this.newBindingSet(tmp);
            }

            private IBindingSet newBindingSet(IFulltextSearchHit<?> hit) {
                BigdataValue val;
                BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance(FulltextSearchServiceCall.this.store.getLexiconRelation().getNamespace());
                switch (hit.getSearchResultType()) {
                    case LITERAL: {
                        val = vf.createLiteral(hit.getRes());
                        break;
                    }
                    default: {
                        try {
                            val = vf.createURI(hit.getRes());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new FulltextSearchException("Casting of result to URI failed:" + hit.getRes());
                        }
                    }
                }
                ListBindingSet bs = new ListBindingSet();
                bs.set(FulltextSearchServiceCall.this.vars[0], new Constant<IV>(DummyConstantNode.toDummyIV(val)));
                if (hit.getScore() != null) {
                    bs.set(FulltextSearchServiceCall.this.vars[1], new Constant(new XSDNumericIV(hit.getScore())));
                }
                if (hit.getSnippet() != null) {
                    BigdataLiteral litSnippet = vf.createLiteral(hit.getSnippet());
                    bs.set(FulltextSearchServiceCall.this.vars[2], new Constant<Constant<IV>>(new Constant<IV>(DummyConstantNode.toDummyIV(litSnippet))));
                }
                IBindingSet baseBs = hit.getIncomingBindings();
                Iterator<IVariable> varIt = baseBs.vars();
                while (varIt.hasNext()) {
                    IVariable var = varIt.next();
                    if (bs.isBound(var)) {
                        throw new FulltextSearchException("Illegal use of search service. Variable ?" + var + " must not be bound from outside. If you need to " + " join on the variable, you may try nesting the" + " SERVICE in a WITH block and join outside.");
                    }
                    bs.set(var, baseBs.get(var));
                }
                if (log.isTraceEnabled()) {
                    log.trace(bs);
                    log.trace(FulltextSearchServiceCall.this.query.getClass());
                    log.trace(((BigdataLiteral)((Object)FulltextSearchServiceCall.this.query)).getIV());
                    log.trace(((BigdataLiteral)((Object)FulltextSearchServiceCall.this.query)).getIV().getClass());
                }
                return bs;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

