/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.fts.impl;

import com.bigdata.service.fts.FulltextSearchException;
import com.bigdata.service.fts.FulltextSearchHit;
import com.bigdata.service.fts.FulltextSearchHiterator;
import com.bigdata.service.fts.IFulltextSearch;
import com.bigdata.service.fts.IFulltextSearchHit;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.FutureResponseListener;

public class SolrFulltextSearchImpl
implements IFulltextSearch<FulltextSearchHit> {
    private static final transient Logger log = Logger.getLogger(SolrFulltextSearchImpl.class);

    @Override
    public FulltextSearchHiterator<FulltextSearchHit> search(IFulltextSearch.FulltextSearchQuery query, HttpClient client) {
        if (query != null) {
            try {
                IFulltextSearchHit[] hits = this.queryIndex(query, client);
                return new FulltextSearchHiterator(hits);
            }
            catch (Exception e) {
                throw new FulltextSearchException("Error execution fulltext search: " + e);
            }
        }
        return new FulltextSearchHiterator((IFulltextSearchHit[])new FulltextSearchHit[0]);
    }

    private FulltextSearchHit[] queryIndex(IFulltextSearch.FulltextSearchQuery query, HttpClient httpClient) throws Exception {
        Integer queryTimeoutSpecified;
        if (httpClient.isStopped()) {
            throw new FulltextSearchException("The client has been stopped");
        }
        Request request = httpClient.newRequest(query.getEndpoint());
        FutureResponseListener listener = new FutureResponseListener(request, 0xA00000);
        request.param("q", query.getQuery());
        request.param("wt", "json");
        String searchParams = query.getParams();
        if (searchParams != null && !searchParams.isEmpty()) {
            String[] params = searchParams.split("&");
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                String[] kv = params[i].split("=");
                if (kv.length == 2 && kv[0] != null && !kv[0].isEmpty()) {
                    if (kv[0].equals("wt")) continue;
                    try {
                        String val = kv[1] == null ? "" : URLDecoder.decode(kv[1], "UTF-8");
                        request.param(kv[0], val);
                    }
                    catch (Exception e) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("Solr search param: '" + params[i] + "'" + "' can't be URL decoded. Will be ignored...");
                    }
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info("Invalid Solr search param: '" + params[i] + "'");
                log.info("Will be ignored...");
            }
        }
        Integer queryTimeoutUsed = (queryTimeoutSpecified = query.getSearchTimeout()) == null ? Integer.MAX_VALUE : queryTimeoutSpecified;
        request.send(listener);
        ContentResponse resp = listener.get(queryTimeoutUsed.intValue(), TimeUnit.MILLISECONDS);
        int statusCode = resp.getStatus();
        if (statusCode != 200) {
            throw new FulltextSearchException("Status code != 200 received from external fulltext service: " + statusCode);
        }
        String jsonStr = resp.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        return this.constructFulltextSearchList(json, query);
    }

    private FulltextSearchHit[] constructFulltextSearchList(JSONObject solrResultsJSON, IFulltextSearch.FulltextSearchQuery query) throws JSONException {
        String searchColumn = query.getSearchField();
        String snippetColumn = query.getSnippetField();
        String scoreColumn = query.getScoreField();
        JSONObject resp = solrResultsJSON.getJSONObject("response");
        JSONArray docs = resp.getJSONArray("docs");
        ArrayList searchHits = new ArrayList(docs.length());
        for (int i = 0; i < docs.length(); ++i) {
            Double scoreAsDouble;
            String snippet;
            String search;
            block7: {
                JSONObject result = docs.getJSONObject(i);
                search = null;
                if (searchColumn == null || searchColumn.isEmpty() || !result.has(searchColumn)) {
                    throw new FulltextSearchException("Search field undefined, empty, or does not exist.");
                }
                search = this.flattenJsonResult(result.get(searchColumn));
                snippet = null;
                if (snippetColumn != null && !snippetColumn.isEmpty()) {
                    snippet = result.has(snippetColumn) ? this.flattenJsonResult(result.get(snippetColumn)) : null;
                }
                String score = null;
                if (scoreColumn != null && !scoreColumn.isEmpty()) {
                    score = result.has(scoreColumn) ? this.flattenJsonResult(result.get(scoreColumn)) : null;
                }
                scoreAsDouble = null;
                if (score != null) {
                    try {
                        scoreAsDouble = Double.valueOf(score);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isInfoEnabled()) break block7;
                        log.info("Could not cast score to double: " + score);
                    }
                }
            }
            if (search == null || search.isEmpty()) continue;
            FulltextSearchHit currentHit = new FulltextSearchHit(search, scoreAsDouble, snippet, query.getIncomingBindings(), query.getSearchResultType());
            searchHits.add(currentHit);
        }
        return searchHits.toArray(new FulltextSearchHit[searchHits.size()]);
    }

    String flattenJsonResult(Object obj) {
        if (obj instanceof JSONArray) {
            StringBuffer buf = new StringBuffer();
            JSONArray arr = (JSONArray)obj;
            for (int i = 0; i < arr.length(); ++i) {
                try {
                    Object cur = arr.get(i);
                    if (cur == null) continue;
                    buf.append(cur.toString());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return buf.toString();
        }
        return obj.toString();
    }
}

