/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialDatatypeConfigurationError;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class GeoSpatialConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JSON_STR_CONFIG = "config";
    private static final String JSON_STR_URI = "uri";
    private static final String JSON_STR_LITERALSERIALIZER = "literalSerializer";
    private static final String JSON_STR_FIELDS = "fields";
    private static final transient Logger log = Logger.getLogger(GeoSpatialConfig.class);
    private List<GeoSpatialDatatypeConfiguration> datatypeConfigs;
    private URI defaultDatatype;

    public GeoSpatialConfig(List<String> geoSpatialDatatypeConfigs, String defaultDatatype) {
        this.initDatatypes(geoSpatialDatatypeConfigs);
        if (defaultDatatype != null && !defaultDatatype.isEmpty()) {
            try {
                this.defaultDatatype = new URIImpl(defaultDatatype);
            }
            catch (Exception e) {
                throw new InvalidGeoSpatialDatatypeConfigurationError("Invalid default datatype (" + defaultDatatype + ") does not represent a URI.");
            }
            boolean isRegistered = false;
            for (GeoSpatialDatatypeConfiguration config : this.datatypeConfigs) {
                isRegistered |= config.getUri().equals(this.defaultDatatype);
            }
            if (!isRegistered) {
                throw new InvalidGeoSpatialDatatypeConfigurationError("Invalid default datatype (" + defaultDatatype + ") is not a registered geospatial datatype.");
            }
        }
    }

    private void initDatatypes(List<String> geoSpatialDatatypeConfigs) {
        this.datatypeConfigs = new ArrayList<GeoSpatialDatatypeConfiguration>();
        if (geoSpatialDatatypeConfigs == null) {
            return;
        }
        for (String configStr : geoSpatialDatatypeConfigs) {
            if (configStr == null || configStr.isEmpty()) continue;
            try {
                JSONObject json = new JSONObject(configStr);
                JSONObject topLevelNode = (JSONObject)json.get(JSON_STR_CONFIG);
                String uri = (String)topLevelNode.get(JSON_STR_URI);
                String literalSerializer = topLevelNode.has(JSON_STR_LITERALSERIALIZER) ? (String)topLevelNode.get(JSON_STR_LITERALSERIALIZER) : null;
                JSONArray fields = (JSONArray)topLevelNode.get(JSON_STR_FIELDS);
                this.datatypeConfigs.add(new GeoSpatialDatatypeConfiguration(uri, literalSerializer, fields));
            }
            catch (JSONException e) {
                log.warn("Illegal JSON configuration: " + e.getMessage());
                throw new IllegalArgumentException(e);
            }
            HashSet<URI> uris = new HashSet<URI>();
            for (int i = 0; i < this.datatypeConfigs.size(); ++i) {
                URI curUri = this.datatypeConfigs.get(i).getUri();
                if (uris.contains(curUri)) {
                    throw new IllegalArgumentException("Duplicate URI used for geospatial datatype config: " + curUri);
                }
                uris.add(curUri);
            }
        }
    }

    public GeoSpatialDatatypeConfiguration getConfigurationForDatatype(URI datatypeUri) {
        for (int i = 0; i < this.datatypeConfigs.size(); ++i) {
            GeoSpatialDatatypeConfiguration cur = this.datatypeConfigs.get(i);
            if (!cur.getUri().equals(datatypeUri)) continue;
            return cur;
        }
        return null;
    }

    public List<GeoSpatialDatatypeConfiguration> getDatatypeConfigs() {
        return this.datatypeConfigs;
    }

    public URI getDefaultDatatype() {
        return this.defaultDatatype;
    }
}

