/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialDatatypeConfigurationError;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GeoSpatialDatatypeFieldConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(GeoSpatialDatatypeFieldConfiguration.class);
    private static final String JSON_STR_VALUETYPE = "valueType";
    private static final String JSON_STR_MINVALUE = "minValue";
    private static final String JSON_STR_MULTIPLIER = "multiplier";
    private static final String JSON_STR_SERVICEMAPPING = "serviceMapping";
    private final ValueType valueType;
    private Long minValue;
    private long multiplier;
    private ServiceMapping serviceMapping = ServiceMapping.CUSTOM;
    private String customServiceMapping;

    public GeoSpatialDatatypeFieldConfiguration(JSONObject fieldJson) throws InvalidGeoSpatialDatatypeConfigurationError {
        try {
            String multiplierStr;
            String minValueStr;
            this.valueType = ValueType.valueOf((String)fieldJson.get(JSON_STR_VALUETYPE));
            this.minValue = null;
            if (fieldJson.has(JSON_STR_MINVALUE) && (minValueStr = (String)fieldJson.get(JSON_STR_MINVALUE)) != null && !minValueStr.isEmpty()) {
                this.minValue = Long.valueOf(minValueStr);
            }
            this.multiplier = 1L;
            if (fieldJson.has(JSON_STR_MULTIPLIER) && (multiplierStr = (String)fieldJson.get(JSON_STR_MULTIPLIER)) != null && !multiplierStr.isEmpty()) {
                this.multiplier = Long.valueOf(multiplierStr);
            }
            String serviceMappingStr = (String)fieldJson.get(JSON_STR_SERVICEMAPPING);
            try {
                this.serviceMapping = ServiceMapping.valueOf((String)fieldJson.get(JSON_STR_SERVICEMAPPING));
                this.customServiceMapping = null;
            }
            catch (Exception e) {
                this.customServiceMapping = serviceMappingStr;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Expecting values that are of type long for minValue and multiplier.");
            throw new InvalidGeoSpatialDatatypeConfigurationError(e.getMessage());
        }
        catch (JSONException e) {
            log.warn("Field could not be parsed: " + e.getMessage());
            throw new InvalidGeoSpatialDatatypeConfigurationError(e.getMessage());
        }
        catch (Exception e) {
            log.warn("Exception while initializing field: " + e.getMessage());
            throw new InvalidGeoSpatialDatatypeConfigurationError(e.getMessage());
        }
    }

    public GeoSpatialDatatypeFieldConfiguration(ValueType valueType, Long minValue, long multiplier, ServiceMapping serviceMapping, String customServiceMapping) {
        this.valueType = valueType;
        this.minValue = minValue;
        this.multiplier = multiplier;
        this.serviceMapping = serviceMapping;
        this.customServiceMapping = customServiceMapping;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Long getMinValue() {
        return this.minValue;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public ServiceMapping getServiceMapping() {
        return this.serviceMapping;
    }

    public String getCustomServiceMapping() {
        return this.customServiceMapping;
    }

    public static enum ServiceMapping {
        LATITUDE,
        LONGITUDE,
        TIME,
        COORD_SYSTEM,
        CUSTOM;

    }

    public static enum ValueType {
        LONG,
        DOUBLE;

    }
}

