/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.util.BytesUtil;
import java.util.Arrays;

public class ZOrderRangeScanUtil {
    final int zOrderArrayLength;
    private final byte[] searchMinZOrder;
    private final byte[] searchMaxZOrder;
    private final int numDimensions;
    final byte[] min;
    final byte[] max;
    byte[] bigmin;

    public ZOrderRangeScanUtil(byte[] searchMinZOrder, byte[] searchMaxZOrder, int numDimensions) {
        this.searchMinZOrder = searchMinZOrder;
        this.searchMaxZOrder = searchMaxZOrder;
        this.numDimensions = numDimensions;
        this.zOrderArrayLength = searchMinZOrder.length;
        this.min = new byte[this.zOrderArrayLength];
        this.max = new byte[this.zOrderArrayLength];
        this.bigmin = new byte[this.zOrderArrayLength];
    }

    public boolean isInSearchRange(byte[] dividingRecord) {
        boolean[] dimShownToBeLargerThanMin = new boolean[this.numDimensions];
        boolean[] dimShownToBeSmallerThanMax = new boolean[this.numDimensions];
        for (int firstDifferingByte = 0; firstDifferingByte < dividingRecord.length && dividingRecord[firstDifferingByte] == this.searchMinZOrder[firstDifferingByte] && dividingRecord[firstDifferingByte] == this.searchMaxZOrder[firstDifferingByte]; ++firstDifferingByte) {
        }
        int unsatisfiedConstraintsCtr = this.numDimensions * 2;
        for (int i = firstDifferingByte * 8; i < dividingRecord.length * 8 && unsatisfiedConstraintsCtr > 0; ++i) {
            int dimension = i % this.numDimensions;
            boolean divRecordBitSet = BytesUtil.getBit(dividingRecord, i);
            if (!dimShownToBeLargerThanMin[dimension]) {
                boolean searchMinBitSet = BytesUtil.getBit(this.searchMinZOrder, i);
                if (divRecordBitSet && !searchMinBitSet) {
                    dimShownToBeLargerThanMin[dimension] = true;
                    --unsatisfiedConstraintsCtr;
                } else if (!divRecordBitSet && searchMinBitSet) {
                    return false;
                }
            }
            if (dimShownToBeSmallerThanMax[dimension]) continue;
            boolean searchMaxBitSet = BytesUtil.getBit(this.searchMaxZOrder, i);
            if (!divRecordBitSet && searchMaxBitSet) {
                dimShownToBeSmallerThanMax[dimension] = true;
                --unsatisfiedConstraintsCtr;
                continue;
            }
            if (!divRecordBitSet || searchMaxBitSet) continue;
            return false;
        }
        return true;
    }

    public byte[] calculateBigMin(byte[] dividingRecord) {
        if (dividingRecord.length != this.searchMinZOrder.length || dividingRecord.length != this.searchMaxZOrder.length) {
            throw new RuntimeException("Key dimenisions differs");
        }
        int numBytes = dividingRecord.length;
        System.arraycopy(this.searchMinZOrder, 0, this.min, 0, this.zOrderArrayLength);
        System.arraycopy(this.searchMaxZOrder, 0, this.max, 0, this.zOrderArrayLength);
        Arrays.fill(this.bigmin, (byte)0);
        boolean finished = false;
        for (int i = 0; i < numBytes * 8 && !finished; ++i) {
            boolean divRecordBitSet = BytesUtil.getBit(dividingRecord, i);
            boolean minBitSet = BytesUtil.getBit(this.min, i);
            boolean maxBitSet = BytesUtil.getBit(this.max, i);
            if (!divRecordBitSet) {
                if (!minBitSet) {
                    if (!maxBitSet) continue;
                    System.arraycopy(this.min, 0, this.bigmin, 0, this.zOrderArrayLength);
                    ZOrderRangeScanUtil.load(true, i, this.bigmin, this.numDimensions);
                    ZOrderRangeScanUtil.load(false, i, this.max, this.numDimensions);
                    continue;
                }
                if (!maxBitSet) {
                    throw new RuntimeException("MIN must be <= MAX.");
                }
                System.arraycopy(this.min, 0, this.bigmin, 0, this.zOrderArrayLength);
                finished = true;
                continue;
            }
            if (!minBitSet) {
                if (!maxBitSet) {
                    finished = true;
                    continue;
                }
                ZOrderRangeScanUtil.load(true, i, this.min, this.numDimensions);
                continue;
            }
            if (maxBitSet) continue;
            throw new RuntimeException("MIN must be <= MAX.");
        }
        return this.bigmin;
    }

    public static void load(boolean setFirst, int position, byte[] arr, int numDimensions) {
        if (setFirst) {
            int n = position / 8;
            arr[n] = (byte)(arr[n] | 1 << 7 - position % 8);
        } else {
            int n = position / 8;
            arr[n] = (byte)(arr[n] & ~(1 << 7 - position % 8));
        }
        for (int i = position + numDimensions; i < arr.length * 8; i += numDimensions) {
            int posInByte = i % 8;
            int posInByteInv = 7 - posInByte;
            int mask = 1 << posInByteInv;
            posInByteInv -= numDimensions;
            while (posInByteInv >= 0) {
                mask |= 1 << posInByteInv;
                i += numDimensions;
                posInByteInv -= numDimensions;
            }
            if (setFirst) {
                int n = i / 8;
                arr[n] = (byte)(arr[n] & ~mask);
                continue;
            }
            int n = i / 8;
            arr[n] = (byte)(arr[n] | mask);
        }
    }
}

