/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.master;

import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.master.AbstractResourceScanner;
import com.bigdata.service.master.IResourceScannerFactory;
import java.io.File;
import java.io.FilenameFilter;

public class FileSystemScanner
extends AbstractResourceScanner<File> {
    protected final File fileOrDir;
    protected final FilenameFilter filter;

    public String toString() {
        return this.getClass() + "{acceptCount=" + super.getAcceptCount() + ",fileOrDir=" + this.fileOrDir + ",filter=" + (this.filter == null ? "N/A" : this.filter) + "}";
    }

    public FileSystemScanner(BlockingBuffer<File[]> buffer, File fileOrDir, FilenameFilter filter) {
        super(buffer);
        if (fileOrDir == null) {
            throw new IllegalArgumentException();
        }
        this.fileOrDir = fileOrDir;
        this.filter = filter;
    }

    @Override
    protected void runScanner() throws Exception {
        this.process2(this.fileOrDir);
    }

    private void process2(File file) throws InterruptedException {
        if (file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            if (log.isInfoEnabled()) {
                log.info("Scanning directory: " + file);
            }
            for (File f : files = this.filter == null ? file.listFiles() : file.listFiles(this.filter)) {
                this.process2(f);
            }
        } else {
            this.accept(file);
        }
    }

    public static IResourceScannerFactory<File> newFactory(final File fileOrDir, final FilenameFilter filter) {
        return new IResourceScannerFactory<File>(){
            private static final long serialVersionUID = 6440345409026346627L;

            @Override
            public AbstractResourceScanner<File> newScanner(BlockingBuffer<File[]> buffer) {
                return new FileSystemScanner(buffer, fileOrDir, filter);
            }
        };
    }
}

