/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.ndx.AbstractDataServiceProcedureTask;
import com.bigdata.service.ndx.AbstractScaleOutClientIndexView2;
import com.bigdata.service.ndx.ClientException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ClientIndexViewRefactor
extends AbstractScaleOutClientIndexView2 {
    public ClientIndexViewRefactor(AbstractScaleOutFederation fed, String name, long timestamp, IMetadataIndex metadataIndex) {
        super(fed, name, timestamp, metadataIndex);
    }

    @Override
    protected void runTasks(boolean parallel, ArrayList<AbstractDataServiceProcedureTask> tasks) {
        if (tasks.isEmpty()) {
            log.warn("No tasks to run?", new RuntimeException("No tasks to run?"));
            return;
        }
        if (this.getRecursionDepth().get() > 0) {
            this.runInCallersThread(tasks);
        } else if (tasks.size() == 1) {
            this.runOne(tasks.get(0));
        } else if (parallel) {
            this.runParallel(tasks);
        } else {
            this.runSequence(tasks);
        }
    }

    private void runOne(AbstractDataServiceProcedureTask task) {
        if (log.isInfoEnabled()) {
            log.info("Running one task (#active=" + this.getThreadPool().getActiveCount() + ", queueSize=" + this.getThreadPool().getQueue().size() + ") : " + task.toString());
        }
        try {
            Future<Void> f = this.getThreadPool().submit(task);
            f.get(this.taskTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Execution failed: task=" + task, e);
            }
            throw new ClientException("Execution failed: " + task, e);
        }
    }

    private void runParallel(ArrayList<AbstractDataServiceProcedureTask> tasks) {
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Running " + tasks.size() + " tasks in parallel (#active=" + this.getThreadPool().getActiveCount() + ", queueSize=" + this.getThreadPool().getQueue().size() + ") : " + tasks.get(0).toString());
        }
        int nfailed = 0;
        LinkedList<Throwable> causes = new LinkedList<Throwable>();
        try {
            List futures = this.getThreadPool().invokeAll(tasks, this.taskTimeout, TimeUnit.MILLISECONDS);
            Iterator itr = futures.iterator();
            int i = 0;
            while (itr.hasNext()) {
                Future f = itr.next();
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    AbstractDataServiceProcedureTask task = tasks.get(i);
                    log.error("Execution failed: task=" + task, e);
                    if (task.causes != null) {
                        causes.addAll(task.causes);
                    } else {
                        causes.add(e);
                    }
                    ++nfailed;
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted: " + e);
        }
        if (nfailed > 0) {
            throw new ClientException("Execution failed: ntasks=" + tasks.size() + ", nfailed=" + nfailed, causes);
        }
        if (log.isInfoEnabled()) {
            log.info("Ran " + tasks.size() + " tasks in parallel: elapsed=" + (System.currentTimeMillis() - begin));
        }
    }

    private void runSequence(ArrayList<AbstractDataServiceProcedureTask> tasks) {
        if (log.isInfoEnabled()) {
            log.info("Running " + tasks.size() + " tasks in sequence (#active=" + this.getThreadPool().getActiveCount() + ", queueSize=" + this.getThreadPool().getQueue().size() + ") : " + tasks.get(0).toString());
        }
        for (AbstractDataServiceProcedureTask task : tasks) {
            try {
                Future<Void> f = this.getThreadPool().submit(task);
                f.get(this.taskTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (log.isInfoEnabled()) {
                    log.info("Execution failed: task=" + task, e);
                }
                throw new ClientException("Execution failed: " + task, e, task.causes);
            }
        }
    }

    private void runInCallersThread(ArrayList<AbstractDataServiceProcedureTask> tasks) {
        int ntasks = tasks.size();
        if (this.WARN && ntasks > 1) {
            log.warn("Running " + ntasks + " tasks in caller's thread: recursionDepth=" + this.getRecursionDepth().get() + "(#active=" + this.getThreadPool().getActiveCount() + ", queueSize=" + this.getThreadPool().getQueue().size() + ") : " + tasks.get(0).toString());
        }
        for (AbstractDataServiceProcedureTask task : tasks) {
            try {
                task.call();
            }
            catch (Exception e) {
                throw new ClientException("Execution failed: recursionDepth=" + this.getRecursionDepth() + ", task=" + task, e, task.causes);
            }
        }
    }
}

