/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.DelegateTuple;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ResultSet;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.proc.AbstractKeyRangeIndexProcedure;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.service.DataService;
import com.bigdata.service.IDataService;
import com.bigdata.service.ndx.DataServiceTupleIterator;
import com.bigdata.service.ndx.IScaleOutClientIndex;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.IFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class PartitionedTupleIterator<E>
implements ITupleIterator<E> {
    private static final transient Logger log = Logger.getLogger(PartitionedTupleIterator.class);
    private final IScaleOutClientIndex ndx;
    private Iterator<PartitionLocator> locatorItr;
    private final long ts;
    private final boolean isReadConsistentTx;
    private final byte[] fromKey;
    private final byte[] toKey;
    private final int capacity;
    private final int flags;
    private final IFilter filter;
    private final boolean reverseScan;
    private byte[] currentFromKey;
    private byte[] currentToKey;
    private PartitionLocator locator = null;
    private PartitionLocator lastStaleLocator = null;
    private int nparts = 0;
    private long nvisited = 0L;
    private DataServiceTupleIterator<E> src;
    private boolean exhausted = false;

    public int getPartitionCount() {
        return this.nparts;
    }

    public long getVisitedCount() {
        return this.nvisited;
    }

    public PartitionedTupleIterator(IScaleOutClientIndex ndx, long ts, boolean isReadConsistentTx, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        this.ts = ts;
        this.isReadConsistentTx = isReadConsistentTx;
        this.currentFromKey = fromKey;
        this.fromKey = fromKey;
        this.currentToKey = toKey;
        this.toKey = toKey;
        this.capacity = capacity;
        this.flags = flags;
        this.filter = filter;
        this.reverseScan = (flags & 0x40) != 0;
        this.locatorItr = ndx.locatorScan(ts, fromKey, toKey, this.reverseScan);
    }

    protected void finalize() {
        this.close();
    }

    private synchronized void close() {
        if (this.exhausted) {
            return;
        }
        this.exhausted = true;
        if (this.isReadConsistentTx) {
            try {
                this.ndx.getFederation().getTransactionService().abort(this.ts);
            }
            catch (IOException e) {
                log.error("Could not abort transaction: tx=" + this.ts, e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted) {
            return false;
        }
        if (this.locator == null && !this.nextPartition()) {
            return false;
        }
        assert (this.src != null);
        try {
            if (this.src.hasNext()) {
                return true;
            }
        }
        catch (RuntimeException ex) {
            StaleLocatorException cause = (StaleLocatorException)InnerCause.getInnerCause(ex, StaleLocatorException.class);
            if (cause != null) {
                if (this.lastStaleLocator != null && this.lastStaleLocator.getPartitionId() == this.locator.getPartitionId()) {
                    throw new RuntimeException("Missing index partition on data service? " + this.locator, ex);
                }
                this.ndx.staleLocator(this.ts, this.locator, cause);
                this.lastStaleLocator = this.locator;
                this.locator = null;
                this.locatorItr = this.ndx.locatorScan(this.ts, this.currentFromKey, this.currentToKey, this.reverseScan);
                return this.hasNext();
            }
            throw ex;
        }
        if (this.nextPartition()) {
            return this.hasNext();
        }
        this.close();
        return false;
    }

    private boolean nextPartition() {
        assert (!this.exhausted);
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        if (!this.locatorItr.hasNext()) {
            if (log.isInfoEnabled()) {
                log.info("No more locators");
            }
            return false;
        }
        this.locator = this.locatorItr.next();
        if (log.isInfoEnabled()) {
            log.info("locator=" + this.locator);
        }
        this.rangeQuery();
        assert (this.src != null);
        return true;
    }

    private void rangeQuery() {
        assert (!this.exhausted);
        assert (this.locator != null);
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        try {
            byte[] _fromKey = AbstractKeyRangeIndexProcedure.constrainFromKey(this.currentFromKey, this.locator);
            byte[] _toKey = AbstractKeyRangeIndexProcedure.constrainToKey(this.currentToKey, this.locator);
            int partitionId = this.locator.getPartitionId();
            if (log.isInfoEnabled()) {
                log.info("name=" + this.ndx.getName() + ", tx=" + this.ts + ", reverseScan=" + this.reverseScan + ", partition=" + partitionId + ", fromKey=" + BytesUtil.toString(_fromKey) + ", toKey=" + BytesUtil.toString(_toKey));
            }
            IDataService dataService = this.ndx.getDataService(this.locator);
            this.src = new DataServiceTupleIterator<E>(this.ndx, dataService, DataService.getIndexPartitionName(this.ndx.getName(), partitionId), this.ts, _fromKey, _toKey, this.capacity, this.flags, this.filter){

                @Override
                protected ResultSet getResultSet(long timestamp, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
                    ResultSet tmp = super.getResultSet(timestamp, fromKey, toKey, capacity, flags, filter);
                    if (INFO) {
                        log.info("Got chunk: ntuples=" + tmp.getNumTuples() + ", exhausted=" + tmp.isExhausted() + ", lastKey=" + BytesUtil.toString(tmp.getLastKey()));
                    }
                    if (PartitionedTupleIterator.this.reverseScan) {
                        PartitionedTupleIterator.access$102(PartitionedTupleIterator.this, tmp.getLastKey());
                        if (INFO) {
                            log.info("New exclusive upper bound: " + BytesUtil.toString(PartitionedTupleIterator.this.currentToKey));
                        }
                    } else {
                        PartitionedTupleIterator.access$202(PartitionedTupleIterator.this, tmp.getLastKey());
                        if (INFO) {
                            log.info("New inclusive lower bound: " + BytesUtil.toString(PartitionedTupleIterator.this.currentFromKey));
                        }
                    }
                    return tmp;
                }
            };
            ++this.nparts;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ITuple<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.nvisited;
        final long nvisited = this.nvisited;
        Object sourceTuple = this.src.next();
        return new DelegateTuple<E>((ITuple)sourceTuple){

            @Override
            public long getVisitCount() {
                return nvisited;
            }

            @Override
            public String toString() {
                return super.toString() + " : partition=" + ((PartitionedTupleIterator)PartitionedTupleIterator.this).src.name;
            }
        };
    }

    @Override
    public void remove() {
        if (this.src == null) {
            throw new IllegalStateException();
        }
        this.src.remove();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ flags=" + Tuple.flagString(this.flags));
        sb.append(", timestamp=" + this.ts);
        sb.append(", isReadConsistentTx=" + this.isReadConsistentTx);
        sb.append(", capacity=" + this.capacity);
        sb.append(", fromKey=" + (this.fromKey == null ? "n/a" : BytesUtil.toString(this.fromKey)));
        sb.append(", toKey=" + (this.toKey == null ? "n/a" : BytesUtil.toString(this.toKey)));
        sb.append(", filter=" + this.filter);
        sb.append(", #visited=" + this.nvisited);
        sb.append(", exhausted=" + this.exhausted);
        sb.append(", locator=" + this.locator);
        sb.append(", lastStaleLocator=" + this.lastStaleLocator);
        sb.append(", src=" + (this.src == null ? "N/A" : this.src.getClass()));
        sb.append("}");
        return sb.toString();
    }

    static /* synthetic */ byte[] access$102(PartitionedTupleIterator x0, byte[] x1) {
        x0.currentToKey = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$202(PartitionedTupleIterator x0, byte[] x1) {
        x0.currentFromKey = x1;
        return x1;
    }
}

