/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx;

import com.bigdata.btree.AbstractChunkedTupleIterator;
import com.bigdata.btree.ResultSet;
import com.bigdata.btree.proc.BatchRemove;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.IBlock;
import com.bigdata.service.IDataService;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.IFilter;
import java.io.IOException;
import java.util.Iterator;

public class RawDataServiceTupleIterator<E>
extends AbstractChunkedTupleIterator<E> {
    public static final transient String ERR_NO_KEYS = "Keys not requested";
    public static final transient String ERR_NO_VALS = "Values not requested";
    protected final IDataService dataService;
    public final String name;
    private final long timestamp;
    private final boolean readConsistent;

    public RawDataServiceTupleIterator(IDataService dataService, String name, long timestamp, boolean readConsistent, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        super(fromKey, toKey, capacity, flags, filter);
        if (dataService == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.dataService = dataService;
        this.name = name;
        this.timestamp = timestamp;
        this.readConsistent = readConsistent;
    }

    @Override
    protected ResultSet getResultSet(long timestamp, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        if (INFO) {
            log.info("name=" + this.name + ", fromKey=" + BytesUtil.toString(fromKey) + ", toKey=" + BytesUtil.toString(toKey) + ", dataService=" + this.dataService);
        }
        try {
            return this.dataService.rangeIterator(timestamp, this.name, fromKey, toKey, capacity, flags, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void deleteBehind(int n, Iterator<byte[]> itr) {
        byte[][] keys = new byte[n][];
        int i = 0;
        while (itr.hasNext()) {
            keys[i] = itr.next();
        }
        try {
            this.dataService.submit(this.timestamp, this.name, BatchRemove.BatchRemoveConstructor.RETURN_MUTATION_COUNT.newInstance(0, n, keys, null)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void deleteLast(byte[] key) {
        try {
            this.dataService.submit(this.timestamp, this.name, BatchRemove.BatchRemoveConstructor.RETURN_MUTATION_COUNT.newInstance(0, 1, new byte[][]{key}, null)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IBlock readBlock(int sourceIndex, long addr) {
        IResourceMetadata resource = this.rset.getSources()[sourceIndex];
        try {
            return this.dataService.readBlock(resource, addr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    protected final boolean getReadConsistent() {
        return this.readConsistent;
    }
}

