/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.service.master.IAsynchronousClientTask;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetMasterStats;
import com.bigdata.service.ndx.pipeline.AbstractPendingSetMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractSubtask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractPendingSetSubtask<HS extends AbstractSubtaskStats, M extends AbstractPendingSetMasterTask<? extends AbstractPendingSetMasterStats<L, HS>, E, ? extends AbstractPendingSetSubtask, L>, E, L>
extends AbstractSubtask<HS, M, E, L> {
    protected final IAsynchronousClientTask<?, E> clientTask;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition pendingSetEmpty = this.lock.newCondition();

    public AbstractPendingSetSubtask(M master, L locator, IAsynchronousClientTask<?, E> clientTask, BlockingBuffer<E[]> buffer) {
        super(master, locator, buffer);
        if (clientTask == null) {
            throw new IllegalArgumentException();
        }
        this.clientTask = clientTask;
    }

    protected abstract Set<E> getPendingSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingSetSize() {
        this.lock.lock();
        try {
            int n = this.getPendingSet().size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected final void cancelRemoteTask(boolean mayInterruptIfRunning) throws InterruptedException {
        try {
            this.clientTask.getFuture().cancel(mayInterruptIfRunning);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void awaitPending() throws InterruptedException {
        try {
            this.clientTask.close();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(this.toString(), ex);
        }
        this.lock.lockInterruptibly();
        try {
            if (!this.getPendingSet().isEmpty()) {
                this.pendingSetEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean addPending(E e) {
        this.lock.lock();
        try {
            boolean bl = this.getPendingSet().add(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removePending(E e) {
        this.lock.lock();
        try {
            boolean ret = this.getPendingSet().remove(e);
            if (this.getPendingSet().isEmpty()) {
                this.pendingSetEmpty.signal();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleChunk(E[] chunk) throws ExecutionException, InterruptedException, IOException {
        assert (chunk != null);
        assert (chunk.length > 0);
        int chunkSize = chunk.length;
        long beginNanos = System.nanoTime();
        try {
            for (E e : chunk) {
                ((AbstractPendingSetMasterTask)this.master).addPending(e, this, this.locator);
            }
            try {
                this.clientTask.accept(chunk);
            }
            catch (Throwable t) {
                ((AbstractPendingSetMasterTask)this.master).halt(t);
                throw new RuntimeException(t);
            }
            if (log.isDebugEnabled()) {
                log.debug(this.stats);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            long elapsedNanos = System.nanoTime() - beginNanos;
            Object object = this.stats;
            synchronized (object) {
                this.stats.chunksOut.incrementAndGet();
                this.stats.elementsOut.addAndGet(chunkSize);
                this.stats.elapsedChunkWritingNanos += elapsedNanos;
            }
            object = (AbstractPendingSetMasterStats)((AbstractPendingSetMasterTask)this.master).stats;
            synchronized (object) {
                ((AbstractPendingSetMasterStats)((AbstractPendingSetMasterTask)this.master).stats).chunksOut.incrementAndGet();
                ((AbstractPendingSetMasterStats)((AbstractPendingSetMasterTask)this.master).stats).elementsOut.addAndGet(chunkSize);
                ((AbstractPendingSetMasterStats)((AbstractPendingSetMasterTask)this.master).stats).elapsedSinkChunkWritingNanos += elapsedNanos;
            }
        }
    }

    @Override
    protected void notifyClientOfRedirect(L locator, Throwable cause) {
        throw new UnsupportedOperationException();
    }
}

