/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.ndx.pipeline.AbstractMasterStats;
import com.bigdata.service.ndx.pipeline.AbstractMasterTask;
import com.bigdata.service.ndx.pipeline.AbstractSubtask;
import com.bigdata.service.ndx.pipeline.AbstractSubtaskStats;
import com.bigdata.service.ndx.pipeline.IndexPartitionWriteStats;
import com.bigdata.service.ndx.pipeline.SubtaskOp;
import com.bigdata.util.concurrent.MovingAverageTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class AbstractRunnableMasterStats<L, HS extends AbstractSubtaskStats>
extends AbstractMasterStats<L, HS> {
    public final AtomicLong duplicateCount = new AtomicLong();
    public final AtomicLong handledChunkCount = new AtomicLong();
    public long elapsedSplitChunkNanos = 0L;
    public long elapsedHandleChunkNanos = 0L;
    protected final StatisticsTask statisticsTask = this.newStatisticsTask();
    protected static final double scalingFactor = 1.0 / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);

    public AbstractRunnableMasterStats(AbstractFederation<?> fed) {
        fed.addScheduledTask(this.statisticsTask, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected StatisticsTask newStatisticsTask() {
        return new StatisticsTask();
    }

    @Override
    public CounterSet getCounterSet() {
        CounterSet t = super.getCounterSet();
        t.addCounter("duplicateCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.duplicateCount.get());
            }
        });
        t.addCounter("handledChunkCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.handledChunkCount.get());
            }
        });
        t.addCounter("elapsedSplitChunkNanos", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.elapsedSplitChunkNanos);
            }
        });
        t.addCounter("elapsedHandleChunkNanos", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.elapsedHandleChunkNanos);
            }
        });
        t.addCounter("averageElementsOnMasterQueues", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageElementsOnMasterQueues.getMovingAverage());
            }
        });
        t.addCounter("averageHandleChunkMillis", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageHandleChunkNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("averageSplitChunkMillis", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSplitChunkNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("averageSinkOfferMillis", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSinkOfferNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("averageTransferChunkSize", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageTransferChunkSize.getMovingAverage());
            }
        });
        t.addCounter("averageMillisPerWait", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSinkChunkWaitingNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("averageMaximumMillisPerWait", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageMaximumSinkChunkWaitingNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("averageMillisPerWrite", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSinkChunkWritingNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("averageMaximumMillisPerWrite", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageMaximumSinkChunkWritingNanos.getMovingAverage() * scalingFactor);
            }
        });
        t.addCounter("consumerProducerRatio", new Instrument<Double>(){

            @Override
            protected void sample() {
                double consumerRate = AbstractRunnableMasterStats.this.statisticsTask.averageSinkChunkWritingNanos.getMovingAverage();
                double producerRate = AbstractRunnableMasterStats.this.statisticsTask.averageSinkChunkWaitingNanos.getMovingAverage();
                double rateRatio = producerRate == 0.0 ? 0.0 : consumerRate / producerRate;
                this.setValue(rateRatio);
            }
        });
        t.addCounter("averageElementsPerWrite", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSinkWriteChunkSize.getMovingAverage());
            }
        });
        t.addCounter("averageMasterQueueSize", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageMasterQueueSize.getMovingAverage());
            }
        });
        t.addCounter("averageMasterRedirectQueueSize", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageMasterRedirectQueueSize.getMovingAverage());
            }
        });
        t.addCounter("averageSinkQueueSize", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSinkQueueSize.getMovingAverage());
            }
        });
        t.addCounter("averageSinkQueueSizeStdev", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageSinkQueueSizeStdev.getMovingAverage());
            }
        });
        t.addCounter("averageMaximumSinkQueueSize", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageMaximumSinkQueueSize.getMovingAverage());
            }
        });
        t.addCounter("averageElementsOnSinkQueues", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(AbstractRunnableMasterStats.this.statisticsTask.averageElementsOnSinkQueues.getMovingAverage());
            }
        });
        t.addCounter("slowSinks", new Instrument<String>(){

            @Override
            public void sample() {
                int N = 10;
                int M2 = 3;
                final TreeSet sinks = new TreeSet();
                SubtaskOp op = new SubtaskOp(){

                    public void call(AbstractSubtask subtask) {
                        int queueSize = subtask.buffer.size();
                        if (queueSize >= 3) {
                            sinks.add(new SinkQueueSize(subtask, queueSize));
                        }
                    }
                };
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    try {
                        master.mapOperationOverSubtasks(op);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    catch (ExecutionException ex) {
                        log.error(this, ex);
                        break;
                    }
                }
                int n = 0;
                StringBuilder sb = new StringBuilder();
                for (SinkQueueSize t : sinks) {
                    if (n >= 10) break;
                    sb.append("{queueSize=" + t.queueSize + ", sink=" + t.sink + "} ");
                    ++n;
                }
                this.setValue(sb.toString());
            }
        });
        return t;
    }

    @Override
    public String toString() {
        return super.toString() + "{duplicateCount=" + this.duplicateCount + "}";
    }

    @Override
    protected HS newSubtaskStats(L locator) {
        return (HS)new IndexPartitionWriteStats();
    }

    private static class SinkQueueSize
    implements Comparable<SinkQueueSize> {
        final AbstractSubtask sink;
        final int queueSize;

        public SinkQueueSize(AbstractSubtask sink, int queueSize) {
            this.sink = sink;
            this.queueSize = queueSize;
        }

        @Override
        public int compareTo(SinkQueueSize o) {
            if (this.queueSize < o.queueSize) {
                return 1;
            }
            if (this.queueSize > o.queueSize) {
                return -1;
            }
            return 0;
        }
    }

    protected class StatisticsTask
    implements Runnable {
        protected final transient Logger log = Logger.getLogger(StatisticsTask.class);
        private final MovingAverageTask averageElementsOnMasterQueues = new MovingAverageTask("averageElementsOnMasterQueues", (Callable<? extends Number>)new Callable<Long>(){

            @Override
            public Long call() {
                long n = 0L;
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    n += master.buffer.getElementsOnQueueCount();
                }
                return n;
            }
        });
        private final MovingAverageTask averageHandleChunkNanos = new MovingAverageTask("averageHandleChunkNanos", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.handledChunkCount.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elapsedHandleChunkNanos / (double)t;
            }
        });
        private final MovingAverageTask averageSplitChunkNanos = new MovingAverageTask("averageSplitChunkNanos", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.handledChunkCount.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elapsedSplitChunkNanos / (double)t;
            }
        });
        private final MovingAverageTask averageSinkOfferNanos = new MovingAverageTask("averageSinkOfferNanos", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.chunksTransferred.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elapsedSinkOfferNanos / (double)t;
            }
        });
        private final MovingAverageTask averageTransferChunkSize = new MovingAverageTask("averageTransferChunkSize", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.chunksTransferred.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elementsTransferred.get() / (double)t;
            }
        });
        private final MovingAverageTask averageSinkChunkWaitingNanos = new MovingAverageTask("averageSinkChunkWaitingNanos", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.chunksOut.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elapsedSinkChunkWaitingNanos / (double)t;
            }
        });
        private final MovingAverageTask averageMaximumSinkChunkWaitingNanos = new MovingAverageTask("averageMaximumSinkChunkWaitingNanos", (Callable<? extends Number>)new Callable<Long>(){

            @Override
            public Long call() {
                final AtomicLong max = new AtomicLong(0L);
                SubtaskOp op = new SubtaskOp(){

                    public void call(AbstractSubtask subtask) {
                        long nanos = ((AbstractSubtaskStats)subtask.stats).elapsedChunkWaitingNanos;
                        if (nanos > max.get()) {
                            max.set(nanos);
                        }
                    }
                };
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    try {
                        master.mapOperationOverSubtasks(op);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    catch (ExecutionException ex) {
                        StatisticsTask.this.log.error(this, ex);
                        break;
                    }
                }
                return max.get();
            }
        });
        private final MovingAverageTask averageSinkChunkWritingNanos = new MovingAverageTask("averageSinkChunkWritingNanos", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.chunksOut.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elapsedSinkChunkWritingNanos / (double)t;
            }
        });
        private final MovingAverageTask averageMaximumSinkChunkWritingNanos = new MovingAverageTask("averageMaximumChunkWritingNanos", (Callable<? extends Number>)new Callable<Long>(){

            @Override
            public Long call() {
                final AtomicLong max = new AtomicLong(0L);
                SubtaskOp op = new SubtaskOp(){

                    public void call(AbstractSubtask subtask) {
                        long nanos = ((AbstractSubtaskStats)subtask.stats).elapsedChunkWritingNanos;
                        if (nanos > max.get()) {
                            max.set(nanos);
                        }
                    }
                };
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    try {
                        master.mapOperationOverSubtasks(op);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    catch (ExecutionException ex) {
                        StatisticsTask.this.log.error(this, ex);
                        break;
                    }
                }
                return max.get();
            }
        });
        private final MovingAverageTask averageSinkWriteChunkSize = new MovingAverageTask("averageSinkWriteChunkSize", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                long t = AbstractRunnableMasterStats.this.chunksOut.get();
                return t == 0L ? 0.0 : (double)AbstractRunnableMasterStats.this.elementsOut.get() / (double)t;
            }
        });
        private final MovingAverageTask averageMasterQueueSize = new MovingAverageTask("averageMasterQueueSize", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                int n = 0;
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    n += master.buffer.size();
                }
                return n;
            }
        });
        private final MovingAverageTask averageMasterRedirectQueueSize = new MovingAverageTask("averageMasterRedirectQueueSize", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                int n = 0;
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    n += master.getRedirectQueueSize();
                }
                return n;
            }
        });
        private final MovingAverageTask averageSinkQueueSize = new MovingAverageTask("averageSinkQueueSize", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                final AtomicLong n = new AtomicLong(0L);
                final AtomicInteger m = new AtomicInteger(0);
                SubtaskOp op = new SubtaskOp(){

                    public void call(AbstractSubtask subtask) {
                        int queueSize = subtask.buffer.size();
                        n.addAndGet(queueSize);
                        m.incrementAndGet();
                    }
                };
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    try {
                        master.mapOperationOverSubtasks(op);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    catch (ExecutionException ex) {
                        StatisticsTask.this.log.error(this, ex);
                        break;
                    }
                }
                if (m.get() == 0) {
                    return 0.0;
                }
                return (double)n.get() / (double)m.get();
            }
        });
        private final MovingAverageTask averageSinkQueueSizeStdev = new MovingAverageTask("averageSinkQueueSizeStdev", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() {
                final LinkedList queueSizes = new LinkedList();
                final AtomicLong n = new AtomicLong(0L);
                final AtomicInteger m = new AtomicInteger(0);
                SubtaskOp op = new SubtaskOp(){

                    public void call(AbstractSubtask subtask) {
                        int queueSize = subtask.buffer.size();
                        queueSizes.add(queueSize);
                        n.addAndGet(queueSize);
                        m.incrementAndGet();
                    }
                };
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    try {
                        master.mapOperationOverSubtasks(op);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    catch (ExecutionException ex) {
                        StatisticsTask.this.log.error(this, ex);
                        break;
                    }
                }
                if (m.get() == 0) {
                    return 0.0;
                }
                double mean = (double)n.get() / (double)m.get();
                double sse = 0.0;
                for (Integer queueSize : queueSizes) {
                    double delta = mean - queueSize.doubleValue();
                    sse += delta * delta;
                }
                double stdev = Math.sqrt(sse / (double)m.get());
                return stdev;
            }
        });
        private final MovingAverageTask averageMaximumSinkQueueSize = new MovingAverageTask("averageMaximumSinkQueueSize", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                final AtomicInteger max = new AtomicInteger(0);
                SubtaskOp op = new SubtaskOp(){

                    public void call(AbstractSubtask subtask) {
                        int queueSize = subtask.buffer.size();
                        if (queueSize > max.get()) {
                            max.set(queueSize);
                        }
                    }
                };
                Iterator itr = AbstractRunnableMasterStats.this.masters.iterator();
                while (itr.hasNext()) {
                    AbstractMasterTask master = (AbstractMasterTask)itr.next().get();
                    if (master == null) continue;
                    try {
                        master.mapOperationOverSubtasks(op);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    catch (ExecutionException ex) {
                        StatisticsTask.this.log.error(this, ex);
                        break;
                    }
                }
                return max.get();
            }
        });
        private final MovingAverageTask averageElementsOnSinkQueues = new MovingAverageTask("averageElementsOnSinkQueues", (Callable<? extends Number>)new Callable<Long>(){

            @Override
            public Long call() {
                return AbstractRunnableMasterStats.this.elementsOnSinkQueues.get();
            }
        });

        protected StatisticsTask() {
        }

        @Override
        public void run() {
            this.averageElementsOnMasterQueues.run();
            this.averageHandleChunkNanos.run();
            this.averageSplitChunkNanos.run();
            this.averageSinkOfferNanos.run();
            this.averageTransferChunkSize.run();
            this.averageSinkChunkWaitingNanos.run();
            this.averageMaximumSinkChunkWaitingNanos.run();
            this.averageSinkChunkWritingNanos.run();
            this.averageMaximumSinkChunkWritingNanos.run();
            this.averageSinkWriteChunkSize.run();
            this.averageMasterQueueSize.run();
            this.averageMasterRedirectQueueSize.run();
            this.averageSinkQueueSize.run();
            this.averageSinkQueueSizeStdev.run();
            this.averageMaximumSinkQueueSize.run();
            this.averageElementsOnSinkQueues.run();
        }
    }
}

