/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.proc.IAsyncResultHandler;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.mdi.IPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.service.DataService;
import com.bigdata.service.IDataService;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.pipeline.AbstractSubtask;
import com.bigdata.service.ndx.pipeline.IndexAsyncWriteStats;
import com.bigdata.service.ndx.pipeline.IndexPartitionWriteStats;
import com.bigdata.service.ndx.pipeline.IndexWriteTask;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class IndexPartitionWriteTask<H extends IndexAsyncWriteStats<L, HS>, O, E extends KVO<O>, L extends PartitionLocator, S extends IndexPartitionWriteTask, HS extends IndexPartitionWriteStats, M extends IndexWriteTask<H, O, E, S, L, HS, T, R, A>, T extends IKeyArrayIndexProcedure, R, A>
extends AbstractSubtask<HS, M, E, L> {
    public final IDataService dataService;
    public final long timestamp;
    public final int partitionId;
    private final String indexPartitionName;

    @Override
    public String toString() {
        return this.getClass().getName() + "{indexPartition=" + this.indexPartitionName + ", open=" + this.buffer.isOpen() + "}";
    }

    public IndexPartitionWriteTask(M master, L locator, IDataService dataService, BlockingBuffer<E[]> buffer) {
        super(master, locator, buffer);
        if (dataService == null) {
            throw new IllegalArgumentException();
        }
        this.dataService = dataService;
        this.timestamp = ((IndexWriteTask)master).ndx.getTimestamp();
        this.partitionId = ((PartitionLocator)locator).getPartitionId();
        this.indexPartitionName = DataService.getIndexPartitionName(((IndexWriteTask)master).ndx.getName(), this.partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleChunk(E[] sourceChunk) throws ExecutionException, InterruptedException, IOException {
        long beginNanos;
        int chunkSize;
        int duplicateCount;
        Object[] chunk;
        block36: {
            if (((IndexWriteTask)this.master).duplicateRemover == null) {
                chunk = sourceChunk;
                duplicateCount = 0;
            } else {
                chunk = ((IndexWriteTask)this.master).duplicateRemover.filter((KVO<O>[])sourceChunk);
                duplicateCount = sourceChunk.length - chunk.length;
                if (duplicateCount > 0 && log.isDebugEnabled()) {
                    log.debug("Filtered out " + duplicateCount + " duplicates from " + chunk.length + " elements");
                }
            }
            if (chunk.length == 0) {
                return false;
            }
            chunkSize = chunk.length;
            boolean sendValues = ((IndexWriteTask)this.master).ctor.sendValues();
            byte[][] keys = new byte[chunkSize][];
            Object vals = sendValues ? new byte[chunkSize][] : (Object)null;
            for (int i = 0; i < chunkSize; ++i) {
                keys[i] = ((KVO)chunk[i]).key;
                if (!sendValues) continue;
                vals[i] = ((KVO)chunk[i]).val;
            }
            beginNanos = System.nanoTime();
            Object proc = ((IndexWriteTask)this.master).ctor.newInstance(((IndexWriteTask)this.master).ndx, 0, chunkSize, (byte[][])keys, (byte[][])vals);
            Object result = null;
            boolean done = false;
            int maxtries = 3;
            for (int ntries = 0; ntries < 3; ++ntries) {
                try {
                    result = this.dataService.submit(this.timestamp, this.indexPartitionName, proc).get();
                    done = true;
                    break;
                }
                catch (ExecutionException ex) {
                    StaleLocatorException cause = (StaleLocatorException)InnerCause.getInnerCause(ex, StaleLocatorException.class);
                    if (cause != null) {
                        this.handleRedirect((KVO[])chunk, cause);
                        boolean bl = true;
                        long elapsedNanos = System.nanoTime() - beginNanos;
                        Object object = (IndexPartitionWriteStats)this.stats;
                        synchronized (object) {
                            ((IndexPartitionWriteStats)this.stats).chunksOut.incrementAndGet();
                            ((IndexPartitionWriteStats)this.stats).elementsOut.addAndGet(chunkSize);
                            ((IndexPartitionWriteStats)this.stats).elapsedChunkWritingNanos += elapsedNanos;
                        }
                        object = (IndexAsyncWriteStats)((IndexWriteTask)this.master).stats;
                        synchronized (object) {
                            ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).chunksOut.incrementAndGet();
                            ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).elementsOut.addAndGet(chunkSize);
                            ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).duplicateCount.addAndGet(duplicateCount);
                            ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).elapsedSinkChunkWritingNanos += elapsedNanos;
                        }
                        return bl;
                    }
                    if (ntries + 1 >= 3) {
                        log.fatal(this, ex);
                        throw ex;
                    }
                    log.error("Will retry (" + ntries + " of " + 3 + "): " + this, ex);
                    continue;
                }
            }
            if (!done) {
                throw new AssertionError();
            }
            if (((IndexWriteTask)this.master).resultHandler == null) break block36;
            ((IndexWriteTask)this.master).resultHandler.aggregate(result, new Split((IPartitionMetadata)this.locator, 0, chunkSize));
            if (((IndexWriteTask)this.master).resultHandler instanceof IAsyncResultHandler) {
                ((IAsyncResultHandler)((IndexWriteTask)this.master).resultHandler).aggregateAsync((KVO[])chunk, result, new Split((IPartitionMetadata)this.locator, 0, chunkSize));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(this.stats);
        }
        for (int i = 0; i < chunkSize; ++i) {
            ((KVO)chunk[i]).done();
        }
        boolean bl = false;
        return bl;
        finally {
            long elapsedNanos = System.nanoTime() - beginNanos;
            Object object = (IndexPartitionWriteStats)this.stats;
            synchronized (object) {
                ((IndexPartitionWriteStats)this.stats).chunksOut.incrementAndGet();
                ((IndexPartitionWriteStats)this.stats).elementsOut.addAndGet(chunkSize);
                ((IndexPartitionWriteStats)this.stats).elapsedChunkWritingNanos += elapsedNanos;
            }
            object = (IndexAsyncWriteStats)((IndexWriteTask)this.master).stats;
            synchronized (object) {
                ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).chunksOut.incrementAndGet();
                ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).elementsOut.addAndGet(chunkSize);
                ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).duplicateCount.addAndGet(duplicateCount);
                ((IndexAsyncWriteStats)((IndexWriteTask)this.master).stats).elapsedSinkChunkWritingNanos += elapsedNanos;
            }
        }
    }

    @Override
    protected void notifyClientOfRedirect(L locator, Throwable cause) {
        ((IndexWriteTask)this.master).ndx.staleLocator(((IndexWriteTask)this.master).ndx.getTimestamp(), (PartitionLocator)locator, (StaleLocatorException)cause);
    }
}

