/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.proxy;

import com.bigdata.service.proxy.IRemoteChunk;
import com.bigdata.service.proxy.IRemoteChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class WrappedRemoteChunkedIterator<E>
implements IChunkedOrderedIterator<E> {
    protected static final Logger log = Logger.getLogger(WrappedRemoteChunkedIterator.class);
    private IRemoteChunkedIterator<E> src;
    private long nchunks = 0L;
    private boolean exhausted;
    private E[] a;
    private int index;
    private IKeyOrder<E> keyOrder;

    public WrappedRemoteChunkedIterator(IRemoteChunkedIterator<E> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        try {
            this.readChunkFromSource();
        }
        catch (IOException ex) {
            try {
                src.close();
            }
            catch (IOException ex2) {
                log.warn("Could not close source", ex2);
            }
            this.src = null;
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    private void readChunkFromSource() throws IOException {
        IRemoteChunk<E> chunk = this.src.nextChunk();
        if (this.nchunks == 0L) {
            this.keyOrder = chunk.getKeyOrder();
        }
        this.exhausted = chunk.isExhausted();
        this.a = chunk.getChunk();
        this.index = 0;
        if (log.isInfoEnabled()) {
            log.info("nchunks=" + this.nchunks + ", sourceExhausted=" + this.exhausted + ", elementsInChunk=" + this.a.length);
        }
        ++this.nchunks;
    }

    private void readChunkFromSource2() {
        try {
            this.readChunkFromSource();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.exhausted && (this.a == null || this.index >= this.a.length)) {
            return false;
        }
        if (this.index >= this.a.length) {
            this.readChunkFromSource2();
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = this.a[this.index++];
        if (log.isDebugEnabled()) {
            log.debug("e=" + e + ", index=" + this.index + ", chunkSize=" + this.a.length);
        }
        return e;
    }

    @Override
    public E[] nextChunk() {
        Object[] ret;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.index == 0) {
            ret = this.a;
            if (log.isDebugEnabled()) {
                log.debug("returning entire chunk: chunkSize=" + this.a.length);
            }
        } else {
            int remaining = this.a.length - this.index;
            ret = (Object[])Array.newInstance(this.a.getClass().getComponentType(), remaining);
            System.arraycopy(this.a, this.index, ret, 0, remaining);
            if (log.isDebugEnabled()) {
                log.debug("returning remainder of chunk: remaining=" + remaining);
            }
        }
        this.index = this.a.length;
        return ret;
    }

    @Override
    public E[] nextChunk(IKeyOrder<E> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.getKeyOrder())) {
            Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
        }
        return chunk;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.src != null) {
            if (log.isInfoEnabled()) {
                log.info("Closing remote iterator");
            }
            try {
                this.src.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.src = null;
            }
        }
    }
}

