/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.filter.LookaheadTupleFilter;
import com.bigdata.btree.filter.TupleTransformer;
import com.bigdata.sparse.INameFilter;
import com.bigdata.sparse.IRowStoreConstants;
import com.bigdata.sparse.KeyDecoder;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.sparse.TPS;
import com.bigdata.sparse.TPSTupleSerializer;
import com.bigdata.sparse.ValueType;
import com.bigdata.util.BytesUtil;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class AtomicRowFilter
extends TupleTransformer<TPS.TPV, TPS>
implements IRowStoreConstants {
    private static final long serialVersionUID = 4410286292657970569L;
    protected static final transient Logger log = Logger.getLogger(AtomicRowFilter.class);
    private final Schema schema;
    private final long fromTime;
    private final long toTime;
    private final INameFilter nameFilter;

    protected AtomicRowFilter(Schema schema, long fromTime, long toTime, INameFilter nameFilter) {
        super(TPSTupleSerializer.newInstance());
        SparseRowStore.assertArgs(schema, Boolean.TRUE, fromTime, toTime);
        this.schema = schema;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.nameFilter = nameFilter;
    }

    @Override
    protected ITupleIterator<TPS> newTransformer(LookaheadTupleFilter.ILookaheadTupleIterator<TPS.TPV> src, Object context) {
        return new Transformerator(src, context);
    }

    private class Transformerator<E extends TPS.TPV, F extends TPS>
    implements ITupleIterator<F> {
        private transient long nvisited = 0L;
        private transient TPS current = null;
        private transient byte[] prefix;
        private final LookaheadTupleFilter.ILookaheadTupleIterator<E> src;
        private final Object context;

        public Transformerator(LookaheadTupleFilter.ILookaheadTupleIterator<E> src, Object context) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.src = src;
            this.context = context;
        }

        @Override
        public ITuple<F> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.current != null);
            TPS tps = this.current;
            this.current = null;
            AbstractTuple tuple = new AbstractTuple<F>(3){

                @Override
                public int getSourceIndex() {
                    return 0;
                }

                @Override
                public ITupleSerializer getTupleSerializer() {
                    return AtomicRowFilter.this.tupleSer;
                }
            };
            tuple.copyTuple(this.prefix, AtomicRowFilter.this.tupleSer.serializeVal(tps));
            ++this.nvisited;
            return tuple;
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            TPS tps = new TPS(AtomicRowFilter.this.schema, 0L);
            this.prefix = null;
            while (this.src.hasNext()) {
                ITuple tuple = this.src.next();
                byte[] prefix = new KeyDecoder(tuple.getKey()).getPrefix();
                if (this.prefix == null) {
                    this.prefix = prefix;
                } else if (!BytesUtil.bytesEqual(this.prefix, prefix)) {
                    this.src.pushback();
                    break;
                }
                this.handleTuple(tps, tuple);
            }
            if (this.prefix != null) {
                this.current = AtomicRowFilter.this.toTime == Long.MIN_VALUE ? tps.currentRow() : tps;
                return true;
            }
            return false;
        }

        private void handleTuple(TPS tps, ITuple tuple) {
            assert (tps != null);
            assert (tuple != null);
            byte[] key = tuple.getKey();
            KeyDecoder keyDecoder = new KeyDecoder(key);
            String col = keyDecoder.getColumnName();
            if (AtomicRowFilter.this.nameFilter != null && !AtomicRowFilter.this.nameFilter.accept(col)) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping property: name=" + col + " (filtered)");
                }
                return;
            }
            long columnValueTimestamp = keyDecoder.getTimestamp();
            if (columnValueTimestamp < AtomicRowFilter.this.fromTime) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring earlier revision: col=" + col + ", fromTime=" + AtomicRowFilter.this.fromTime + ", timestamp=" + columnValueTimestamp);
                }
                return;
            }
            if (AtomicRowFilter.this.toTime != Long.MIN_VALUE && columnValueTimestamp >= AtomicRowFilter.this.toTime) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring later revision: col=" + col + ", toTime=" + AtomicRowFilter.this.toTime + ", timestamp=" + columnValueTimestamp);
                }
                return;
            }
            byte[] val = tuple.getValue();
            Object v = ValueType.decode(val);
            tps.set(col, columnValueTimestamp, v);
            if (log.isInfoEnabled()) {
                log.info("Accept: name=" + col + ", timestamp=" + columnValueTimestamp + ", value=" + v + ", key=" + BytesUtil.toString(key));
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

