/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.ISimpleSplitHandler;
import com.bigdata.btree.IndexSegment;
import com.bigdata.sparse.KeyDecoder;
import com.bigdata.util.BytesUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public class LogicalRowSplitHandler
implements ISimpleSplitHandler,
Externalizable {
    private static final long serialVersionUID = 9180840621078374197L;
    protected static final transient Logger log = Logger.getLogger(LogicalRowSplitHandler.class);
    public static final transient ISimpleSplitHandler INSTANCE = new LogicalRowSplitHandler();

    @Override
    public byte[] getSeparatorKey(IndexSegment seg, int fromIndex, int toIndex, int splitAt) {
        byte[] a = seg.keyAt(splitAt);
        int alen = new KeyDecoder(a).getPrefixLength();
        for (int i = splitAt + 1; i < toIndex; ++i) {
            byte[] b = seg.keyAt(i);
            int blen = new KeyDecoder(b).getPrefixLength();
            int cmp = BytesUtil.compareBytesWithLenAndOffset(0, alen, a, 0, blen, b);
            assert (cmp <= 0);
            if (cmp >= 0) continue;
            byte[] prefix = new byte[blen];
            System.arraycopy(b, 0, prefix, 0, blen);
            if (log.isInfoEnabled()) {
                log.info("Found: prefix=" + BytesUtil.toString(prefix) + ", splitAt=" + splitAt + ", i=" + i);
            }
            return prefix;
        }
        log.warn("No successor: splitAt=" + splitAt);
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

