/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.sparse.INameFilter;
import com.bigdata.sparse.IRowStoreConstants;
import com.bigdata.sparse.ITPS;
import com.bigdata.sparse.ITPV;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.ValueType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TPS
implements ITPS,
Externalizable,
IRowStoreConstants {
    protected static final transient Logger log = Logger.getLogger(TPS.class);
    private static final long serialVersionUID = -2757723215430771209L;
    private Schema schema;
    private long writeTime;
    private TreeMap<TP, ITPV> tuples;
    private boolean preconditionOk = true;
    private static final short VERSION0 = 0;

    public boolean isPreconditionOk() {
        return this.preconditionOk;
    }

    void setPreconditionOk(boolean flag) {
        this.preconditionOk = flag;
    }

    public TPS() {
    }

    public TPS(Schema schema, long timestamp) {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        this.schema = schema;
        this.tuples = new TreeMap();
        this.writeTime = timestamp;
    }

    @Override
    public Object getPrimaryKey() {
        return this.get(this.schema.getPrimaryKeyName()).getValue();
    }

    @Override
    public long getWriteTimestamp() {
        if (this.writeTime == 0L) {
            throw new IllegalStateException();
        }
        return this.writeTime;
    }

    @Override
    public int size() {
        return this.tuples.size();
    }

    public void set(String name, long timestamp, Object value) {
        this.tuples.put(new TP(name, timestamp), new TPV(this.schema, name, timestamp, value));
    }

    @Override
    public ITPV get(String name, long timestamp) {
        TPV tpv = (TPV)this.tuples.get(new TP(name, timestamp));
        if (tpv != null) {
            if (log.isInfoEnabled()) {
                log.info("Exact timestamp match: name=" + name + (timestamp == Long.MAX_VALUE ? ", current value" : ", timestamp=" + timestamp));
            }
            return tpv;
        }
        Iterator<ITPV> itr = this.tuples.values().iterator();
        TPV last = null;
        while (itr.hasNext()) {
            TPV tmp = (TPV)itr.next();
            if (!tmp.name.equals(name)) continue;
            last = tmp;
        }
        if (last == null) {
            if (log.isInfoEnabled()) {
                log.info("No match: name=" + name);
            }
            return new TPV(this.schema, name, 0L, null);
        }
        if (log.isInfoEnabled()) {
            log.info("Most recent match: name=" + name + ", value=" + last.value + ", timestamp=" + last.timestamp);
        }
        return last;
    }

    @Override
    public ITPV get(String name) {
        return this.get(name, Long.MAX_VALUE);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Iterator<ITPV> iterator() {
        return Collections.unmodifiableCollection(this.tuples.values()).iterator();
    }

    public TPS currentRow() {
        return this.currentRow(null);
    }

    public TPS currentRow(INameFilter filter) {
        if (log.isDebugEnabled()) {
            log.debug("filter=" + filter + ", preFilter=" + this);
        }
        LinkedHashMap<String, TPV> m = new LinkedHashMap<String, TPV>();
        for (TPV tPV : this.tuples.values()) {
            TPV old;
            if (filter != null && !filter.accept(tPV.name)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("rejecting on filter: " + tPV);
                continue;
            }
            if (tPV.value == null) {
                old = (TPV)m.remove(tPV.name);
                if (!log.isDebugEnabled() || old == null) continue;
                log.debug("removed binding: " + old);
                continue;
            }
            old = m.put(tPV.name, tPV);
            if (!log.isDebugEnabled() || old == null) continue;
            log.debug("overwrote: \nold=" + old + "\nnew=" + tPV);
        }
        TPS tPS = new TPS(this.schema, this.writeTime);
        for (Map.Entry entry : m.entrySet()) {
            String name = (String)entry.getKey();
            TPV tpv = (TPV)entry.getValue();
            tPS.tuples.put(new TP(name, tpv.timestamp), tpv);
        }
        if (log.isDebugEnabled()) {
            log.debug("postFilter: " + tPS);
        }
        return tPS;
    }

    public TPS filter(long fromTime, long toTime) {
        return this.filter(fromTime, toTime, null);
    }

    public TPS filter(INameFilter filter) {
        return this.filter(1L, Long.MAX_VALUE, filter);
    }

    public TPS filter(long fromTime, long toTime, INameFilter filter) {
        if (fromTime < 1L) {
            throw new IllegalArgumentException();
        }
        if (toTime <= fromTime) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug("fromTime=" + fromTime + ", toTime=" + toTime + ", filter=" + filter + ", preFilter=" + this);
        }
        TPS tps = new TPS(this.schema, this.writeTime);
        for (Map.Entry<TP, ITPV> entry : this.tuples.entrySet()) {
            TP tp = entry.getKey();
            if (tp.timestamp < fromTime || tp.timestamp >= toTime) {
                if (!log.isDebugEnabled()) continue;
                log.debug("rejecting on timestamp: " + tp);
                continue;
            }
            if (filter != null && !filter.accept(tp.name)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("rejecting on filter: " + tp);
                continue;
            }
            tps.tuples.put(tp, entry.getValue());
        }
        if (log.isDebugEnabled()) {
            log.debug("postFilter: " + tps);
        }
        return tps;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.asMap(Long.MAX_VALUE);
    }

    @Override
    public Map<String, Object> asMap(long timestamp) {
        return this.asMap(timestamp, null);
    }

    public LinkedHashMap<String, Object> asMap(long timestamp, INameFilter filter) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (TPV tPV : this.tuples.values()) {
            if (tPV.timestamp > timestamp || filter != null && !filter.accept(tPV.name)) continue;
            if (tPV.value == null) {
                m.remove(tPV.name);
                continue;
            }
            m.put(tPV.name, tPV.value);
        }
        return m;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(0);
        out.writeObject(this.schema);
        out.writeLong(this.writeTime);
        out.writeBoolean(this.preconditionOk);
        out.writeInt(this.tuples.size());
        for (TPV tPV : this.tuples.values()) {
            out.writeUTF(tPV.name);
            out.writeLong(tPV.timestamp);
            byte[] val = ValueType.encode(tPV.value);
            out.writeInt(val == null ? 0 : val.length + 1);
            if (val == null) continue;
            out.write(val);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version != 0) {
            throw new IOException("Unknown version=" + version);
        }
        this.schema = (Schema)in.readObject();
        this.writeTime = in.readLong();
        this.tuples = new TreeMap();
        this.preconditionOk = in.readBoolean();
        int n = in.readInt();
        if (log.isDebugEnabled()) {
            log.info("n=" + n + ", schema=" + this.schema);
        }
        for (int i = 0; i < n; ++i) {
            byte[] val;
            String name = in.readUTF();
            long timestamp = in.readLong();
            int nbytes = in.readInt() - 1;
            byte[] byArray = val = nbytes == -1 ? null : new byte[nbytes];
            if (val != null) {
                in.readFully(val);
            }
            Object value = ValueType.decode(val);
            TPV tpv = new TPV(this.schema, name, timestamp, value);
            this.tuples.put(new TP(name, timestamp), tpv);
            if (!log.isDebugEnabled()) continue;
            log.info("tuple: name=" + name + ", timestamp=" + timestamp + ", value=" + value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TPS{schema=" + this.schema + ", timestamp=" + this.writeTime + ", primaryKey=" + this.getPrimaryKey() + ", tuples={");
        boolean n = false;
        for (ITPV tpv : this.tuples.values()) {
            sb.append("\n");
            sb.append(tpv.toString());
        }
        sb.append("}}");
        return sb.toString();
    }

    protected static class TPVComparator
    implements Comparator<TPV> {
        public static final transient Comparator<TPV> INSTANCE = new TPVComparator();

        private TPVComparator() {
        }

        @Override
        public int compare(TPV o1, TPV o2) {
            if (o1 == o2) {
                return 0;
            }
            int ret = o1.getSchema().getName().compareTo(o2.getSchema().getName());
            if (ret == 0 && (ret = o1.name.compareTo(o2.name)) == 0) {
                ret = o1.timestamp < o2.timestamp ? -1 : (o1.timestamp > o2.timestamp ? 1 : 0);
            }
            return ret;
        }
    }

    public static class TPV
    implements ITPV {
        private Schema schema;
        private String name;
        private long timestamp;
        private Object value;

        public TPV(Schema schema, String name, long timestamp, Object value) {
            if (schema == null) {
                throw new IllegalArgumentException();
            }
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.schema = schema;
            this.name = name;
            this.timestamp = timestamp;
            this.value = value;
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "TPV{name=" + this.name + ",timestamp=" + this.timestamp + ",value=" + this.value + "}";
        }
    }

    protected static class TP
    implements Comparable<TP> {
        public final String name;
        public final long timestamp;

        public TP(String name, long timestamp) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(TP o) {
            int ret;
            if (this == o) {
                return 0;
            }
            int n = this.timestamp < o.timestamp ? -1 : (ret = this.timestamp > o.timestamp ? 1 : 0);
            if (ret == 0) {
                ret = this.name.compareTo(o.name);
            }
            return ret;
        }

        public String toString() {
            return "TP{name=" + this.name + ", timestamp=" + this.timestamp + "}";
        }
    }
}

