/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.stream;

import com.bigdata.Banner;
import com.bigdata.BigdataStatics;
import com.bigdata.bop.solutions.SolutionSetStream;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IDirtyListener;
import com.bigdata.btree.IReadWriteLockManager;
import com.bigdata.btree.IndexInconsistentError;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.ReadWriteLockManager;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.LongPacker;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rawstore.IRawStore;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.log4j.Logger;

public abstract class Stream
implements ICheckpointProtocol {
    private static final Logger log = Logger.getLogger(Stream.class);
    protected static final String ERROR_CLOSED = "Closed";
    protected static final String ERROR_READ_ONLY = "Read-only";
    protected static final String ERROR_ERROR_STATE = "Index is in error state";
    private final IRawStore store;
    private final boolean readOnly;
    private final IReadWriteLockManager lockManager;
    protected volatile Throwable error;
    protected final AtomicBoolean open = new AtomicBoolean(false);
    protected long entryCount;
    protected long rootAddr;
    private long recordVersion;
    private Checkpoint checkpoint = null;
    private volatile StreamIndexMetadata metadata2;
    protected StreamIndexMetadata metadata;
    private volatile long lastCommitTime = 0L;
    private IDirtyListener listener;

    @Override
    public IRawStore getStore() {
        return this.store;
    }

    public Stream(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        Banner.banner();
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (metadata == null) {
            throw new IllegalArgumentException();
        }
        if (checkpoint == null) {
            throw new IllegalArgumentException();
        }
        if (store != null && checkpoint.getMetadataAddr() != metadata.getMetadataAddr()) {
            throw new IllegalArgumentException();
        }
        this.metadata = (StreamIndexMetadata)metadata;
        this.store = store instanceof AbstractJournal ? ((AbstractJournal)store).getBufferStrategy() : store;
        this.readOnly = readOnly;
        this.setCheckpoint(checkpoint);
        this.lockManager = ReadWriteLockManager.getLockManager(this);
    }

    protected void setCheckpoint(Checkpoint checkpoint) {
        this.checkpoint = checkpoint;
        this.entryCount = checkpoint.getEntryCount();
        this.recordVersion = checkpoint.getRecordVersion();
        this.rootAddr = checkpoint.getRootAddr();
    }

    public static SolutionSetStream create(IRawStore store, StreamIndexMetadata metadata) {
        if (metadata.getIndexType() != IndexTypeEnum.Stream) {
            throw new IllegalStateException("Wrong index type: " + (Object)((Object)metadata.getIndexType()));
        }
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (metadata.getMetadataAddr() != 0L) {
            throw new IllegalStateException("Metadata record already in use");
        }
        metadata.write(store);
        Checkpoint firstCheckpoint = metadata.firstCheckpoint();
        firstCheckpoint.write(store);
        return Stream.load(store, firstCheckpoint.getCheckpointAddr(), false);
    }

    public static SolutionSetStream load(IRawStore store, long addrCheckpoint, boolean readOnly) {
        StreamIndexMetadata metadata;
        Checkpoint checkpoint;
        if (store == null) {
            throw new IllegalArgumentException();
        }
        try {
            checkpoint = Checkpoint.load(store, addrCheckpoint);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not load Checkpoint: store=" + store + ", addrCheckpoint=" + store.toString(addrCheckpoint), t);
        }
        if (checkpoint.getIndexType() != IndexTypeEnum.Stream) {
            throw new RuntimeException("Wrong checkpoint type: " + checkpoint);
        }
        try {
            metadata = (StreamIndexMetadata)IndexMetadata.read(store, checkpoint.getMetadataAddr());
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not read IndexMetadata: store=" + store + ", checkpoint=" + checkpoint, t);
        }
        if (log.isInfoEnabled()) {
            String name = metadata.getName();
            log.info((name == null ? "" : "name=" + name + ", ") + "readCheckpoint=" + checkpoint);
        }
        try {
            Class<?> cl = Class.forName(metadata.getStreamClassName());
            Constructor<?> ctor = cl.getConstructor(IRawStore.class, Checkpoint.class, IndexMetadata.class, Boolean.TYPE);
            SolutionSetStream solutions = (SolutionSetStream)ctor.newInstance(store, checkpoint, metadata, readOnly);
            solutions.reopen();
            return solutions;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void clear() {
        this.assertNotReadOnly();
        if (this.rootAddr != 0L) {
            this.recycle(this.rootAddr);
            this.rootAddr = 0L;
            this.fireDirtyEvent();
        }
    }

    protected OutputStream wrapOutputStream(OutputStream out) {
        CompressionEnum compressionType = this.metadata.getStreamCompressionType();
        switch (compressionType) {
            case None: {
                return out;
            }
            case Zip: {
                return new DeflaterOutputStream(out);
            }
        }
        throw new UnsupportedOperationException("CompressionEnum=" + (Object)((Object)compressionType));
    }

    protected InputStream wrapInputStream(InputStream in) {
        CompressionEnum compressionType = this.metadata.getStreamCompressionType();
        switch (compressionType) {
            case None: {
                return in;
            }
            case Zip: {
                return new InflaterInputStream(in);
            }
        }
        throw new UnsupportedOperationException("CompressionEnum=" + (Object)((Object)compressionType));
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected final void assertNotReadOnly() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(ERROR_READ_ONLY);
        }
        if (this.error != null) {
            throw new IndexInconsistentError(ERROR_ERROR_STATE, this.error);
        }
    }

    protected final void assertNotTransient() {
    }

    @Override
    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("index UUID", new OneShotInstrument<String>(this.getIndexMetadata().getIndexUUID().toString()));
        counterSet.addCounter("class", new OneShotInstrument<String>(this.getClass().getName()));
        return counterSet;
    }

    @Override
    public long handleCommit(long commitTime) {
        return this.writeCheckpoint2().getCheckpointAddr();
    }

    @Override
    public void invalidate(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (this.error == null) {
            this.error = t;
        }
    }

    @Override
    public long getRecordVersion() {
        return this.recordVersion;
    }

    @Override
    public final Checkpoint getCheckpoint() {
        if (this.checkpoint == null) {
            throw new AssertionError();
        }
        return this.checkpoint;
    }

    @Override
    public final long writeCheckpoint() {
        return this.writeCheckpoint2().getCheckpointAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Checkpoint writeCheckpoint2() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        Lock lock = this.writeLock();
        lock.lock();
        try {
            if (this.needsCheckpoint()) {
                Checkpoint checkpoint = this._writeCheckpoint2();
                return checkpoint;
            }
            Checkpoint checkpoint = this.checkpoint;
            return checkpoint;
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean needsCheckpoint() {
        if (this.checkpoint.getCheckpointAddr() == 0L) {
            return true;
        }
        if (this.metadata.getMetadataAddr() == 0L) {
            return true;
        }
        if (this.metadata.getMetadataAddr() != this.checkpoint.getMetadataAddr()) {
            return true;
        }
        return this.checkpoint.getRootAddr() != this.rootAddr;
    }

    protected void flush() {
    }

    private final Checkpoint _writeCheckpoint2() {
        this.assertNotTransient();
        this.assertNotReadOnly();
        this.flush();
        if (this.metadata.getMetadataAddr() == 0L) {
            long addr;
            if (this.checkpoint != null && (addr = this.checkpoint.getMetadataAddr()) != 0L) {
                this.store.delete(addr);
            }
            this.metadata.write(this.store);
        }
        if (this.checkpoint != null) {
            this.recycle(this.checkpoint.getCheckpointAddr());
        }
        this.checkpoint = this.newCheckpoint();
        this.checkpoint.write(this.store);
        if (BigdataStatics.debug || log.isInfoEnabled()) {
            String msg = "name=" + this.metadata.getName() + "} : " + this.checkpoint;
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
            if (log.isInfoEnabled()) {
                log.info(msg);
            }
        }
        return this.checkpoint;
    }

    private final Checkpoint newCheckpoint() {
        try {
            Class<?> cl = Class.forName(this.metadata.getCheckpointClassName());
            Constructor<?> ctor = cl.getConstructor(Stream.class);
            Checkpoint checkpoint = (Checkpoint)ctor.newInstance(this);
            return checkpoint;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected int recycle(long addr) {
        if (addr == 0L) {
            return 0;
        }
        int nbytes = this.store.getByteCount(addr);
        this.store.delete(addr);
        return nbytes;
    }

    @Override
    public final long getRootAddr() {
        return this.rootAddr;
    }

    @Override
    public final long getMetadataAddr() {
        return this.metadata.getMetadataAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamIndexMetadata getIndexMetadata() {
        if (this.isReadOnly()) {
            if (this.metadata2 == null) {
                Stream stream = this;
                synchronized (stream) {
                    if (this.metadata2 == null) {
                        this.metadata2 = this.metadata.clone();
                    }
                }
            }
            return this.metadata2;
        }
        return this.metadata;
    }

    @Override
    public final IDirtyListener getDirtyListener() {
        return this.listener;
    }

    @Override
    public final long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public final void setLastCommitTime(long lastCommitTime) {
        if (lastCommitTime == 0L) {
            throw new IllegalArgumentException();
        }
        if (this.lastCommitTime == lastCommitTime) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("old=" + this.lastCommitTime + ", new=" + lastCommitTime);
        }
        this.lastCommitTime = lastCommitTime;
    }

    @Override
    public final void setDirtyListener(IDirtyListener listener) {
        this.assertNotReadOnly();
        this.listener = listener;
    }

    protected final void fireDirtyEvent() {
        this.assertNotReadOnly();
        IDirtyListener l = this.listener;
        if (l == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        l.dirtyEvent(this);
    }

    @Override
    public long rangeCount() {
        return this.entryCount;
    }

    @Override
    public void removeAll() {
        this.clear();
    }

    @Override
    public void close() {
        this.open.set(false);
    }

    @Override
    public void reopen() {
        this.open.set(true);
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public abstract ICloseableIterator<?> scan();

    public abstract void write(ICloseableIterator<?> var1);

    @Override
    public final Lock readLock() {
        return this.lockManager.readLock();
    }

    @Override
    public final Lock writeLock() {
        return this.lockManager.writeLock();
    }

    @Override
    public final int getReadLockCount() {
        return this.lockManager.getReadLockCount();
    }

    public static class StreamIndexMetadata
    extends IndexMetadata {
        private static final long serialVersionUID = -1L;
        private String streamClassName;
        private CompressionEnum streamCompressionType;
        private static final transient int VERSION0 = 0;
        private static final transient int CURRENT_VERSION = 0;

        public final String getStreamClassName() {
            return this.streamClassName;
        }

        public void setStreamClassName(String className) {
            if (className == null) {
                throw new IllegalArgumentException();
            }
            this.streamClassName = className;
        }

        public CompressionEnum getStreamCompressionType() {
            return this.streamCompressionType;
        }

        public void setStreamCompressionType(CompressionEnum e) {
            this.streamCompressionType = e;
        }

        public StreamIndexMetadata() {
        }

        public StreamIndexMetadata(UUID indexUUID) {
            this(null, indexUUID);
        }

        public StreamIndexMetadata(String name, UUID indexUUID) {
            this(null, System.getProperties(), name, indexUUID);
        }

        public StreamIndexMetadata(IIndexManager indexManager, Properties properties, String namespace, UUID indexUUID) {
            super(indexManager, properties, namespace, indexUUID, IndexTypeEnum.Stream);
            this.streamClassName = this.getProperty(indexManager, properties, namespace, Options.STREAM_CLASS_NAME, Stream.class.getName()).intern();
            this.streamCompressionType = CompressionEnum.valueOf(this.getProperty(indexManager, properties, namespace, Options.STREAM_COMPRESSION_TYPE, CompressionEnum.Zip.name()));
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", streamClassName=" + this.streamClassName);
            sb.append(", streamCompressionType=" + (Object)((Object)this.streamCompressionType));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            LongPacker.unpackInt(in);
            this.streamClassName = in.readUTF();
            this.streamCompressionType = CompressionEnum.values()[LongPacker.unpackInt(in)];
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            boolean version = false;
            LongPacker.packLong(out, 0L);
            out.writeUTF(this.streamClassName);
            LongPacker.packLong(out, (long)this.streamCompressionType.ordinal());
        }

        @Override
        public StreamIndexMetadata clone() {
            return (StreamIndexMetadata)super.clone();
        }

        public static interface Options
        extends IndexMetadata.Options {
            public static final String STREAM_CLASS_NAME = Stream.class.getName() + ".className";
            public static final String STREAM_COMPRESSION_TYPE = Stream.class.getName() + ".compressionType";
        }
    }

    public static enum CompressionEnum {
        None,
        Zip;

    }
}

