/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkConverter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ChunkedConvertingIterator<E, F>
implements IChunkedOrderedIterator<F> {
    private static final Logger log = Logger.getLogger(ChunkedConvertingIterator.class);
    private final IChunkedOrderedIterator<E> src;
    private final IChunkConverter<E, F> converter;
    private final IKeyOrder<F> keyOrder;
    private F[] converted = null;
    private int pos = 0;

    public ChunkedConvertingIterator(IChunkedOrderedIterator<E> src, IChunkConverter<E, F> converter) {
        this(src, converter, src.getKeyOrder());
    }

    public ChunkedConvertingIterator(IChunkedOrderedIterator<E> src, IChunkConverter<E, F> converter, IKeyOrder<F> keyOrder) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.converter = converter;
        this.keyOrder = keyOrder;
    }

    protected F[] convert(IChunkedOrderedIterator<E> src) {
        Object[] tmp = this.converter.convert(src);
        if (tmp == null) {
            throw new AssertionError((Object)("Converter returns null: " + this.converter.getClass()));
        }
        if (log.isInfoEnabled()) {
            log.info("Converted: chunkSize=" + tmp.length + " : chunk=" + Arrays.toString(tmp));
        }
        return tmp;
    }

    @Override
    public void close() {
        this.src.close();
    }

    @Override
    public F next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (log.isInfoEnabled()) {
            log.info("returning converted[" + this.pos + "]");
        }
        return this.converted[this.pos++];
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        while ((this.converted == null || this.pos >= this.converted.length) && this.src.hasNext()) {
            this.converted = this.convert(this.src);
            this.pos = 0;
        }
        boolean bl = hasNext = this.converted != null && this.pos < this.converted.length;
        if (log.isInfoEnabled()) {
            log.info(hasNext);
        }
        return hasNext;
    }

    @Override
    public IKeyOrder<F> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public F[] nextChunk() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.pos > 0) {
            int remaining = this.converted.length - this.pos;
            Object[] chunk = (Object[])Array.newInstance(this.converted.getClass().getComponentType(), remaining);
            System.arraycopy(this.converted, this.pos, chunk, 0, remaining);
            this.converted = chunk;
        }
        F[] nextChunk = this.converted;
        this.converted = null;
        this.pos = 0;
        return nextChunk;
    }

    @Override
    public F[] nextChunk(IKeyOrder<F> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        F[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.keyOrder)) {
            Arrays.sort(chunk, keyOrder.getComparator());
        }
        return chunk;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

