/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IFilter;
import com.bigdata.striterator.IKeyOrder;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;

public abstract class ChunkedFilter<I extends IChunkedIterator<E>, E, F>
implements IFilter<I, E, F> {
    private static final long serialVersionUID = 1L;
    protected Object state;
    protected final IKeyOrder<F> keyOrder;

    public ChunkedFilter() {
        this(null, null);
    }

    public ChunkedFilter(Object state) {
        this(state, null);
    }

    public ChunkedFilter(Object state, IKeyOrder<F> keyOrder) {
        this.state = state;
        this.keyOrder = keyOrder;
    }

    @Override
    public IChunkedOrderedIterator<F> filter(I src) {
        return new ChunkedFilteringIterator(src, this);
    }

    protected abstract F[] filterChunk(E[] var1);

    private static class ChunkedFilteringIterator<I extends IChunkedIterator<E>, E, F>
    implements IChunkedOrderedIterator<F> {
        private final I src;
        private final ChunkedFilter<I, E, F> filter;
        private F[] chunk = null;
        private int index = 0;

        public ChunkedFilteringIterator(I src, ChunkedFilter<I, E, F> filter) {
            this.src = src;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            while ((this.chunk == null || this.index == this.chunk.length) && this.src.hasNext()) {
                this.chunk = this.filter.filterChunk(this.src.nextChunk());
                this.index = 0;
            }
            return this.chunk != null && this.index != this.chunk.length;
        }

        @Override
        public F next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.chunk[this.index++];
        }

        @Override
        public F[] nextChunk() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.index == 0) {
                F[] tmp = this.chunk;
                this.chunk = null;
                return tmp;
            }
            int nremaining = this.chunk.length - this.index;
            Object[] tmp = (Object[])Array.newInstance(this.chunk.getClass().getComponentType(), nremaining);
            for (int i = 0; i < nremaining; ++i) {
                tmp[i] = this.chunk[this.index + i];
            }
            this.chunk = null;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.src.close();
        }

        @Override
        public IKeyOrder<F> getKeyOrder() {
            return this.filter.keyOrder;
        }

        @Override
        public F[] nextChunk(IKeyOrder<F> keyOrder) {
            if (keyOrder == null) {
                throw new IllegalArgumentException();
            }
            F[] chunk = this.nextChunk();
            if (!keyOrder.equals(this.getKeyOrder())) {
                Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
            }
            return chunk;
        }
    }
}

