/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PushbackIterator<E>
implements Iterator<E>,
ICloseableIterator<E> {
    private final Iterator<E> src;
    private E current;
    private E buffer;

    public PushbackIterator(Iterator<E> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null || this.src.hasNext();
    }

    @Override
    public E next() {
        E tmp;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.buffer != null) {
            tmp = this.buffer;
            this.buffer = null;
        } else {
            tmp = this.src.next();
        }
        this.current = tmp;
        return tmp;
    }

    public void pushback() {
        if (this.buffer != null) {
            throw new IllegalStateException();
        }
        this.buffer = this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.src instanceof ICloseableIterator) {
            ((ICloseableIterator)this.src).close();
        }
    }
}

