/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BytesUtil {
    private static final transient Logger log = Logger.getLogger(BytesUtil.class);
    public static final byte[] EMPTY = new byte[0];
    public static final byte[][] EMPTY2 = new byte[0][];
    static boolean linked = false;
    public static final int minlen = 100;
    private static transient String NULL;
    private static final int[] masks32;
    static final int[] bitmasks;
    private static final char[] bits;
    private static final Pattern PATTERN_BYTE_COUNT;
    private static final char[] HEX_CHAR_TABLE;

    private static native int _compareBytes(int var0, byte[] var1, int var2, byte[] var3);

    private static native int _compareBytesWithOffsetAndLen(int var0, int var1, byte[] var2, int var3, int var4, byte[] var5);

    public static boolean loadJNILibrary() {
        if (!linked) {
            try {
                System.loadLibrary("BytesUtil");
                if (log.isInfoEnabled()) {
                    log.info("BytesUtil JNI linked");
                }
                linked = true;
            }
            catch (UnsatisfiedLinkError ex) {
                log.warn("BytesUtil JNI NOT linked: " + ex);
                linked = false;
            }
        }
        return linked;
    }

    public static final boolean bytesEqual(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        int alen = a.length;
        int blen = b.length;
        if (alen != blen) {
            return false;
        }
        for (int i = alen - 1; i >= 0; --i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static final int compareBytes(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int alen = a.length;
        int blen = b.length;
        if (linked && alen > 100 && blen > 100) {
            return BytesUtil._compareBytes(alen, a, blen, b);
        }
        for (int i = 0; i < alen && i < blen; ++i) {
            int ret = (a[i] & 0xFF) - (b[i] & 0xFF);
            if (ret == 0) continue;
            return ret;
        }
        return alen - blen;
    }

    public static final int compareBytesWithLenAndOffset(int aoff, int alen, byte[] a, int boff, int blen, byte[] b) {
        if (linked && alen > 100 && blen > 100) {
            return BytesUtil._compareBytesWithOffsetAndLen(aoff, alen, a, boff, blen, b);
        }
        int alimit = aoff + alen;
        int blimit = boff + blen;
        int i = aoff;
        for (int j = boff; i < alimit && j < blimit; ++i, ++j) {
            int ret = (a[i] & 0xFF) - (b[j] & 0xFF);
            if (ret == 0) continue;
            return ret;
        }
        return alen - blen;
    }

    public static final int getPrefixLength(byte[] a, byte[] b) {
        int i;
        int alen = a.length;
        int blen = b.length;
        for (i = 0; i < alen && i < blen && a[i] == b[i]; ++i) {
        }
        return i;
    }

    public static final byte[] getPrefix(byte[] a, byte[] b) {
        int len = BytesUtil.getPrefixLength(a, b);
        byte[] prefix = new byte[len];
        System.arraycopy(a, 0, prefix, 0, len);
        return prefix;
    }

    public static final byte[] successor(byte[] key) {
        int keylen = key.length;
        byte[] tmp = new byte[keylen + 1];
        System.arraycopy(key, 0, tmp, 0, keylen);
        return tmp;
    }

    public static final byte[] getSeparatorKey(byte[] givenKey, byte[] priorKey) {
        if (givenKey == null) {
            throw new IllegalArgumentException();
        }
        if (priorKey == null) {
            throw new IllegalArgumentException();
        }
        if (givenKey == priorKey) {
            throw new IllegalArgumentException();
        }
        int prefixLen = BytesUtil.getPrefixLength(givenKey, priorKey);
        if (prefixLen == givenKey.length - 1) {
            return givenKey;
        }
        byte[] tmp = new byte[prefixLen + 1];
        System.arraycopy(givenKey, 0, tmp, 0, prefixLen + 1);
        return tmp;
    }

    public static final String toString(byte[] key) {
        if (key == null) {
            return NULL;
        }
        return BytesUtil.toString(key, 0, key.length);
    }

    public static final String toString(byte[] key, int off, int len) {
        if (key == null) {
            return NULL;
        }
        StringBuilder sb = new StringBuilder(len * 4 + 2);
        sb.append("[");
        for (int i = off; i < off + len; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Integer.toString(key[i] & 0xFF));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(byte[][] data) {
        StringBuilder sb = new StringBuilder();
        int n = data.length;
        sb.append("data(n=" + n + ")={");
        for (int i = 0; i < n; ++i) {
            byte[] a = data[i];
            sb.append("\n");
            sb.append("data[" + i + "]=");
            sb.append(BytesUtil.toString(a));
            if (i + 1 >= n) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static final int binarySearch(byte[][] keys, int base, int nmem, byte[] key) {
        int low = 0;
        int high = nmem - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int offset = base + mid;
            byte[] midVal = keys[offset];
            int tmp = BytesUtil.compareBytes(midVal, key);
            if (tmp < 0) {
                low = mid + 1;
                continue;
            }
            if (tmp > 0) {
                high = mid - 1;
                continue;
            }
            return offset;
        }
        int offset = base + low;
        return -(offset + 1);
    }

    public static final boolean rangeCheck(byte[] key, byte[] fromKey, byte[] toKey) {
        if (fromKey == null && toKey == null) {
            return true;
        }
        if (fromKey != null && BytesUtil.compareBytes(key, fromKey) < 0) {
            if (log.isDebugEnabled()) {
                log.debug("key=" + BytesUtil.toString(key) + " LT fromKey" + BytesUtil.toString(fromKey));
            }
            return false;
        }
        if (toKey != null && BytesUtil.compareBytes(key, toKey) >= 0) {
            if (log.isDebugEnabled()) {
                log.debug("key=" + BytesUtil.toString(key) + " GTE toKey" + BytesUtil.toString(toKey));
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        BytesUtil.loadJNILibrary();
        if (0 != BytesUtil._compareBytes(3, new byte[]{1, 2, 3}, 3, new byte[]{1, 2, 3})) {
            throw new AssertionError();
        }
        if (0 != BytesUtil._compareBytesWithOffsetAndLen(0, 3, new byte[]{1, 2, 3}, 0, 3, new byte[]{1, 2, 3})) {
            throw new AssertionError();
        }
        System.out.println("JNI library routines Ok.");
    }

    public static final int bitFlagByteLength(int nbits) {
        return nbits / 8 + (nbits % 8 == 0 ? 0 : 1);
    }

    public static final int byteIndexForBit(long bitIndex) {
        return (int)(bitIndex / 8L);
    }

    public static final int withinByteIndexForBit(long bitIndex) {
        return 7 - (int)bitIndex % 8;
    }

    public static final boolean getBit(byte[] buf, long bitIndex) {
        int mask = 1 << BytesUtil.withinByteIndexForBit(bitIndex);
        int off = BytesUtil.byteIndexForBit(bitIndex);
        byte b = buf[off];
        return (b & mask) != 0;
    }

    public static final boolean setBit(byte[] buf, long bitIndex, boolean value) {
        int mask = 1 << BytesUtil.withinByteIndexForBit(bitIndex);
        int off = BytesUtil.byteIndexForBit(bitIndex);
        byte b = buf[off];
        boolean oldValue = (b & mask) != 0;
        b = value ? (byte)(b | mask) : (byte)(b & ~mask);
        buf[off] = b;
        return oldValue;
    }

    public static int getMSBMask(int nbits) {
        if (nbits < 0 || nbits > 32) {
            throw new IllegalArgumentException();
        }
        int limit = 32 - nbits;
        int mask = 0;
        for (int i = 31; i >= limit; --i) {
            int bit = 1 << i;
            mask |= bit;
        }
        return mask;
    }

    public static int maskOffMSB(int h, int nbits) {
        if (nbits < 0 || nbits > 32) {
            throw new IllegalArgumentException();
        }
        int v = h & masks32[nbits];
        int x = v >>> 32 - nbits;
        return x;
    }

    public static int maskOffLSB(int h, int nbits) {
        if (nbits < 0 || nbits > 32) {
            throw new IllegalArgumentException();
        }
        int v = h & ~masks32[32 - nbits];
        return v;
    }

    public static int getBits(byte[] a, int off, int len) {
        if (a == null || off < 0 || len < 0 || len > 32) {
            throw new IllegalArgumentException();
        }
        int maxbits = a.length * 8;
        if (off + len > maxbits) {
            throw new IllegalArgumentException("off: " + off + ", len: " + len + ", a.length: " + a.length);
        }
        if (len == 0) {
            return 0;
        }
        int fromByteOffset = off / 8;
        int lastByte = off + len - 1;
        int toByteOffset = lastByte / 8;
        int nbytes = toByteOffset - fromByteOffset + 1;
        long v = 0L;
        int i = fromByteOffset;
        int j = 1;
        while (i <= toByteOffset) {
            long x = 0xFF & a[i];
            int shift = nbytes - j << 3;
            v |= x << shift;
            ++i;
            ++j;
        }
        int rshift = 7 - lastByte % 8;
        int w = (int)(v >>> rshift);
        return w & ~masks32[32 - len];
    }

    private static long getLongVal(byte b, int s, int l, int t) {
        int lastBit = s + l;
        int shift = 64 - t - l;
        long ret = lastBit < 8 ? (long)(b >>> 8 - lastBit) : (long)b;
        return (ret & (long)bitmasks[l]) << shift;
    }

    private static int getIntVal(byte b, int s, int l, int t) {
        int lastBit = s + l;
        int shift = 64 - t - l;
        int ret = lastBit < 8 ? b >>> 8 - lastBit : b;
        return (ret & bitmasks[l]) << shift;
    }

    public static long altGetBits64(byte[] a, int off, int len) {
        if (a == null || off < 0 || len < 0 || len > 64) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0L;
        }
        if (off + len > a.length * 8) {
            throw new IllegalArgumentException();
        }
        int bi = off / 8;
        int bo = off % 8;
        int br = 8 - bo;
        int lt = 64 - len;
        int lr = len;
        long ret = 0L;
        int t = 0;
        while (t < len) {
            if (br > lr) {
                br = lr;
            }
            ret |= BytesUtil.getLongVal(a[bi], bo, br, lt);
            lr -= br;
            lt += br;
            t += br;
            bo = 0;
            br = 8;
            ++bi;
        }
        return ret;
    }

    public static int altGetBits32(byte[] a, int off, int len) {
        if (a == null || off < 0 || len < 0 || len > 64) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        if (off + len > a.length * 8) {
            throw new IllegalArgumentException();
        }
        int bi = off / 8;
        int bo = off % 8;
        int br = 8 - bo;
        int lt = 32 - len;
        int lr = len;
        int ret = 0;
        int t = 0;
        while (t < len) {
            if (br > lr) {
                br = lr;
            }
            ret |= BytesUtil.getIntVal(a[bi], bo, br, lt);
            lr -= br;
            lt += br;
            t += br;
            bo = 0;
            br = 8;
            ++bi;
        }
        return ret;
    }

    public static long getBits64(byte[] a, int off, int len) {
        long ret = 0L;
        if (len <= 32) {
            ret = 0xFFFFFFFFL & (long)BytesUtil.getBits(a, off, len);
        } else {
            int hilen = len - 32;
            ret = BytesUtil.getBits(a, off, hilen);
            ret <<= 32;
            ret |= 0xFFFFFFFFL & (long)BytesUtil.getBits(a, off + hilen, 32);
        }
        return ret;
    }

    public static int optGetBits(byte[] a, int off, int len) {
        if (len <= 16) {
            return BytesUtil.altGetBits32(a, off, len);
        }
        return BytesUtil.getBits(a, off, len);
    }

    public static int getBits(int a, int off, int len) {
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        if (off + len > 32) {
            throw new IllegalArgumentException();
        }
        int last = off + len - 1;
        int rshift = 31 - last;
        int w = a >>> rshift;
        int mask = masks32[32 - len];
        return w &= (mask ^= 0xFFFFFFFF);
    }

    public static String toBitString(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        char[] chars = new char[b.length << 3];
        int bitIndex = 0;
        for (int i = 0; i < b.length; ++i) {
            byte x = b[i];
            for (int withinByteIndex = 7; withinByteIndex >= 0; --withinByteIndex) {
                int mask = 1 << withinByteIndex;
                boolean bit = (x & mask) != 0;
                chars[bitIndex++] = bits[bit ? 1 : 0];
            }
        }
        return new String(chars);
    }

    public static long getByteCount(String s) {
        long count;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Matcher m = PATTERN_BYTE_COUNT.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException(s);
        }
        String g1 = m.group(1);
        long c = Long.valueOf(g1);
        String g2 = m.group(2);
        if (g2 == null) {
            count = c;
        } else if (g2.equalsIgnoreCase("k") || g2.equalsIgnoreCase("kb")) {
            count = c * 1024L;
        } else if (g2.equalsIgnoreCase("m") || g2.equalsIgnoreCase("mb")) {
            count = c * 0x100000L;
        } else if (g2.equalsIgnoreCase("g") || g2.equalsIgnoreCase("gb")) {
            count = c * 0x40000000L;
        } else {
            throw new AssertionError();
        }
        return count;
    }

    public static byte[] toArray(ByteBuffer b) {
        return BytesUtil.toArray(b, false, null);
    }

    public static byte[] toArray(ByteBuffer b, boolean forceCopy, byte[] dst) {
        byte[] a;
        if (!forceCopy && b.hasArray() && b.arrayOffset() == 0 && b.position() == 0 && (a = b.array()).length == b.limit()) {
            return a;
        }
        ByteBuffer tmp = b.asReadOnlyBuffer();
        int len = tmp.remaining();
        byte[] a2 = dst != null && dst.length >= len ? dst : new byte[len];
        tmp.get(a2, 0, len);
        return a2;
    }

    public static String toHexString(int[] ibuf) {
        byte[] buf = new byte[ibuf.length * 4];
        for (int i = 0; i < ibuf.length; ++i) {
            int v = ibuf[i];
            int sb = i * 4;
            buf[sb] = (byte)(v >>> 24 & 0xFF);
            buf[sb + 1] = (byte)(v >>> 16 & 0xFF);
            buf[sb + 2] = (byte)(v >>> 8 & 0xFF);
            buf[sb + 3] = (byte)(v & 0xFF);
        }
        return BytesUtil.toHexString(buf, buf.length);
    }

    public static String toHexString(byte[] buf) {
        if (buf == null) {
            return "NULL";
        }
        return BytesUtil.toHexString(buf, buf.length);
    }

    public static String toHexString(byte[] buf, int n) {
        if (buf == null) {
            return "NULL";
        }
        n = n < buf.length ? n : buf.length;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int v = buf[i] & 0xFF;
            out.append(HEX_CHAR_TABLE[v >>> 4]);
            out.append(HEX_CHAR_TABLE[v & 0xF]);
        }
        return out.toString();
    }

    public static void printHexString(StringBuilder sb, String hexData) {
        int curs = 0;
        for (int rem = hexData.length(); rem >= 64; rem -= 64) {
            sb.append(String.format("%8d: ", curs));
            sb.append(hexData.substring(curs, curs + 64) + "\n");
            curs += 64;
        }
    }

    public static byte[] getBytes(ByteBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        buf = buf.asReadOnlyBuffer();
        int len = buf.remaining();
        byte[] a = new byte[len];
        buf.get(a);
        return a;
    }

    public static String byteArrToBinaryStr(byte[] zOrderByteArray) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < zOrderByteArray.length * 8; ++i) {
            buf.append(BytesUtil.getBit(zOrderByteArray, i) ? "1" : "0");
        }
        return buf.toString();
    }

    static {
        String val = System.getProperty("com.bigdata.btree.BytesUtil.jni");
        boolean jni = val != null ? Boolean.parseBoolean(val) : false;
        if (jni) {
            BytesUtil.loadJNILibrary();
        }
        NULL = "null";
        masks32 = new int[33];
        for (int i = 0; i < 33; ++i) {
            BytesUtil.masks32[i] = BytesUtil.getMSBMask(i);
        }
        bitmasks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
        bits = new char[]{'0', '1'};
        PATTERN_BYTE_COUNT = Pattern.compile("([0-9]+)(k|kb|m|mb|g|gb)?", 2);
        HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static class UnsignedByteArrayComparator
    implements Comparator<byte[]> {
        public static final transient Comparator<byte[]> INSTANCE = new UnsignedByteArrayComparator();

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return BytesUtil.compareBytes(o1, o2);
        }
    }
}

