/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClassPathUtil {
    private static final Logger log = Logger.getLogger(ClassPathUtil.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final Map<ClassPathUtilRequestConfig, Class<?>> cache = Collections.synchronizedMap(new HashMap());

    public static <T> T classForName(String preferredClassName, Class<T> defaultClass, Class<T> sharedInterface) {
        return ClassPathUtil.classForName(preferredClassName, defaultClass, sharedInterface, ClassPathUtil.class.getClassLoader());
    }

    public static <T> T classForName(String preferredClassName, Class<? extends T> defaultClass, Class<T> sharedClassOrInterface, ClassLoader classLoader) {
        ClassPathUtilRequestConfig requestConfig;
        block10: {
            requestConfig = new ClassPathUtilRequestConfig(preferredClassName, defaultClass, sharedClassOrInterface, classLoader);
            try {
                if (cache.containsKey(requestConfig)) {
                    Class<?> cls = cache.get(requestConfig);
                    return cls == null ? null : (T)cls.newInstance();
                }
                if (defaultClass != null && !sharedClassOrInterface.isAssignableFrom(defaultClass)) {
                    throw new IllegalArgumentException();
                }
                boolean initialize = false;
                Class<?> cls = Class.forName(preferredClassName, false, classLoader);
                if (sharedClassOrInterface.isAssignableFrom(cls)) {
                    if (log.isInfoEnabled()) {
                        log.info("Found " + cls.getCanonicalName());
                    }
                    cache.put(requestConfig, cls);
                    return (T)cls.newInstance();
                }
                log.warn(cls.getCanonicalName() + " does not extend " + sharedClassOrInterface.getCanonicalName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (!DEBUG) break block10;
                log.debug("Not found: " + preferredClassName);
            }
        }
        if (defaultClass == null) {
            cache.put(requestConfig, null);
            return null;
        }
        try {
            if (DEBUG) {
                log.debug("Using defaultClass: " + defaultClass.getCanonicalName());
            }
            cache.put(requestConfig, defaultClass);
            return defaultClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClassPathUtilRequestConfig {
        protected final String preferredClassName;
        protected final Class<?> defaultClass;
        protected final Class<?> sharedClassOrInterface;
        protected final ClassLoader classLoader;

        public ClassPathUtilRequestConfig(String preferredClassName, Class<?> defaultClass, Class<?> sharedClassOrInterface, ClassLoader classLoader) throws IllegalArgumentException {
            if (preferredClassName == null) {
                throw new IllegalArgumentException();
            }
            if (sharedClassOrInterface == null) {
                throw new IllegalArgumentException();
            }
            if (classLoader == null) {
                throw new IllegalArgumentException();
            }
            this.preferredClassName = preferredClassName;
            this.defaultClass = defaultClass;
            this.sharedClassOrInterface = sharedClassOrInterface;
            this.classLoader = classLoader;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 37 * hashCode + this.preferredClassName.hashCode();
            hashCode = 37 * hashCode + this.sharedClassOrInterface.hashCode();
            hashCode = 37 * hashCode + this.classLoader.hashCode();
            if (this.defaultClass != null) {
                hashCode = 37 * hashCode + this.defaultClass.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ClassPathUtilRequestConfig)) {
                return false;
            }
            ClassPathUtilRequestConfig otherAsConfig = (ClassPathUtilRequestConfig)other;
            boolean equals = true;
            equals &= this.preferredClassName.equals(otherAsConfig.preferredClassName);
            equals &= this.sharedClassOrInterface.equals(otherAsConfig.sharedClassOrInterface);
            equals &= this.classLoader.equals(otherAsConfig.classLoader);
            return equals &= this.defaultClass == null ? otherAsConfig.defaultClass == null : this.defaultClass.equals(otherAsConfig.defaultClass);
        }
    }
}

