/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import java.math.BigInteger;
import org.apache.log4j.Logger;

public class HybridTimestampFactory {
    public static final Logger log = Logger.getLogger(HybridTimestampFactory.class);
    private final int counterBits;
    private final int maxCounter;
    private long lastTimestamp;
    private int counter = 0;
    private long sleepCounter = 0L;

    public long getSleepCounter() {
        return this.sleepCounter;
    }

    protected HybridTimestampFactory() {
        this(10);
    }

    public HybridTimestampFactory(int counterBits) {
        if (counterBits < 0 || counterBits > 31) {
            throw new IllegalArgumentException("counterBits must be in [0:31]");
        }
        this.lastTimestamp = 0L;
        this.counterBits = counterBits;
        this.maxCounter = BigInteger.valueOf(2L).pow(counterBits).intValue() - 1;
        log.warn("#counterBits=" + counterBits + ", maxCounter=" + this.maxCounter);
    }

    public long nextTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (timestamp == this.lastTimestamp && (this.counter == this.maxCounter || this.counterBits == 0)) {
            do {
                try {
                    ++this.sleepCounter;
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((timestamp = System.currentTimeMillis()) == this.lastTimestamp);
            this.counter = 0;
            this.lastTimestamp = timestamp;
        } else {
            ++this.counter;
        }
        if (this.counterBits == 0) {
            return timestamp;
        }
        return timestamp << this.counterBits | (long)this.counter;
    }
}

