/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.util.InnerCause;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractHaltableProcess {
    protected static final transient Logger log = Logger.getLogger(AbstractHaltableProcess.class);
    private volatile transient boolean halt = false;
    private final transient AtomicReference<Throwable> firstCause = new AtomicReference<Object>(null);

    public final void halted() {
        if (this.halt) {
            throw new RuntimeException(this.firstCause.get());
        }
    }

    public final <T extends Throwable> T halt(T cause) {
        this.halt = true;
        boolean isFirstCause = this.firstCause.compareAndSet(null, cause);
        if (log.isEnabledFor(Level.WARN)) {
            try {
                if (!(InnerCause.isInnerCause(cause, InterruptedException.class) || InnerCause.isInnerCause(cause, CancellationException.class) || InnerCause.isInnerCause(cause, ClosedByInterruptException.class) || InnerCause.isInnerCause(cause, RejectedExecutionException.class) || InnerCause.isInnerCause(cause, BufferClosedException.class))) {
                    log.warn(this + " : isFirstCause=" + isFirstCause + " : " + cause, cause);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cause;
    }
}

