/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.cache.ConcurrentWeakValueCache;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;

public abstract class CanonicalFactory<KEY, VAL, STATE> {
    private ConcurrentWeakValueCache<KEY, VAL> cache;

    public CanonicalFactory(int queueCapacity) {
        this.cache = new ConcurrentWeakValueCache(queueCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAL getInstance(KEY key, STATE state) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        VAL val = this.cache.get(key);
        if (val != null) {
            return val;
        }
        ConcurrentWeakValueCache<KEY, VAL> concurrentWeakValueCache = this.cache;
        synchronized (concurrentWeakValueCache) {
            val = this.cache.get(key);
            if (val == null) {
                val = this.newInstance(key, state);
                this.cache.put(key, val);
            }
            return val;
        }
    }

    public void remove(KEY key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.cache.remove(key);
    }

    protected abstract VAL newInstance(KEY var1, STATE var2);

    public void clear() {
        this.cache.clear();
    }

    public Iterator<Map.Entry<KEY, WeakReference<VAL>>> entryIterator() {
        return this.cache.entryIterator();
    }
}

