/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.util.InnerCause;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class Latch {
    protected static final transient Logger log = Logger.getLogger(Latch.class);
    private final AtomicLong counter = new AtomicLong();
    private final ReentrantLock lock;
    private final Condition cond;
    private final String name;

    public String toString() {
        return this.getClass().getName() + "{" + (this.name == null ? "" : "name=" + this.name + ",") + "counter=" + this.counter + "}";
    }

    public Latch() {
        this(null, null);
    }

    public Latch(ReentrantLock lock) {
        this(null, lock);
    }

    public Latch(String name, ReentrantLock lock) {
        this.name = name;
        this.lock = lock == null ? new ReentrantLock() : lock;
        this.cond = this.lock.newCondition();
    }

    public long get() {
        return this.counter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long inc() {
        this.lock.lock();
        try {
            long c = this.counter.incrementAndGet();
            if (c <= 0L) {
                throw new IllegalStateException(this.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug(this.toString());
            }
            long l = c;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGet(long delta) {
        this.lock.lock();
        try {
            if (this.counter.get() + delta < 0L) {
                throw new IllegalStateException(this.toString());
            }
            long c = this.counter.addAndGet(delta);
            if (log.isDebugEnabled()) {
                log.debug(this.toString());
            }
            if (c == 0L) {
                this._signal();
            }
            long l = c;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dec() {
        this.lock.lock();
        try {
            if (this.counter.get() <= 0L) {
                throw new IllegalStateException(this.toString());
            }
            long c = this.counter.decrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(this.toString());
            }
            if (c == 0L) {
                this._signal();
            }
            long l = c;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void _signal() {
        block5: {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (log.isInfoEnabled()) {
                log.info("signalAll()");
            }
            this.cond.signalAll();
            try {
                this.signal();
            }
            catch (InterruptedException t) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                log.error(this.toString(), t);
                if (!InnerCause.isInnerCause(t, InterruptedException.class)) break block5;
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void signal() throws InterruptedException {
    }

    public void await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.nanoTime();
        long nanos = unit.toNanos(timeout);
        long remaining = nanos;
        if (this.lock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            try {
                long c;
                remaining = nanos - (System.nanoTime() - start);
                while ((c = this.counter.get()) != 0L) {
                    if (c < 0L) {
                        throw new IllegalStateException(this.toString());
                    }
                    if (remaining > 0L) {
                        remaining = this.cond.awaitNanos(remaining);
                        continue;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }
}

