/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class MovingAverageTask
implements Runnable {
    protected static final Logger log = Logger.getLogger(MovingAverageTask.class);
    protected final String name;
    protected final Callable<? extends Number> sampleTask;
    protected final double w;
    protected long nsamples = 0L;
    protected double average = 0.0;
    public static final double DEFAULT_WEIGHT = 0.2;

    public double getMovingAverage() {
        return this.average;
    }

    public double getWeight() {
        return this.w;
    }

    public long getSampleCount() {
        return this.nsamples;
    }

    public MovingAverageTask(String name, Callable<? extends Number> sampleTask) {
        this(name, sampleTask, 0.2);
    }

    public MovingAverageTask(String name, Callable<? extends Number> sampleTask, double w) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (sampleTask == null) {
            throw new IllegalArgumentException();
        }
        if (w <= 0.0 || w >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.sampleTask = sampleTask;
        this.w = w;
    }

    protected static final double getMovingAverage(double avg, double q, double w) {
        return (1.0 - w) * avg + w * q;
    }

    @Override
    public void run() {
        try {
            double sample = this.sampleTask.call().doubleValue();
            this.average = MovingAverageTask.getMovingAverage(this.average, sample, this.w);
            ++this.nsamples;
        }
        catch (Exception ex) {
            log.warn(this.name, ex);
        }
    }
}

