/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ShutdownHelper {
    protected static final Logger log = Logger.getLogger(ShutdownHelper.class);
    private long elapsed;

    public ShutdownHelper(ExecutorService executorService) throws InterruptedException {
        this(executorService, Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public ShutdownHelper(ExecutorService executorService, long logTimeout, TimeUnit unit) throws InterruptedException {
        long begin;
        if (executorService == null) {
            throw new IllegalArgumentException();
        }
        if (logTimeout <= 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        long lastLogTime = begin = System.nanoTime();
        logTimeout = unit.toNanos(logTimeout);
        executorService.shutdown();
        long awaitTimeout = 100L;
        while (!executorService.isTerminated() && !executorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            this.elapsed = System.nanoTime() - begin;
            long now = System.nanoTime();
            long elapsedLogTime = now - lastLogTime;
            if (elapsedLogTime >= logTimeout) {
                try {
                    this.logTimeout();
                }
                catch (Throwable t) {
                    log.error("Ignored", t);
                }
            }
            lastLogTime = now;
        }
    }

    public long elapsed() {
        return this.elapsed;
    }

    protected void logTimeout() {
    }
}

