/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ThreadGuard {
    private static final transient Logger log = Logger.getLogger(ThreadGuard.class);
    private final ConcurrentHashMap<Thread, AtomicInteger> threads = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guard(Runnable r) {
        this.incThread();
        try {
            r.run();
        }
        finally {
            this.decThread();
        }
    }

    public void guard(Guard r) throws InterruptedException {
        this.incThread();
        try {
            r.run();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.decThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T guard(Callable<T> r) throws Exception {
        this.incThread();
        try {
            T t = r.call();
            return t;
        }
        finally {
            this.decThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incThread() {
        ConcurrentHashMap<Thread, AtomicInteger> concurrentHashMap = this.threads;
        synchronized (concurrentHashMap) {
            Thread t = Thread.currentThread();
            AtomicInteger tmp = this.threads.get(t);
            if (tmp == null) {
                this.threads.put(t, new AtomicInteger(1));
            } else {
                tmp.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decThread() {
        ConcurrentHashMap<Thread, AtomicInteger> concurrentHashMap = this.threads;
        synchronized (concurrentHashMap) {
            Thread t = Thread.currentThread();
            AtomicInteger tmp = this.threads.get(t);
            if (tmp == null) {
                throw new AssertionError();
            }
            if (tmp.decrementAndGet() == 0) {
                this.threads.remove(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        ConcurrentHashMap<Thread, AtomicInteger> concurrentHashMap = this.threads;
        synchronized (concurrentHashMap) {
            for (Map.Entry<Thread, AtomicInteger> e : this.threads.entrySet()) {
                Thread t = e.getKey();
                int counter = e.getValue().get();
                t.interrupt();
                log.warn("Interrupted: " + t.getName() + "@counter=" + counter);
            }
        }
    }

    public static abstract class Guard {
        public abstract void run() throws InterruptedException;
    }
}

