/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.util.concurrent.MovingAverageTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ThreadPoolExecutorBaseStatisticsTask
implements Runnable {
    private static final Logger log = Logger.getLogger(ThreadPoolExecutorBaseStatisticsTask.class);
    protected final ThreadPoolExecutor service;
    protected final long startNanos;
    protected final double w;
    static final double scalingFactor = 1.0 / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private final MovingAverageTask queueSizeTask;
    private final MovingAverageTask activeCountTask;
    private final MovingAverageTask queueLengthTask;
    private final MovingAverageTask poolSizeTask;

    public ThreadPoolExecutorBaseStatisticsTask(ThreadPoolExecutor service) {
        this(service, 0.2);
    }

    public ThreadPoolExecutorBaseStatisticsTask(final ThreadPoolExecutor service, double w) {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (w <= 0.0 || w >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.service = service;
        this.startNanos = System.nanoTime();
        this.w = w;
        this.queueSizeTask = new MovingAverageTask("queueSize", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return service.getQueue().size();
            }
        }, w);
        this.activeCountTask = new MovingAverageTask("activeCount", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return service.getActiveCount();
            }
        }, w);
        this.queueLengthTask = new MovingAverageTask("queueLength", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return service.getQueue().size() + service.getActiveCount();
            }
        }, w);
        this.poolSizeTask = new MovingAverageTask("poolSize", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return service.getPoolSize();
            }
        }, w);
    }

    @Override
    public void run() {
        try {
            this.queueSizeTask.run();
            this.activeCountTask.run();
            this.queueLengthTask.run();
            this.poolSizeTask.run();
        }
        catch (Exception ex) {
            log.error(this, ex);
        }
    }

    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("Average Queue Size", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(ThreadPoolExecutorBaseStatisticsTask.this.queueSizeTask.getMovingAverage());
            }
        });
        counterSet.addCounter("Average Active Count", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(ThreadPoolExecutorBaseStatisticsTask.this.activeCountTask.getMovingAverage());
            }
        });
        counterSet.addCounter("Average Queue Length", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(ThreadPoolExecutorBaseStatisticsTask.this.queueLengthTask.getMovingAverage());
            }
        });
        counterSet.addCounter("Task Complete Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(ThreadPoolExecutorBaseStatisticsTask.this.service.getCompletedTaskCount());
            }
        });
        counterSet.addCounter("Pool Size", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(ThreadPoolExecutorBaseStatisticsTask.this.poolSizeTask.getMovingAverage());
            }
        });
        counterSet.addCounter("Largest Pool Size", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(ThreadPoolExecutorBaseStatisticsTask.this.service.getLargestPoolSize());
            }
        });
        return counterSet;
    }
}

