/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.journal.WriteExecutorService;
import com.bigdata.util.concurrent.DeltaMovingAverageTask;
import com.bigdata.util.concurrent.MovingAverageTask;
import com.bigdata.util.concurrent.TaskCounters;
import com.bigdata.util.concurrent.WriteTaskCounters;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ThreadPoolExecutorStatisticsTask
implements Runnable {
    private static final Logger log = Logger.getLogger(ThreadPoolExecutorStatisticsTask.class);
    private final String serviceName;
    private final WeakReference<ThreadPoolExecutor> serviceRef;
    private final double w;
    private long nsamples = 0L;
    private double averageActiveCount = 0.0;
    private double averageQueueLength = 0.0;
    private double averageActiveCountWithLocksHeld = 0.0;
    private final TaskCounters taskCounters;
    private double averageQueueWaitingTime = 0.0;
    private double averageLockWaitingTime = 0.0;
    private double averageServiceTime = 0.0;
    private double averageCheckpointTime = 0.0;
    private double averageQueuingTime = 0.0;
    private double averageCommitWaitingTime = 0.0;
    private double averageCommitServiceTime = 0.0;
    private double averageCommitGroupSize = 0.0;
    private double averageByteCountPerCommit = 0.0;
    private long queueWaitingTime = 0L;
    private long lockWaitingTime = 0L;
    private long serviceTime = 0L;
    private long checkpointTime = 0L;
    private long queuingTime = 0L;
    private long commitWaitingTime = 0L;
    private long commitServiceTime = 0L;
    private double averageReadyCount;
    static final double scalingFactor = 1.0 / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    public static final double DEFAULT_WEIGHT = 0.2;
    private final MovingAverageTask queueSizeTask = new MovingAverageTask("queueSize", (Callable<? extends Number>)new Callable<Integer>(){

        @Override
        public Integer call() {
            return ThreadPoolExecutorStatisticsTask.this.getService().getQueue().size();
        }
    });
    private DeltaMovingAverageTask interArrivalNanoTimeTask = new DeltaMovingAverageTask("interArrivalTime", (Callable<? extends Number>)new Callable<Long>(){

        @Override
        public Long call() {
            return ((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.interArrivalNanoTime.get();
        }
    });
    private DeltaMovingAverageTask serviceNanoTimeTask = new DeltaMovingAverageTask("serviceNanoTime", (Callable<? extends Number>)new Callable<Long>(){

        @Override
        public Long call() {
            return ((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.serviceNanoTime.get();
        }
    });

    private ThreadPoolExecutor getService() {
        ThreadPoolExecutor service = (ThreadPoolExecutor)this.serviceRef.get();
        if (service == null) {
            throw new RuntimeException("Service was shutdown.");
        }
        return service;
    }

    public double getWeight() {
        return this.w;
    }

    public long getSampleCount() {
        return this.nsamples;
    }

    public ThreadPoolExecutorStatisticsTask(String serviceName, ThreadPoolExecutor service) {
        this(serviceName, service, null, 0.2);
    }

    public ThreadPoolExecutorStatisticsTask(String serviceName, ThreadPoolExecutor service, TaskCounters taskCounters) {
        this(serviceName, service, taskCounters, 0.2);
    }

    public ThreadPoolExecutorStatisticsTask(String serviceName, ThreadPoolExecutor service, TaskCounters taskCounters, double w) {
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (w <= 0.0 || w >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.serviceName = serviceName;
        this.serviceRef = new WeakReference<ThreadPoolExecutor>(service);
        this.taskCounters = taskCounters;
        this.w = w;
    }

    public double getMovingAverage(double avg, double q, double w) {
        return (1.0 - w) * avg + w * q;
    }

    @Override
    public void run() {
        ThreadPoolExecutor service = this.getService();
        try {
            this.queueSizeTask.run();
            int queueSize = service.getQueue().size();
            int activeCount = service.getActiveCount();
            this.averageActiveCount = this.getMovingAverage(this.averageActiveCount, activeCount, this.w);
            this.averageQueueLength = this.getMovingAverage(this.averageQueueLength, activeCount + queueSize, this.w);
            if (service instanceof WriteExecutorService) {
                int activeCountWithLocksHeld = ((WriteExecutorService)service).getActiveTaskCountWithLocksHeld();
                this.averageActiveCountWithLocksHeld = this.getMovingAverage(this.averageActiveCountWithLocksHeld, activeCountWithLocksHeld, this.w);
            }
            if (this.taskCounters != null) {
                long taskCount = this.taskCounters.taskCompleteCount.get();
                if (taskCount > 0L) {
                    long newValue = this.taskCounters.queueWaitingNanoTime.get();
                    long delta = newValue - this.queueWaitingTime;
                    assert (delta >= 0L) : "" + delta;
                    this.queueWaitingTime = newValue;
                    this.averageQueueWaitingTime = this.getMovingAverage(this.averageQueueWaitingTime, (double)delta * scalingFactor / (double)this.taskCounters.taskCompleteCount.get(), this.w);
                    if (service instanceof WriteExecutorService) {
                        newValue = ((WriteTaskCounters)this.taskCounters).lockWaitingNanoTime.get();
                        delta = newValue - this.lockWaitingTime;
                        assert (delta >= 0L) : "" + delta;
                        this.lockWaitingTime = newValue;
                        this.averageLockWaitingTime = this.getMovingAverage(this.averageLockWaitingTime, (double)delta * scalingFactor / (double)this.taskCounters.taskCompleteCount.get(), this.w);
                    }
                    newValue = this.taskCounters.serviceNanoTime.get();
                    delta = newValue - this.serviceTime;
                    assert (delta >= 0L) : "" + delta;
                    this.serviceTime = newValue;
                    this.averageServiceTime = this.getMovingAverage(this.averageServiceTime, (double)delta * scalingFactor / (double)this.taskCounters.taskCompleteCount.get(), this.w);
                    this.interArrivalNanoTimeTask.run();
                    this.serviceNanoTimeTask.run();
                    newValue = this.taskCounters.checkpointNanoTime.get();
                    delta = newValue - this.checkpointTime;
                    assert (delta >= 0L) : "" + delta;
                    this.checkpointTime = newValue;
                    this.averageCheckpointTime = this.getMovingAverage(this.averageCheckpointTime, (double)delta * scalingFactor / (double)this.taskCounters.taskCompleteCount.get(), this.w);
                    newValue = this.taskCounters.queuingNanoTime.get();
                    delta = newValue - this.queuingTime;
                    assert (delta >= 0L) : "" + delta;
                    this.queuingTime = newValue;
                    this.averageQueuingTime = this.getMovingAverage(this.averageQueuingTime, (double)delta * scalingFactor / (double)this.taskCounters.taskCompleteCount.get(), this.w);
                }
                if (service instanceof WriteExecutorService) {
                    WriteExecutorService tmp = (WriteExecutorService)service;
                    WriteTaskCounters writeTaskCounters = (WriteTaskCounters)this.taskCounters;
                    long groupCommitCount = tmp.getGroupCommitCount();
                    if (groupCommitCount > 0L) {
                        long newValue = writeTaskCounters.commitWaitingNanoTime.get();
                        long delta = newValue - this.commitWaitingTime;
                        assert (delta >= 0L) : "" + delta;
                        this.commitWaitingTime = newValue;
                        this.averageCommitWaitingTime = this.getMovingAverage(this.averageCommitWaitingTime, (double)delta * scalingFactor / (double)groupCommitCount, this.w);
                        newValue = writeTaskCounters.commitServiceNanoTime.get();
                        delta = newValue - this.commitServiceTime;
                        assert (delta >= 0L) : "" + delta;
                        this.commitServiceTime = newValue;
                        this.averageCommitServiceTime = this.getMovingAverage(this.averageCommitServiceTime, (double)delta * scalingFactor / (double)groupCommitCount, this.w);
                    }
                    this.averageReadyCount = this.getMovingAverage(this.averageReadyCount, tmp.getReadyCount(), this.w);
                    this.averageCommitGroupSize = this.getMovingAverage(this.averageCommitGroupSize, tmp.getCommitGroupSize(), this.w);
                    this.averageByteCountPerCommit = this.getMovingAverage(this.averageByteCountPerCommit, tmp.getByteCountPerCommit(), this.w);
                }
            }
            ++this.nsamples;
        }
        catch (Exception ex) {
            log.warn(this.serviceName, ex);
        }
    }

    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        final ThreadPoolExecutor service = (ThreadPoolExecutor)this.serviceRef.get();
        counterSet.addCounter("Average Queue Size", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(ThreadPoolExecutorStatisticsTask.this.queueSizeTask.getMovingAverage());
            }
        });
        if (service != null) {
            if (this.taskCounters == null) {
                counterSet.addCounter("Task Complete Count", new Instrument<Long>(){

                    @Override
                    public void sample() {
                        this.setValue(service.getCompletedTaskCount());
                    }
                });
            }
            counterSet.addCounter("Pool Size", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(service.getPoolSize());
                }
            });
            counterSet.addCounter("Largest Pool Size", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(service.getLargestPoolSize());
                }
            });
        }
        counterSet.addCounter("Average Active Count", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(ThreadPoolExecutorStatisticsTask.this.averageActiveCount);
            }
        });
        counterSet.addCounter("Average Queue Length", new Instrument<Double>(){

            @Override
            protected void sample() {
                this.setValue(ThreadPoolExecutorStatisticsTask.this.averageQueueLength);
            }
        });
        if (this.taskCounters != null) {
            counterSet.addCounter("Task Submit Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.taskSubmitCount.get());
                }
            });
            counterSet.addCounter("Task Complete Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.taskCompleteCount.get());
                }
            });
            counterSet.addCounter("Task Failed Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.taskFailCount.get());
                }
            });
            counterSet.addCounter("Task Success Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.taskSuccessCount.get());
                }
            });
            counterSet.addCounter("Inter Arrival Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(TimeUnit.NANOSECONDS.toMillis(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.interArrivalNanoTime.get()));
                }
            });
            counterSet.addCounter("Queue Waiting Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(TimeUnit.NANOSECONDS.toMillis(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.queueWaitingNanoTime.get()));
                }
            });
            counterSet.addCounter("Service Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(TimeUnit.NANOSECONDS.toMillis(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.serviceNanoTime.get()));
                }
            });
            counterSet.addCounter("Checkpoint Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(TimeUnit.NANOSECONDS.toMillis(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.checkpointNanoTime.get()));
                }
            });
            counterSet.addCounter("Queuing Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(TimeUnit.NANOSECONDS.toMillis(((ThreadPoolExecutorStatisticsTask)ThreadPoolExecutorStatisticsTask.this).taskCounters.queuingNanoTime.get()));
                }
            });
            counterSet.addCounter("Average Arrival Rate", new Instrument<Double>(){

                @Override
                protected void sample() {
                    double t = ThreadPoolExecutorStatisticsTask.this.interArrivalNanoTimeTask.getMovingAverage() * scalingFactor;
                    if (t != 0.0) {
                        this.setValue(1.0 / t);
                    }
                }
            });
            counterSet.addCounter("Average Service Rate", new Instrument<Double>(){

                @Override
                protected void sample() {
                    double t = ThreadPoolExecutorStatisticsTask.this.serviceNanoTimeTask.getMovingAverage() * scalingFactor;
                    if (t != 0.0) {
                        this.setValue(1.0 / t);
                    }
                }
            });
            counterSet.addCounter("Average Queue Waiting Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageQueueWaitingTime);
                }
            });
            counterSet.addCounter("Average Service Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageServiceTime);
                }
            });
            counterSet.addCounter("Average Queuing Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageQueuingTime);
                }
            });
        }
        if (service instanceof WriteExecutorService) {
            final WriteExecutorService writeService = (WriteExecutorService)service;
            counterSet.addCounter("Commit Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getGroupCommitCount());
                }
            });
            counterSet.addCounter("Abort Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getAbortCount());
                }
            });
            counterSet.addCounter("Overflow Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getOverflowCount());
                }
            });
            counterSet.addCounter("Rejected Execution Count", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getRejectedExecutionCount());
                }
            });
            counterSet.addCounter("Max Commit Waiting Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getMaxCommitWaitingTime());
                }
            });
            counterSet.addCounter("Max Commit Service Time", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getMaxCommitServiceTime());
                }
            });
            counterSet.addCounter("Max Commit Group Size", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(Long.valueOf(writeService.getMaxCommitGroupSize()));
                }
            });
            counterSet.addCounter("Max Running", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(writeService.getMaxRunning());
                }
            });
            counterSet.addCounter("Average Active Count With Locks Held", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageActiveCountWithLocksHeld);
                }
            });
            counterSet.addCounter("Average Ready Count", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageReadyCount);
                }
            });
            counterSet.addCounter("Average Commit Group Size", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageCommitGroupSize);
                }
            });
            counterSet.addCounter("Average Lock Waiting Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageLockWaitingTime);
                }
            });
            counterSet.addCounter("Average Checkpoint Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageCheckpointTime);
                }
            });
            counterSet.addCounter("Average Commit Waiting Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageCommitWaitingTime);
                }
            });
            counterSet.addCounter("Average Commit Service Time", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageCommitServiceTime);
                }
            });
            counterSet.addCounter("Average Byte Count Per Commit", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue(ThreadPoolExecutorStatisticsTask.this.averageByteCountPerCommit);
                }
            });
        }
        return counterSet;
    }
}

