/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.config;

import com.bigdata.util.config.LogUtil;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jLoggingHandler
extends Handler {
    private final Logger log4jLogger;

    public Log4jLoggingHandler() {
        String log4jLoggerName = LogManager.getLogManager().getProperty("com.bigdata.util.config.Log4jLoggingHandler.loggername");
        this.log4jLogger = log4jLoggerName != null && !log4jLoggerName.equals("") ? LogUtil.getLog4jLogger(log4jLoggerName) : LogUtil.getLog4jRootLogger();
        this.setLevel(Level.FINEST);
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        String formattedMessage;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            formattedMessage = this.getFormatter().formatMessage(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        this.log4jLogger.callAppenders(new XLoggingEvent(this.log4jLogger, record, formattedMessage));
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    static class XLoggingEvent
    extends LoggingEvent {
        private final String origLoggerName;

        public XLoggingEvent(Logger log4jLogger, LogRecord record, String formattedMessage) {
            super("org.apache.log4j.Logger", log4jLogger, record.getMillis(), XLoggingEvent.translateLevel(record.getLevel()), formattedMessage, record.getThrown());
            this.origLoggerName = record.getLoggerName();
        }

        @Override
        public String getLoggerName() {
            return this.origLoggerName;
        }

        protected static org.apache.log4j.Level translateLevel(Level level) {
            int lv = level.intValue();
            if (lv > Level.SEVERE.intValue()) {
                return org.apache.log4j.Level.FATAL;
            }
            if (lv == Level.SEVERE.intValue()) {
                return org.apache.log4j.Level.ERROR;
            }
            if (lv >= Level.WARNING.intValue()) {
                return org.apache.log4j.Level.WARN;
            }
            if (lv >= Level.INFO.intValue()) {
                return org.apache.log4j.Level.INFO;
            }
            if (lv >= Level.CONFIG.intValue()) {
                return org.apache.log4j.Level.INFO;
            }
            if (lv >= Level.FINE.intValue()) {
                return org.apache.log4j.Level.DEBUG;
            }
            return org.apache.log4j.Level.TRACE;
        }
    }
}

