/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.config;

import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class LogUtil {
    static String getConfigPropertyValue() {
        String log4jConfig = System.getProperty("log4j.primary.configuration");
        if (log4jConfig != null) {
            return log4jConfig;
        }
        String log4jDefaultConfig = System.getProperty("log4j.configuration");
        if (log4jDefaultConfig != null) {
            return log4jDefaultConfig;
        }
        return null;
    }

    static URL getConfigPropertyValueUrl() {
        URL url = LogUtil.class.getResource("/log4j.properties");
        if (url == null) {
            url = LogUtil.class.getResource("/log4j.logging");
        }
        if (url == null) {
            url = LogUtil.class.getResource("/log4j.xml");
        }
        return url;
    }

    public static Logger getLog4jLogger(String componentName) {
        return Logger.getLogger(componentName);
    }

    public static Logger getLog4jLogger(Class componentClass) {
        return Logger.getLogger(componentClass);
    }

    public static Logger getLog4jRootLogger() {
        return Logger.getRootLogger();
    }

    static {
        boolean quiet = Boolean.getBoolean("com.bigdata.util.config.LogUtil.quiet");
        String log4jConfig = LogUtil.getConfigPropertyValue();
        if (log4jConfig != null && (log4jConfig.endsWith(".properties") || log4jConfig.endsWith(".logging"))) {
            PropertyConfigurator.configureAndWatch(log4jConfig);
            if (!quiet) {
                System.out.println("INFO: " + LogUtil.class.getName() + ": Configure and watch: " + log4jConfig);
            }
        } else if (log4jConfig != null && log4jConfig.endsWith(".xml")) {
            DOMConfigurator.configureAndWatch(log4jConfig);
            if (!quiet) {
                System.out.println("INFO: " + LogUtil.class.getName() + ": Configure and watch: " + log4jConfig);
            }
        } else {
            URL log4jUrl = LogUtil.getConfigPropertyValueUrl();
            if (log4jUrl != null && (log4jUrl.getFile().endsWith(".properties") || log4jUrl.getFile().endsWith(".logging"))) {
                PropertyConfigurator.configure(log4jUrl);
                if (!quiet) {
                    System.out.println("INFO: " + LogUtil.class.getName() + ": Configure: " + log4jUrl);
                }
            } else if (log4jUrl != null && log4jUrl.getFile().endsWith(".xml")) {
                DOMConfigurator.configure(log4jUrl);
                if (!quiet) {
                    System.out.println("INFO: " + LogUtil.class.getName() + ": Configure: " + log4jUrl);
                }
            } else {
                System.err.println("ERROR: " + LogUtil.class.getName() + " : Could not initialize Log4J logging utility.\n" + "Set system property " + "'-Dlog4j.configuration=" + "file:bigdata/src/resources/logging/log4j.properties'" + "\n  and / or \n" + "Set system property " + "'-Dlog4j.primary.configuration=" + "file:<installDir>/" + "bigdata/src/resources/logging/log4j.properties'");
            }
        }
    }

    public static interface Options {
        public static final String QUIET = "com.bigdata.util.config.LogUtil.quiet";
    }
}

