/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.config;

import com.bigdata.util.config.LogUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NicUtil {
    private static final org.apache.log4j.Logger utilLogger = LogUtil.getLog4jLogger(NicUtil.class);
    private static final Logger jiniConfigLogger = Logger.getLogger("net.jini.config");
    private static final Level WARNING = Level.WARNING;
    private static final Level INFO = Level.INFO;
    private static final Level CONFIG = Level.CONFIG;
    private static long cacheTimeout = 60000L;
    private static AddrCache<String> loopbackCache = new AddrCache();
    private static AddrCache<String> nonLoopbackCache = new AddrCache();

    private NicUtil() {
        throw new AssertionError((Object)"com.bigdata.util.NicUtil cannot be instantiated");
    }

    public static NetworkInterface getNetworkInterface(String name) throws SocketException {
        NetworkInterface nic = NetworkInterface.getByName(name);
        if (nic == null) {
            InetAddress targetIp = null;
            try {
                targetIp = InetAddress.getByName(name);
                nic = NetworkInterface.getByInetAddress(targetIp);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return nic;
    }

    public static Map<InetAddress, String> getInetAddressMap() throws SocketException {
        HashMap<InetAddress, String> retMap = new HashMap<InetAddress, String>();
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            NetworkInterface curNic = nics.nextElement();
            Enumeration<InetAddress> curNicAddrs = curNic.getInetAddresses();
            String curNicName = curNic.getName();
            while (curNicAddrs.hasMoreElements()) {
                retMap.put(curNicAddrs.nextElement(), curNicName);
            }
        }
        return retMap;
    }

    public static NetworkInterface[] getNetworkInterfaceArray(String name) throws SocketException {
        NetworkInterface[] nics = null;
        if (name.equals("all")) {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> nicList = en != null ? Collections.list(en) : Collections.EMPTY_LIST;
            nics = nicList.toArray(new NetworkInterface[nicList.size()]);
        } else {
            nics = new NetworkInterface[]{NetworkInterface.getByName(name)};
            if (nics[0] == null) {
                InetAddress targetIp = null;
                try {
                    targetIp = InetAddress.getByName(name);
                    nics[0] = NetworkInterface.getByInetAddress(targetIp);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return nics;
    }

    public static InetAddress getInetAddress(String name, int index, String host, boolean localHost) {
        if (name == null && host == null && !localHost) {
            throw new NullPointerException("name cannot be null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        NetworkInterface nic = null;
        try {
            nic = NicUtil.getNetworkInterface(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nic != null) {
            List<InterfaceAddress> interfaceAddrs = nic.getInterfaceAddresses();
            if (interfaceAddrs.size() == 0) {
                return null;
            }
            int inet4AddrIndex = 0;
            for (int i = 0; i < interfaceAddrs.size(); ++i) {
                InetAddress inetAddr = interfaceAddrs.get(i).getAddress();
                if (!(inetAddr instanceof Inet4Address)) continue;
                if (index == inet4AddrIndex) {
                    Inet4Address inet4Addr = (Inet4Address)inetAddr;
                    String hostAddr = inet4Addr.getHostAddress();
                    String hostName = inet4Addr.getCanonicalHostName();
                    jiniConfigLogger.log(CONFIG, "Inet4: address = " + hostAddr + ", name = " + hostName);
                    utilLogger.log(org.apache.log4j.Level.TRACE, "Inet4: address = " + hostAddr + ", name = " + hostName);
                    return inetAddr;
                }
                ++inet4AddrIndex;
            }
        }
        InetAddress fallback = null;
        if (host != null) {
            try {
                fallback = InetAddress.getByName(host);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fallback != null) {
                jiniConfigLogger.log(CONFIG, "fallback host = " + fallback);
                utilLogger.log(org.apache.log4j.Level.TRACE, "fallback host = " + fallback);
                return fallback;
            }
        }
        if (localHost) {
            try {
                fallback = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                // empty catch block
            }
            jiniConfigLogger.log(CONFIG, "fallback local host = " + fallback);
            utilLogger.log(org.apache.log4j.Level.TRACE, "fallback local host = " + fallback);
        }
        return fallback;
    }

    public static String getMacAddress(String name) throws SocketException {
        String macAddr = null;
        NetworkInterface nic = NicUtil.getNetworkInterface(name);
        byte[] hwAddr = nic.getHardwareAddress();
        if (hwAddr != null && hwAddr.length > 0) {
            StringBuffer strBuf = new StringBuffer();
            for (int i = 0; i < hwAddr.length; ++i) {
                String subStr = String.format("%02X", hwAddr[i]);
                if (i == 0) {
                    strBuf.append(subStr);
                    continue;
                }
                strBuf.append(":" + subStr);
            }
            macAddr = strBuf.toString();
        }
        return macAddr;
    }

    public static String getIpAddress(String name) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, 0, name, false);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String name, int index) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, index, name, false);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String name, String host) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, 0, host, false);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String name, int index, String host) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, index, host, false);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String name, int index, String host, boolean localHost) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, index, host, localHost);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String name, boolean localHost) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, 0, name, localHost);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String name, int index, boolean localHost) {
        InetAddress inetAddr = NicUtil.getInetAddress(name, index, name, localHost);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddressByHost(String host) {
        InetAddress inetAddr = NicUtil.getInetAddress(null, 0, host, false);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddressByHost(String host, boolean localHost) {
        InetAddress inetAddr = NicUtil.getInetAddress(null, 0, host, localHost);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddressByLocalHost() {
        InetAddress inetAddr = NicUtil.getInetAddress(null, 0, null, true);
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String getIpAddress(String systemPropertyName, String defaultNic, boolean loopbackOk) throws SocketException, IOException {
        if (systemPropertyName != null) {
            String nicName = System.getProperty(systemPropertyName);
            boolean propSet = true;
            if (nicName == null) {
                propSet = false;
            } else {
                String rawProp = "${" + systemPropertyName + "}";
                if (rawProp.equals(nicName)) {
                    propSet = false;
                }
            }
            if (propSet) {
                return NicUtil.getIpAddress(nicName, 0, loopbackOk);
            }
            if (defaultNic != null) {
                if (defaultNic.equals("default")) {
                    return NicUtil.getDefaultIpv4Address(loopbackOk);
                }
                return NicUtil.getIpAddress(defaultNic, 0, loopbackOk);
            }
            return null;
        }
        if (defaultNic != null) {
            if (defaultNic.equals("default")) {
                return NicUtil.getDefaultIpv4Address(loopbackOk);
            }
            return NicUtil.getIpAddress(defaultNic, 0, loopbackOk);
        }
        return NicUtil.getIpAddress(null, loopbackOk);
    }

    public static String getDefaultIpv4Address(boolean loopbackOk) throws SocketException, IOException {
        boolean isReachable;
        boolean isLoopbackAddress;
        boolean isIpv4;
        InetAddress inetAddr;
        List<InterfaceAddress> interfaceAddrs;
        NetworkInterface curNic;
        int timeout = 3000;
        String cached = nonLoopbackCache.get();
        if (cached != null) {
            return cached;
        }
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            curNic = nics.nextElement();
            interfaceAddrs = curNic.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddr : interfaceAddrs) {
                inetAddr = interfaceAddr.getAddress();
                isIpv4 = inetAddr instanceof Inet4Address;
                isLoopbackAddress = inetAddr.isLoopbackAddress();
                if (!isIpv4 || isLoopbackAddress || !(isReachable = inetAddr.isReachable(3000))) continue;
                Inet4Address inet4Addr = (Inet4Address)inetAddr;
                String retVal = inet4Addr.getHostAddress();
                jiniConfigLogger.log(CONFIG, "default IPv4 address: " + retVal);
                utilLogger.log(org.apache.log4j.Level.TRACE, "default IPv4 address: " + retVal);
                nonLoopbackCache.set(retVal);
                return retVal;
            }
        }
        if (!loopbackOk) {
            return null;
        }
        cached = loopbackCache.get();
        if (cached != null) {
            return cached;
        }
        nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            curNic = nics.nextElement();
            interfaceAddrs = curNic.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddr : interfaceAddrs) {
                inetAddr = interfaceAddr.getAddress();
                isIpv4 = inetAddr instanceof Inet4Address;
                isLoopbackAddress = inetAddr.isLoopbackAddress();
                if (!isIpv4 || !isLoopbackAddress || !(isReachable = inetAddr.isReachable(3000))) continue;
                Inet4Address inet4Addr = (Inet4Address)inetAddr;
                String retVal = inet4Addr.getHostAddress();
                jiniConfigLogger.log(CONFIG, "default IPv4 address: " + retVal);
                utilLogger.log(org.apache.log4j.Level.TRACE, "default IPv4 address: " + retVal);
                loopbackCache.set(retVal);
                return retVal;
            }
        }
        return null;
    }

    public static String getDefaultIpv4Address() throws SocketException, IOException {
        return NicUtil.getDefaultIpv4Address(false);
    }

    public static void main(String[] args) {
        String ipAddress = "NIC_DOES_NOT_EXIST";
        try {
            if (args.length == 0) {
                ipAddress = NicUtil.getIpAddressByLocalHost();
            } else if (args[0].equals("getIpAddressByLocalHost")) {
                ipAddress = NicUtil.getIpAddressByLocalHost();
            } else if (args[0].equals("getIpAddress")) {
                String tmpIpAddress;
                if (args.length == 2) {
                    String tmpIpAddress2 = NicUtil.getIpAddress(args[1]);
                    if (tmpIpAddress2 != null) {
                        ipAddress = tmpIpAddress2;
                    }
                } else if (args.length == 3 && (tmpIpAddress = NicUtil.getIpAddress(args[1], 0, args[2], false)) != null) {
                    ipAddress = tmpIpAddress;
                }
            } else {
                ipAddress = "NIC_UTIL_FAILURE";
                System.out.println("NicUtil Failure: unexpected number of arguments (" + args.length + ")");
            }
        }
        catch (Throwable t) {
            ipAddress = "NIC_UTIL_FAILURE";
            t.printStackTrace();
        }
        System.out.println(ipAddress);
    }

    private static class AddrCache<T> {
        private volatile T cache = null;
        private volatile long timestamp = 0L;

        private AddrCache() {
        }

        synchronized T get() {
            long now = System.currentTimeMillis();
            if (this.cache != null) {
                boolean expired;
                boolean bl = expired = now - this.timestamp > cacheTimeout;
                if (expired) {
                    this.cache = null;
                    return null;
                }
                this.timestamp = now;
                return this.cache;
            }
            return null;
        }

        synchronized void set(T addr) {
            this.cache = addr;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

