/*
 * Decompiled with CFR 0.152.
 */
package com.blazegraph.vocab.pubchem;

import com.bigdata.rdf.internal.InlineIntegerURIHandlerMap;
import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedFixedWidthIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlinePrefixedSuffixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineURIFactory;

public class PubChemInlineURIFactory
extends InlineURIFactory {
    public static final String[] uris = new String[]{"http://rdf.ncbi.nlm.nih.gov/pubchem/compound/", "http://rdf.ncbi.nlm.nih.gov/pubchem/substance/", "http://rdf.ncbi.nlm.nih.gov/pubchem/bioassay/", "http://rdf.ncbi.nlm.nih.gov/pubchem/protein/", "http://rdf.ncbi.nlm.nih.gov/pubchem/conserveddomain/", "http://rdf.ncbi.nlm.nih.gov/pubchem/gene/", "http://rdf.ncbi.nlm.nih.gov/pubchem/biosystem/", "http://rdf.ncbi.nlm.nih.gov/pubchem/reference/", "http://semanticscience.org/resource/"};
    public static final String[] localNames = new String[]{"CID", "SID", "AID", "GI", "PSSMID", "GID", "BSID", "PMID", "CHEMINF_"};
    public static final String[] descriptorSuffix = new String[]{"_XLogP3-AA", "_Undefined_Bond_Stereo_Count", "_Undefined_Atom_Stereo_Count", "_Total_Formal_Charge", "_Tautomer_Count", "_TPSA", "_Structure_Complexity", "_Rotatable_Bond_Count", "_Preferred_IUPAC_Name", "_Non-hydrogen_Atom_Count", "_Mono_Isotopic_Weight", "_Molecular_Weight", "_Molecular_Formula", "_Isotope_Atom_Count", "_Isomeric_SMILES", "_IUPAC_InChI", "_Hydrogen_Bond_Donor_Count", "_Hydrogen_Bond_Acceptor_Count", "_Exact_Mass", "_Defined_Bond_Stereo_Count", "_Defined_Atom_Stereo_Count", "_Covalent_Unit_Count", "_Compound_Identifier", "_Canonical_SMILES"};
    public static final String descriptorPrefix = "CID";
    public static final String descriptorNS = "http://rdf.ncbi.nlm.nih.gov/pubchem/descriptor/";
    public static final String oboNS = "http://purl.obolibrary.org/obo/";

    public PubChemInlineURIFactory() {
        for (int i = 0; i < uris.length; ++i) {
            this.addHandler(new InlinePrefixedIntegerURIHandler(uris[i], localNames[i]));
        }
        this.addHandler(new InlinePrefixedFixedWidthIntegerURIHandler("http://www.bioassayontology.org/bao#", "BAO_", 7));
        InlineIntegerURIHandlerMap oboMap = new InlineIntegerURIHandlerMap(oboNS);
        int i = 0;
        InlineLocalNameIntegerURIHandler handler = new InlinePrefixedIntegerURIHandler(oboNS, "CHEBI_", i);
        oboMap.addHandlerForNS(i++, handler);
        handler = new InlinePrefixedFixedWidthIntegerURIHandler(oboNS, "PR_", 9, i);
        oboMap.addHandlerForNS(i++, handler);
        handler = new InlinePrefixedFixedWidthIntegerURIHandler(oboNS, "IAO_", 7, i);
        oboMap.addHandlerForNS(i++, handler);
        handler = new InlinePrefixedFixedWidthIntegerURIHandler(oboNS, "OBI_", 7, i);
        oboMap.addHandlerForNS(i++, handler);
        this.addHandler(oboMap);
        InlineIntegerURIHandlerMap hMap = new InlineIntegerURIHandlerMap(descriptorNS);
        for (i = 0; i < descriptorSuffix.length; ++i) {
            InlinePrefixedSuffixedIntegerURIHandler h = new InlinePrefixedSuffixedIntegerURIHandler(descriptorNS, descriptorPrefix, descriptorSuffix[i], i);
            hMap.addHandlerForNS(i, h);
        }
        this.addHandler(hMap);
    }
}

