/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.sesame.SesameRDFParser;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.helpers.JSONLDMode;
import org.openrdf.rio.helpers.JSONLDSettings;
import org.openrdf.rio.helpers.RDFWriterBase;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameJSONLDWriter
extends RDFWriterBase
implements RDFWriter {
    private final Model model = new LinkedHashModel();
    private final StatementCollector statementCollector = new StatementCollector(this.model);
    private final Writer writer;

    public SesameJSONLDWriter(OutputStream outputStream) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8"))));
    }

    public SesameJSONLDWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.model.setNamespace(prefix, uri);
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.statementCollector.clear();
        this.model.clear();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        SesameRDFParser serialiser = new SesameRDFParser();
        try {
            Map<String, Object> output = JsonLdProcessor.fromRDF((Object)this.model, serialiser);
            JSONLDMode mode = this.getWriterConfig().get(JSONLDSettings.JSONLD_MODE);
            JsonLdOptions opts = new JsonLdOptions();
            opts.setUseRdfType(this.getWriterConfig().get(JSONLDSettings.USE_RDF_TYPE));
            opts.setUseNativeTypes(this.getWriterConfig().get(JSONLDSettings.USE_NATIVE_TYPES));
            if (mode == JSONLDMode.EXPAND) {
                output = JsonLdProcessor.expand(output, opts);
            }
            Object inframe = null;
            if (mode == JSONLDMode.FLATTEN) {
                output = JsonLdProcessor.flatten(output, inframe, opts);
            }
            if (mode == JSONLDMode.COMPACT) {
                LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
                SesameJSONLDWriter.addPrefixes(ctx, this.model.getNamespaces());
                HashMap<String, LinkedHashMap<String, Object>> localCtx = new HashMap<String, LinkedHashMap<String, Object>>();
                localCtx.put("@context", ctx);
                output = JsonLdProcessor.compact(output, localCtx, opts);
            }
            if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
                JsonUtils.writePrettyPrint(this.writer, output);
            } else {
                JsonUtils.write(this.writer, output);
            }
        }
        catch (JsonLdError e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
        catch (JsonGenerationException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
        catch (JsonMappingException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
        catch (IOException e) {
            throw new RDFHandlerException("Could not render JSONLD", e);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.statementCollector.handleStatement(st);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    private static void addPrefixes(Map<String, Object> ctx, Set<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            ctx.put(ns.getPrefix(), ns.getName());
        }
    }
}

