/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.ParseErrorLogger;
import org.openrdf.rio.helpers.RDFParserHelper;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameTripleCallback
implements JsonLdTripleCallback {
    private ValueFactory vf;
    private RDFHandler handler;
    private ParserConfig parserConfig;
    private final ParseErrorListener parseErrorListener;

    public SesameTripleCallback() {
        this(new StatementCollector(new LinkedHashModel()));
    }

    public SesameTripleCallback(RDFHandler nextHandler) {
        this(nextHandler, ValueFactoryImpl.getInstance());
    }

    public SesameTripleCallback(RDFHandler nextHandler, ValueFactory vf) {
        this(nextHandler, vf, new ParserConfig(), new ParseErrorLogger());
    }

    public SesameTripleCallback(RDFHandler nextHandler, ValueFactory vf, ParserConfig parserConfig, ParseErrorListener parseErrorListener) {
        this.handler = nextHandler;
        this.vf = vf;
        this.parserConfig = parserConfig;
        this.parseErrorListener = parseErrorListener;
    }

    private void triple(String s, String p, String o, String graph) {
        if (s == null || p == null || o == null) {
            return;
        }
        Statement result = graph == null ? this.vf.createStatement(this.createResource(s), this.vf.createURI(p), this.createResource(o)) : this.vf.createStatement(this.createResource(s), this.vf.createURI(p), this.createResource(o), this.createResource(graph));
        if (this.handler != null) {
            try {
                this.handler.handleStatement(result);
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Resource createResource(String resource) {
        if (resource.equals("_:")) {
            return this.vf.createBNode();
        }
        if (resource.startsWith("_:")) {
            return this.vf.createBNode(resource.substring(2));
        }
        return this.vf.createURI(resource);
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        Literal object;
        if (s == null || p == null || value == null) {
            return;
        }
        Resource subject = this.createResource(s);
        URI predicate = this.vf.createURI(p);
        URI datatypeURI = datatype == null ? null : this.vf.createURI(datatype);
        try {
            object = RDFParserHelper.createLiteral(value, language, datatypeURI, this.getParserConfig(), this.getParserErrorListener(), this.getValueFactory());
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        Statement result = graph == null ? this.vf.createStatement(subject, predicate, object) : this.vf.createStatement(subject, predicate, object, this.createResource(graph));
        if (this.handler != null) {
            try {
                this.handler.handleStatement(result);
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ParseErrorListener getParserErrorListener() {
        return this.parseErrorListener;
    }

    public RDFHandler getHandler() {
        return this.handler;
    }

    public void setHandler(RDFHandler handler) {
        this.handler = handler;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }

    public void setValueFactory(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public Object call(RDFDataset dataset) {
        if (this.handler != null) {
            try {
                this.handler.startRDF();
                for (Map.Entry<String, String> nextNamespace : dataset.getNamespaces().entrySet()) {
                    this.handler.handleNamespace(nextNamespace.getKey(), nextNamespace.getValue());
                }
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException("Could not handle start of RDF", e);
            }
        }
        for (String graphName : dataset.keySet()) {
            List<RDFDataset.Quad> quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), graphName);
            }
        }
        if (this.handler != null) {
            try {
                this.handler.endRDF();
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException("Could not handle end of RDF", e);
            }
        }
        return this.getHandler();
    }
}

